/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.itemeditor;

import java.awt.Component;
import org.openbp.cockpit.itemeditor.NodeItemEditorPlugin;
import org.openbp.cockpit.plugins.itembrowser.NodeEditorItemBrowserPlugin;
import org.openbp.cockpit.plugins.toolbox.SocketToolBoxPlugin;
import org.openbp.core.model.item.process.Node;
import org.openbp.jaspira.action.keys.KeyMgr;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.PluginDivider;
import org.openbp.jaspira.gui.plugin.TabbedPluginContainer;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugins.colorchooser.ColorChooserPlugin;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserPlugin;

public class NodeItemEditorPage
extends JaspiraPage {
    private PropertyBrowserPlugin propertyBrowser;
    private NodeEditorItemBrowserPlugin itemBrowser;
    private NodeItemEditorPlugin nodeEditor;
    private SocketToolBoxPlugin socketToolBox;
    private ColorChooserPlugin colorChooser;

    public NodeItemEditorPlugin getNodeEditor() {
        return this.nodeEditor;
    }

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    @Override
    public void layoutDefaultContent() {
        this.setParentPlugin(ApplicationBase.getInstance());
        PluginMgr pm = PluginMgr.getInstance();
        this.propertyBrowser = (PropertyBrowserPlugin)pm.createInstance(PropertyBrowserPlugin.class, (Plugin)this);
        this.itemBrowser = (NodeEditorItemBrowserPlugin)pm.createInstance(NodeEditorItemBrowserPlugin.class, (Plugin)this);
        this.nodeEditor = (NodeItemEditorPlugin)pm.createInstance(NodeItemEditorPlugin.class, (Plugin)this);
        this.socketToolBox = (SocketToolBoxPlugin)pm.createInstance(SocketToolBoxPlugin.class, (Plugin)this);
        this.colorChooser = (ColorChooserPlugin)pm.createInstance(ColorChooserPlugin.class, (Plugin)this);
        this.colorChooser.setHelpText(this.getPluginResourceCollection().getOptionalString("chooserhelptext"));
        PluginDivider main = new PluginDivider(1);
        PluginDivider left = new PluginDivider(0);
        PluginDivider right = new PluginDivider(0);
        left.addPlugin(this.socketToolBox);
        left.addPlugin(this.itemBrowser);
        right.addPlugin(this.nodeEditor);
        TabbedPluginContainer bottomContainer = new TabbedPluginContainer();
        bottomContainer.addPlugin(this.propertyBrowser);
        bottomContainer.addPlugin(this.colorChooser);
        right.addClient(bottomContainer);
        main.addClient((Component)((Object)left));
        main.addClient((Component)((Object)right));
        left.setClientProportions(new double[]{0.3, 0.7});
        right.setClientProportions(new double[]{0.5, 0.5});
        main.setClientProportions(new double[]{0.25, 0.75});
        this.setPluginDivider(main);
        KeyMgr.getInstance().install(this.getContentPane());
    }

    @Override
    protected void pluginUninstalled() {
        super.pluginUninstalled();
        PluginMgr pm = PluginMgr.getInstance();
        pm.removeInstance(this.propertyBrowser);
        pm.removeInstance(this.itemBrowser);
        pm.removeInstance(this.nodeEditor);
        pm.removeInstance(this.socketToolBox);
        pm.removeInstance(this.colorChooser);
        KeyMgr.getInstance().uninstall(this.getContentPane());
    }

    public void saveNode() {
        this.nodeEditor.saveNode();
    }

    public void setNode(Node node) {
        this.nodeEditor.setNode(node);
    }
}

