/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.MultiSocketNodeFigure;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.PlaceholderNodeFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.process.TextElementFigure;
import org.openbp.cockpit.modeler.util.ModelerUtil;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.msgcontainer.StandardMsgContainer;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.core.CoreConstants;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.ActivityNodeImpl;
import org.openbp.core.model.item.process.ControlLink;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.NodeSocketImpl;
import org.openbp.core.model.item.process.Param;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessItemImpl;
import org.openbp.core.model.item.process.SingleSocketNode;
import org.openbp.core.model.item.process.TextElement;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.gui.interaction.MultiTransferable;
import org.openbp.jaspira.gui.interaction.SimpleTransferable;
import org.openbp.swing.components.JMsgBox;

public class ClipboardSupport {
    private final WorkspaceDrawingView workspaceView;
    private final ResourceCollection resourceCollection;
    private boolean socketsAndParamsOnly;

    public ClipboardSupport(WorkspaceDrawingView workspaceView, ResourceCollection resourceCollection, boolean socketsAndParamsOnly) {
        this.workspaceView = workspaceView;
        this.resourceCollection = resourceCollection;
        this.socketsAndParamsOnly = socketsAndParamsOnly;
    }

    public boolean canCopy() {
        FigureEnumeration fe = this.workspaceView.selectionElements();
        while (fe.hasMoreElements()) {
            Figure next = fe.nextFigure();
            if (!(next instanceof NodeFigure) && !(next instanceof TextElementFigure) && !(next instanceof SocketFigure) && !(next instanceof ParamFigure)) continue;
            return true;
        }
        return false;
    }

    public boolean canDelete() {
        FigureEnumeration fe = this.workspaceView.selectionElements();
        while (fe.hasMoreElements()) {
            NodeFigure nodeFigure;
            Node node;
            Figure next = fe.nextFigure();
            if (next instanceof NodeFigure) {
                if (this.socketsAndParamsOnly) continue;
                return true;
            }
            return !(next instanceof SocketFigure) || !((node = (nodeFigure = (NodeFigure)((SocketFigure)next).getParent()).getNode()) instanceof SingleSocketNode);
        }
        return false;
    }

    public boolean canCut() {
        return this.canDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getCopyData() {
        try {
            ((ProcessDrawing)this.workspaceView.drawing()).getProcess().maintainReferences(5);
            DataFlavor copyFlavor = null;
            ProcessItemImpl process = new ProcessItemImpl();
            process.setName("ProcessDummy");
            process.setModel(ModelConnector.getInstance().getModelByQualifier(CoreConstants.SYSTEM_MODEL_QUALIFIER));
            ActivityNodeImpl socketHolder = null;
            ArrayList<Node> copiedSourceNodes = new ArrayList<Node>();
            NodeSocketImpl paramHolder = null;
            FigureEnumeration fe = this.workspaceView.selectionElements();
            while (fe.hasMoreElements()) {
                Figure next = fe.nextFigure();
                if (next instanceof NodeFigure) {
                    NodeFigure nodeFigure = (NodeFigure)next;
                    nodeFigure.encodeGeometry();
                    Node node = nodeFigure.getNode();
                    copiedSourceNodes.add(node);
                    node = (Node)node.clone();
                    process.addNode(node);
                    copyFlavor = ClientFlavors.PROCESS_ITEM;
                    continue;
                }
                if (next instanceof TextElementFigure) {
                    TextElementFigure textElementFigure = (TextElementFigure)next;
                    textElementFigure.encodeGeometry();
                    TextElement textElement = textElementFigure.getTextElement();
                    textElement = (TextElement)textElement.clone();
                    process.addTextElement(textElement);
                    copyFlavor = ClientFlavors.PROCESS_ITEM;
                    continue;
                }
                if (next instanceof SocketFigure) {
                    SocketFigure socketFigure = (SocketFigure)next;
                    socketFigure.encodeGeometry();
                    NodeSocket socket = socketFigure.getNodeSocket();
                    if (socketHolder == null) {
                        socketHolder = new ActivityNodeImpl();
                        socketHolder.setName("NodeDummy");
                        process.addNode((Node)socketHolder);
                    }
                    socket = (NodeSocket)socket.clone();
                    socketHolder.addSocket(socket);
                    copyFlavor = ClientFlavors.NODE_SOCKETS;
                    continue;
                }
                if (!(next instanceof ParamFigure)) continue;
                ParamFigure paramFigure = (ParamFigure)next;
                NodeParam param = paramFigure.getNodeParam();
                if (paramHolder == null) {
                    if (socketHolder == null) {
                        socketHolder = new ActivityNodeImpl();
                        socketHolder.setName("NodeDummy");
                        process.addNode((Node)socketHolder);
                    }
                    paramHolder = new NodeSocketImpl();
                    paramHolder.setName("SocketDummy");
                    socketHolder.addSocket((NodeSocket)paramHolder);
                }
                param = (NodeParam)param.clone();
                paramHolder.addParam(param, -1);
                copyFlavor = ClientFlavors.NODE_PARAMS;
            }
            StandardMsgContainer msgContainer = ModelConnector.getInstance().getMsgContainer();
            msgContainer.clearMsgs();
            FigureEnumeration fe2 = this.workspaceView.selectionElements();
            while (fe2.hasMoreElements()) {
                ControlLink link;
                Figure next = fe2.nextFigure();
                if (next instanceof FlowConnection) {
                    FlowConnection flowConnection = (FlowConnection)next;
                    link = flowConnection.getControlLink();
                    if (!copiedSourceNodes.contains(link.getSourceSocket().getNode()) || !copiedSourceNodes.contains(link.getTargetSocket().getNode())) continue;
                    flowConnection.encodeGeometry();
                    link = (ControlLink)link.clone();
                    process.addControlLink(link);
                    if (msgContainer.isEmpty()) continue;
                    process.removeControlLink(link);
                    msgContainer.clearMsgs();
                    continue;
                }
                if (!(next instanceof ParamConnection)) continue;
                ParamConnection paramConnection = (ParamConnection)next;
                link = paramConnection.getDataLink();
                Param sourceParam = link.getSourceParam();
                Param targetParam = link.getTargetParam();
                if (!(sourceParam instanceof NodeParam) || !copiedSourceNodes.contains(((NodeParam)sourceParam).getSocket().getNode()) || !(targetParam instanceof NodeParam) || !copiedSourceNodes.contains(((NodeParam)targetParam).getSocket().getNode())) continue;
                paramConnection.encodeGeometry();
                link = (DataLink)link.clone();
                process.addDataLink((DataLink)link);
                if (msgContainer.isEmpty()) continue;
                process.removeDataLink((DataLink)link);
                msgContainer.clearMsgs();
            }
            process.maintainReferences(266);
            if (copyFlavor != null && (process.getNodes().hasNext() || process.getTextElements().hasNext())) {
                Transferable ret = new SimpleTransferable((Object)process, copyFlavor);
                if (copiedSourceNodes.size() == 1) {
                    Node node = (Node)copiedSourceNodes.get(0);
                    ModelQualifier qualifier = node.getQualifier();
                    MultiTransferable mt = new MultiTransferable();
                    mt.addTransferable(ret);
                    mt.addTransferable(new SimpleTransferable((Object)qualifier, ClientFlavors.MODEL_QUALIFIER));
                    ret = mt;
                }
                SimpleTransferable simpleTransferable = ret;
                return simpleTransferable;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        finally {
            ModelConnector.getInstance().getMsgContainer().clearMsgs();
        }
        return null;
    }

    public Transferable cut() {
        Transferable result = this.getCopyData();
        this.delete();
        return result;
    }

    public void delete() {
        Figure selection = null;
        boolean hasSelected = false;
        FigureEnumeration fe = this.workspaceView.selectionElements();
        while (fe.hasMoreElements()) {
            Figure next = fe.nextFigure();
            if (!hasSelected) {
                if (next instanceof ProcessElementContainer) {
                    selection = ((ProcessElementContainer)next).selectionOnDelete();
                }
                hasSelected = true;
            } else {
                selection = null;
            }
            this.workspaceView.drawing().remove(next);
        }
        if (selection != null) {
            this.workspaceView.singleSelect(selection);
        } else {
            this.workspaceView.clearSelection();
        }
        this.workspaceView.repairDamage();
    }

    public boolean canPaste(Transferable content) {
        if (content != null) {
            if (content.isDataFlavorSupported(ClientFlavors.PROCESS_ITEM)) {
                return true;
            }
            if (content.isDataFlavorSupported(ClientFlavors.NODE_SOCKETS)) {
                return true;
            }
            if (content.isDataFlavorSupported(ClientFlavors.NODE_PARAMS)) {
                return true;
            }
            if (content.isDataFlavorSupported(ClientFlavors.MODEL_QUALIFIER)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paste(Transferable content) {
        StandardMsgContainer msgContainer = ModelConnector.getInstance().getMsgContainer();
        msgContainer.clearMsgs();
        try {
            ProcessItem source;
            boolean success = false;
            if (!this.socketsAndParamsOnly) {
                if (!success && content.isDataFlavorSupported(ClientFlavors.MODEL_QUALIFIER)) {
                    ModelQualifier qualifier = (ModelQualifier)content.getTransferData(ClientFlavors.MODEL_QUALIFIER);
                    success = this.pasteQualifier(qualifier);
                }
                if (!success && content.isDataFlavorSupported(ClientFlavors.PROCESS_ITEM)) {
                    source = (ProcessItem)content.getTransferData(ClientFlavors.PROCESS_ITEM);
                    success = this.pasteProcess(source);
                }
            }
            if (!success && content.isDataFlavorSupported(ClientFlavors.NODE_SOCKETS)) {
                source = (ProcessItem)content.getTransferData(ClientFlavors.NODE_SOCKETS);
                success = this.pasteSockets(source);
            }
            if (!success && content.isDataFlavorSupported(ClientFlavors.NODE_PARAMS)) {
                source = (ProcessItem)content.getTransferData(ClientFlavors.NODE_PARAMS);
                success = this.pasteParams(source);
            }
            this.workspaceView.repairDamage();
            if (!success) {
                String msg = this.resourceCollection.getRequiredString("messages.paste");
                JMsgBox.show(null, (String)msg, (int)65536);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (!msgContainer.isEmpty()) {
                System.err.println(msgContainer.toString());
                msgContainer.clearMsgs();
            }
        }
    }

    public boolean pasteProcess(ProcessItem source) throws CloneNotSupportedException {
        ControlLink link;
        this.workspaceView.clearSelection();
        source = (ProcessItem)source.clone();
        source.setModel(ModelConnector.getInstance().getModelByQualifier(CoreConstants.SYSTEM_MODEL_QUALIFIER));
        source.maintainReferences(10);
        ProcessDrawing drawing = (ProcessDrawing)this.workspaceView.drawing();
        ProcessItem target = drawing.getProcess();
        target.maintainReferences(5);
        NamedObjectCollectionUtil.createUniqueNames((Collection)source.getNodeList(), (Collection)target.getNodeList());
        NamedObjectCollectionUtil.createUniqueNames((Collection)source.getTextElementList(), (Collection)target.getTextElementList());
        NamedObjectCollectionUtil.createUniqueNames((Collection)source.getDataLinkList(), (Collection)target.getDataLinkList());
        NamedObjectCollectionUtil.createUniqueNames((Collection)source.getControlLinkList(), (Collection)target.getControlLinkList());
        source.maintainReferences(1);
        ProcessElementContainer firstFigure = null;
        Iterator it = source.getNodes();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            target.addNode(node);
            node.maintainReferences(4);
            NodeFigure nodeFigure = drawing.createNodeFigure(node);
            if (nodeFigure == null) {
                target.removeNode(node);
                continue;
            }
            if (firstFigure == null) {
                firstFigure = nodeFigure;
            }
            this.workspaceView.add(nodeFigure);
            this.workspaceView.addToSelection(nodeFigure);
            ModelerUtil.preventOverlap(drawing, nodeFigure);
        }
        it = source.getTextElements();
        while (it.hasNext()) {
            TextElement textElement = (TextElement)it.next();
            target.addTextElement(textElement);
            textElement.maintainReferences(4);
            TextElementFigure textElementFigure = drawing.createTextElementFigure(textElement);
            if (textElementFigure == null) {
                target.removeTextElement(textElement);
                continue;
            }
            if (firstFigure == null) {
                firstFigure = textElementFigure;
            }
            this.workspaceView.add(textElementFigure);
            this.workspaceView.addToSelection(textElementFigure);
            ModelerUtil.preventOverlap(drawing, textElementFigure);
        }
        it = source.getControlLinks();
        while (it.hasNext()) {
            link = (ControlLink)it.next();
            target.addControlLink(link);
            link.maintainReferences(1);
            FlowConnection flowConnection = drawing.createFlowConnection(link);
            if (flowConnection == null) {
                target.removeControlLink(link);
                continue;
            }
            this.workspaceView.add(flowConnection);
            this.workspaceView.addToSelection(flowConnection);
        }
        it = source.getDataLinks();
        while (it.hasNext()) {
            link = (DataLink)it.next();
            target.addDataLink((DataLink)link);
            link.maintainReferences(1);
            ParamConnection paramConnection = drawing.createParamConnection((DataLink)link);
            if (paramConnection == null) {
                target.removeDataLink((DataLink)link);
                continue;
            }
            this.workspaceView.add(paramConnection);
            this.workspaceView.addToSelection(paramConnection);
        }
        if (firstFigure != null) {
            Rectangle rect = new Rectangle(firstFigure.displayBox());
            rect.grow(50, 50);
            this.workspaceView.scrollRectToVisible(rect);
            return true;
        }
        return false;
    }

    public boolean pasteSockets(ProcessItem source) throws CloneNotSupportedException {
        Figure selection;
        FigureEnumeration fe;
        if (this.workspaceView.selectionCount() == 1 && (fe = this.workspaceView.selectionElements()).hasMoreElements() && (selection = fe.nextFigure()) instanceof MultiSocketNodeFigure) {
            MultiSocketNodeFigure nodeFigure = (MultiSocketNodeFigure)selection;
            MultiSocketNode targetNode = (MultiSocketNode)nodeFigure.getNode();
            ActivityNodeImpl node = (ActivityNodeImpl)source.getNodeByName("NodeDummy");
            this.workspaceView.clearSelection();
            List sockets = node.getSocketList();
            int n = sockets.size();
            for (int i = 0; i < n; ++i) {
                NodeSocket socket = (NodeSocket)sockets.get(i);
                socket = (NodeSocket)socket.clone();
                NamedObjectCollectionUtil.createUniqueName((DescriptionObject)socket, (Collection)targetNode.getSocketList());
                targetNode.addSocket(socket);
                socket.maintainReferences(10);
                SocketFigure socketFigure = nodeFigure.addSocket(socket);
                this.workspaceView.addToSelection(socketFigure);
            }
            return true;
        }
        return false;
    }

    public boolean pasteParams(ProcessItem source) throws CloneNotSupportedException {
        Figure figure;
        FigureEnumeration fe;
        if (this.workspaceView.selectionCount() == 1 && (fe = this.workspaceView.selectionElements()).hasMoreElements() && (figure = fe.nextFigure()) instanceof SocketFigure) {
            SocketFigure socketFigure = (SocketFigure)figure;
            NodeSocket targetSocket = socketFigure.getNodeSocket();
            ActivityNodeImpl node = (ActivityNodeImpl)source.getNodeByName("NodeDummy");
            this.workspaceView.clearSelection();
            NodeSocket socket = (NodeSocket)node.getSocketList().get(0);
            List params = socket.getParamList();
            int n = params.size();
            for (int i = 0; i < n; ++i) {
                NodeParam param = (NodeParam)params.get(i);
                param = (NodeParam)param.clone();
                NamedObjectCollectionUtil.createUniqueName((DescriptionObject)param, (Collection)targetSocket.getParamList());
                targetSocket.addParam(param, -1);
                param.maintainReferences(10);
                ParamFigure paramFigure = socketFigure.addParam(param, -1);
                this.workspaceView.addToSelection(paramFigure);
                ViewModeMgr.getInstance().setDataLinkVisible(true);
            }
            return true;
        }
        return false;
    }

    public boolean pasteQualifier(ModelQualifier source) {
        Figure selection;
        FigureEnumeration fe;
        if (this.workspaceView.selectionCount() == 1 && (fe = this.workspaceView.selectionElements()).hasMoreElements() && (selection = fe.nextFigure()) instanceof PlaceholderNodeFigure) {
            PlaceholderNodeFigure nodeFigure = (PlaceholderNodeFigure)selection;
            nodeFigure.assignPlaceholderReference(source.toString());
            return true;
        }
        return false;
    }
}

