/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureSelectionListener;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ViewChangeListener;
import CH.ifa.draw.util.UndoManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.cockpit.modeler.ClipboardSupport;
import org.openbp.cockpit.modeler.ModelerEventModule;
import org.openbp.cockpit.modeler.ModelerInteractionModule;
import org.openbp.cockpit.modeler.StandardToolSupportSetup;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.Trackable;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.cockpit.modeler.undo.ModelerUndoable;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.listener.SwingListenerSupport;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.NodeProvider;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.VetoableEvent;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.PluginState;
import org.openbp.jaspira.plugins.statusbar.StatusBarTextEvent;
import org.openbp.jaspira.undo.UndoMgr;
import org.openbp.jaspira.undo.Undoable;
import org.openbp.swing.components.JMsgBox;

public class Modeler
extends AbstractVisiblePlugin
implements DrawingEditorPlugin,
Trackable,
FocusListener {
    public static final String ATTRIBUTE_SKELETON = "_skeleton";
    private ProcessDrawing drawing;
    private ModelQualifier processQualifier;
    private WorkspaceDrawingView workspaceView;
    private JScrollPane scrollPane;
    private ClipboardSupport clipboardSupport;
    private UndoMgr undoMgr;
    private ModelerUndoable currentUndoable;
    private ModelerToolSupport toolSupport;
    private SwingListenerSupport listenerSupport;
    private boolean trackSuspended;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    @Override
    protected void initializeComponents() {
    }

    private void initializeModeler() {
        this.workspaceView = new WorkspaceDrawingView(this);
        this.workspaceView.setDrawing((Drawing)this.drawing);
        this.toolSupport = new ModelerToolSupport(this);
        StandardToolSupportSetup.setupToolSupport(this.toolSupport, true);
        this.clipboardSupport = new ClipboardSupport(this.workspaceView, this.getPluginResourceCollection(), false);
        this.undoMgr = new UndoMgr();
        this.getContentPane().removeAll();
        this.scrollPane = new JScrollPane((Component)((Object)this.workspaceView));
        this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Modeler.this.fireTrackChangedEvent(e);
            }
        });
        this.getContentPane().add(this.scrollPane);
        this.addPluginFocusListener(this);
        this.fireEvent(new JaspiraEvent(this, "modeler.view.opened", this));
    }

    @Override
    public ModelerToolSupport getToolSupport() {
        return this.toolSupport;
    }

    public void setProcess(ProcessItem process, boolean readonly) {
        ProcessItem clonedProcess = null;
        try {
            clonedProcess = (ProcessItem)process.clone();
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((Throwable)e);
            return;
        }
        clonedProcess.maintainReferences(2);
        this.processQualifier = clonedProcess.getQualifier();
        this.drawing = new ProcessDrawing(clonedProcess, this);
        this.drawing.setReadOnly(readonly);
        this.initializeModeler();
        if (process != null) {
            this.fireEvent("modeler.view.activated", this);
        }
    }

    public ProcessItem getProcess() {
        return this.drawing != null ? this.drawing.getProcess() : null;
    }

    public WorkspaceDrawingView getDrawingView() {
        return this.workspaceView;
    }

    public ProcessDrawing getDrawing() {
        return this.drawing;
    }

    public ModelQualifier getProcessQualifier() {
        return this.processQualifier;
    }

    public boolean saveProcess() {
        this.drawing.encodeGeometry();
        return ModelConnector.getInstance().saveItem((Item)this.getProcess(), false);
    }

    @Override
    public void repairDamage() {
        this.workspaceView.repairDamage();
    }

    public boolean convertPlaceholder(NodeFigure nodeFigure, NodeProvider np, Point p) {
        return false;
    }

    @Override
    protected Class[] getExternalEventModuleClasses() {
        return new Class[]{ModelerEventModule.class, ModelerInteractionModule.class};
    }

    @Override
    protected void pluginUninstalled() {
        super.pluginUninstalled();
        if (this.toolSupport != null) {
            this.toolSupport.deactivate();
        }
        if (this.drawing != null) {
            this.drawing.setProcess(null);
            this.drawing.setEditor(null);
        }
        if (this.workspaceView != null) {
            this.workspaceView.unregister();
            this.workspaceView.removeFigureSelectionListener((FigureSelectionListener)this);
        }
        this.drawing = null;
        this.processQualifier = null;
        this.workspaceView = null;
        this.scrollPane = null;
        this.clipboardSupport = null;
        this.toolSupport = null;
    }

    @Override
    public void setPluginState(PluginState state) {
        super.setPluginState(state);
    }

    @Override
    public PluginState getPluginState() {
        return super.getPluginState();
    }

    @Override
    public int getToolbarType() {
        return 2;
    }

    @Override
    public boolean canDrag() {
        return false;
    }

    @Override
    public boolean hasCloseButton() {
        return true;
    }

    @Override
    public boolean canClose() {
        if (this.drawing == null) {
            return true;
        }
        VetoableEvent ve = new VetoableEvent(this, "modeler.view.askclose", this);
        this.fireEvent(ve);
        if (ve.isVetoed()) {
            return false;
        }
        ProcessItem process = this.getProcess();
        if (process.isModified()) {
            String msg = "" + process.getQualifier() + " has been modified. Save?";
            int result = JMsgBox.show(null, (String)msg, (int)14);
            if (result == 2) {
                return false;
            }
            if (result == 4) {
                if (!this.saveProcess()) {
                    return false;
                }
                this.fireEvent(new StatusBarTextEvent(this, "Process " + this.processQualifier + " saved."));
            } else {
                this.drawing.clearModified();
            }
        }
        return true;
    }

    @Override
    protected void preClose() {
        this.workspaceView.clearSelection();
        this.fireEvent("modeler.view.closed", this);
    }

    @Override
    public void pluginShown() {
        super.pluginShown();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Modeler.this.fireEvent("modeler.view.activated", Modeler.this);
                Modeler.this.fireEvent("modelerpage.view.showzoomfactor", new Double(Modeler.this.workspaceView.getScaleFactor()));
                Modeler.this.drawing.updateModificationState();
            }
        });
        this.toolSupport.updateToolState();
    }

    @Override
    public void pluginHidden() {
        super.pluginHidden();
        this.fireEvent("modeler.view.deactivated", this);
        this.fireEvent("modelerpage.view.showzoomfactor", null);
    }

    @Override
    public String getTitle() {
        if (this.drawing == null) {
            return super.getTitle();
        }
        return super.getTitle() + " - " + this.drawing.getDisplayText();
    }

    @Override
    public String getSubTitle() {
        return this.processQualifier.toUntypedString();
    }

    @Override
    public List getSubClients() {
        return Collections.singletonList(this.drawing);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.fireEvent("global.clipboard.updatestatus");
        if (this.drawing != null) {
            this.drawing.updateModificationState();
        }
        if (this.workspaceView != null) {
            this.workspaceView.updateSelection();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.fireEvent("global.clipboard.updatestatus");
        if (this.drawing != null) {
            this.drawing.updateModificationState();
        }
    }

    @Override
    public Dimension getDocumentSize() {
        return this.workspaceView.getSize();
    }

    @Override
    public Rectangle getVisibleArea() {
        Rectangle r = this.scrollPane.getViewport().getViewRect();
        return this.workspaceView.applyScale(r, true);
    }

    @Override
    public void setVisibleArea(Rectangle r) {
        this.workspaceView.setVisibleRect(r);
    }

    @Override
    public void centerTrackerAt(Point p) {
        p = this.workspaceView.applyScale(p, false);
        Dimension d = this.scrollPane.getViewport().getSize();
        p.x -= d.width / 2;
        p.y -= d.height / 2;
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x + d.width > this.workspaceView.getWidth()) {
            p.x = this.workspaceView.getWidth() - d.width;
        }
        if (p.y + d.height > this.workspaceView.getHeight()) {
            p.y = this.workspaceView.getHeight() - d.height;
        }
        this.scrollPane.getViewport().setViewPosition(p);
    }

    @Override
    public void moveTrackerBy(int x, int y) {
        Rectangle r = this.getVisibleArea();
        r.translate(x, y);
        this.workspaceView.scrollRectToVisible(r);
    }

    @Override
    public void addTrackChangedListener(ChangeListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new SwingListenerSupport();
        }
        this.listenerSupport.addWeakListener(ChangeListener.class, (EventListener)listener);
    }

    @Override
    public void removeTrackChangedListener(ChangeListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(ChangeListener.class, (EventListener)listener);
        }
    }

    @Override
    public void fireTrackChangedEvent(ChangeEvent event) {
        if (!this.trackSuspended && this.listenerSupport != null && this.listenerSupport.containsListeners(ChangeListener.class)) {
            this.listenerSupport.fireStateChanged(event);
        }
    }

    @Override
    public void suspendTrack() {
        this.trackSuspended = true;
    }

    @Override
    public void resumeTrack() {
        this.trackSuspended = false;
        this.fireTrackChangedEvent(new ChangeEvent(this));
    }

    @Override
    public boolean isTrackSuspended() {
        return this.trackSuspended;
    }

    public void setScaleFactor(double scaleFactor) {
        this.workspaceView.setScaleFactor(scaleFactor);
    }

    @Override
    public boolean canCopy() {
        return this.clipboardSupport != null ? this.clipboardSupport.canCopy() : false;
    }

    @Override
    public boolean canDelete() {
        return this.clipboardSupport != null ? this.clipboardSupport.canDelete() : false;
    }

    @Override
    public boolean canCut() {
        return this.clipboardSupport != null ? this.clipboardSupport.canCut() : false;
    }

    @Override
    public boolean canPaste(Transferable transferable) {
        return this.clipboardSupport != null ? this.clipboardSupport.canPaste(transferable) : false;
    }

    @Override
    public Transferable copy() {
        return this.clipboardSupport.getCopyData();
    }

    @Override
    public Transferable cut() {
        this.startUndo("Cut Selection");
        Transferable result = this.clipboardSupport.cut();
        this.endUndo();
        return result;
    }

    @Override
    public void delete() {
        this.startUndo("Delete Selection");
        this.clipboardSupport.delete();
        this.endUndo();
    }

    @Override
    public void paste(Transferable transferable) {
        this.startUndo("Paste");
        this.clipboardSupport.paste(transferable);
        this.endUndo();
    }

    @Override
    public Undoable startUndo(String displayName) {
        if (this.currentUndoable != null) {
            this.endUndo();
        }
        ModelerUndoable undoable = new ModelerUndoable(this);
        undoable.setDisplayName(displayName);
        this.currentUndoable = undoable;
        return undoable;
    }

    public Undoable startUndoForAction(String eventName) {
        String displayName = null;
        JaspiraAction action = ActionMgr.getInstance().getAction(eventName);
        if (action != null) {
            displayName = action.getDisplayName();
        }
        return this.startUndo(displayName);
    }

    public Undoable startUndoForAction(JaspiraActionEvent jae) {
        return this.startUndoForAction(jae.getEventName());
    }

    @Override
    public void endUndo() {
        if (this.currentUndoable != null) {
            this.getDrawing().setModified();
            this.undoMgr.registerUndoable(this.currentUndoable);
            this.currentUndoable = null;
        }
    }

    @Override
    public void cancelUndo() {
        this.currentUndoable = null;
    }

    @Override
    public boolean isUndoRecording() {
        return this.currentUndoable != null;
    }

    public Undoable getCurrentUndoable() {
        return this.currentUndoable;
    }

    public void setProcessByUndoRedo(ProcessItem process) {
        try {
            process = (ProcessItem)process.clone();
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        process.maintainReferences(2);
        this.drawing.setProcess(process);
        this.fireEvent("modeler.view.redraw");
    }

    public UndoMgr getUndoMgr() {
        return this.undoMgr;
    }

    public void addViewChangeListener(ViewChangeListener arg0) {
    }

    public void figureSelectionChanged(DrawingView arg0) {
    }

    public UndoManager getUndoManager() {
        return null;
    }

    public void removeViewChangeListener(ViewChangeListener arg0) {
    }

    public void showStatus(String arg0) {
        this.fireEvent("global.status", arg0);
    }

    public Tool tool() {
        return this.toolSupport;
    }

    public void toolDone() {
    }

    public DrawingView view() {
        return this.workspaceView;
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.workspaceView};
    }
}

