/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;

public class ModelerGraphics {
    public static final int DEFAULT_NODE_SIZE = 50;
    private static ResourceCollection resourceCollection;
    private static Font standardTextFont;
    private static FontMetrics defaultFontMetrics;
    public static final Cursor defaultCursor;
    public static final Cursor standardCursor;
    public static final Cursor standardAddCursor;
    public static final Cursor handClickCursor;
    public static final Cursor handClickAddCursor;
    public static final Cursor handScrollCursor;
    public static final Cursor zoomCursor;
    public static final Cursor moveNodeCursor;
    public static final Cursor resizeNodeCursor;
    public static final Cursor moveSocketCursor;
    public static final Cursor moveParamCursor;
    public static final Cursor moveTextCursor;
    public static final Cursor moveHLineCursor;
    public static final Cursor moveVLineCursor;
    public static final Cursor createControlLinkCursor;
    public static final Cursor createDataLinkCursor;
    public static final Cursor moveSplinePointCursor;
    public static final Cursor moveSplineHandleCursor;
    public static final Stroke selectionStroke;
    public static final Stroke hoveredStroke;
    public static final Stroke debuggerStroke;
    public static final Stroke labelHandleStroke;

    private ModelerGraphics() {
    }

    public static String getMsg(String key) {
        if (resourceCollection == null) {
            resourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("cockpit", ModelerGraphics.class);
        }
        return resourceCollection.getOptionalString(key);
    }

    public static Font getStandardTextFont() {
        return standardTextFont;
    }

    public static FontMetrics getDefaultFontMetrics() {
        return defaultFontMetrics;
    }

    private static Cursor createCursor(String name, int hotSpotX, int hotSpotY) {
        if (resourceCollection == null) {
            resourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("cockpit", ModelerGraphics.class);
        }
        Image image = ((ImageIcon)resourceCollection.getRequiredObject(name)).getImage();
        Point hotSpot = new Point(hotSpotX, hotSpotY);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, hotSpot, name);
        return cursor;
    }

    static {
        JLabel dummy = new JLabel();
        defaultFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(dummy.getFont());
        standardTextFont = new Font("Helvetica", 0, 12);
        standardCursor = defaultCursor = Cursor.getDefaultCursor();
        standardAddCursor = defaultCursor;
        handClickCursor = ModelerGraphics.createCursor("cursor.handclick", 16, 4);
        handClickAddCursor = ModelerGraphics.createCursor("cursor.handclickadd", 16, 4);
        handScrollCursor = ModelerGraphics.createCursor("cursor.handscroll", 16, 16);
        zoomCursor = ModelerGraphics.createCursor("cursor.zoom", 16, 16);
        moveNodeCursor = ModelerGraphics.createCursor("cursor.movenode", 16, 16);
        resizeNodeCursor = ModelerGraphics.createCursor("cursor.resizenode", 16, 16);
        moveSocketCursor = ModelerGraphics.createCursor("cursor.movesocket", 16, 16);
        moveParamCursor = ModelerGraphics.createCursor("cursor.moveparam", 16, 16);
        moveTextCursor = ModelerGraphics.createCursor("cursor.movetext", 16, 16);
        moveHLineCursor = ModelerGraphics.createCursor("cursor.movehline", 16, 16);
        moveVLineCursor = ModelerGraphics.createCursor("cursor.movevline", 16, 16);
        createControlLinkCursor = ModelerGraphics.createCursor("cursor.createcontrollink", 30, 11);
        createDataLinkCursor = ModelerGraphics.createCursor("cursor.createdatalink", 30, 11);
        moveSplinePointCursor = ModelerGraphics.createCursor("cursor.movesplinepoint", 16, 16);
        moveSplineHandleCursor = ModelerGraphics.createCursor("cursor.movesplinehandle", 16, 16);
        selectionStroke = new BasicStroke(1.5f);
        hoveredStroke = new BasicStroke(1.5f);
        debuggerStroke = FigureResources.standardStroke3;
        labelHandleStroke = new BasicStroke(1.0f, 1, 2, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
    }
}

