/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import CH.ifa.draw.framework.Figure;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.custommodelobjectconfigurator.CustomModelObjectConfiguratorSupport;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.generic.Colorizable;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizard;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamVisibilityHelper;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.clipboard.ClipboardMgr;
import org.openbp.jaspira.plugin.ExternalInteractionModule;
import org.openbp.jaspira.plugin.Plugin;

public class ModelerInteractionModule
extends ExternalInteractionModule {
    private Modeler modeler;
    private CustomModelObjectConfiguratorSupport configuratorSupport;

    public ModelerInteractionModule(Plugin modeler) {
        super(modeler);
        this.modeler = (Modeler)modeler;
        this.configuratorSupport = new CustomModelObjectConfiguratorSupport((Modeler)modeler);
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public JaspiraEventHandlerCode popup(InteractionEvent ie) {
        if (!this.modeler.getPluginComponent().isShowing()) {
            return EVENT_IGNORED;
        }
        final WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
        if (ie.getSourcePlugin() == this.modeler) {
            DataFlavor[] flavor = ie.getTransferDataFlavors();
            JaspiraAction group = new JaspiraAction("popup", null, null, null, null, 100, "group");
            for (int i = 0; i < flavor.length; ++i) {
                Colorizable col;
                if (flavor[i].equals(ClientFlavors.MODEL_OBJECT)) {
                    ModelObject mo = (ModelObject)ie.getSafeTransferData(flavor[i]);
                    this.configuratorSupport.addConfiguratorMenuOptions(mo, group);
                }
                if (flavor[i].equals(ModelerFlavors.FIGURE)) {
                    Figure figure = (Figure)ie.getSafeTransferData(flavor[i]);
                    workspaceView.singleSelect(figure);
                }
                if (flavor[i].equals(ModelerFlavors.PARAM_FIGURE)) {
                    ParamFigure paramFigure = (ParamFigure)ie.getSafeTransferData(flavor[i]);
                    final NodeParam nodeParam = paramFigure.getNodeParam();
                    SocketFigure socketFigure = (SocketFigure)paramFigure.getParent();
                    ParamVisibilityHelper.addParamMenu(ie, this.modeler, socketFigure);
                    final NodeFigure nodeFigure = (NodeFigure)socketFigure.getParent();
                    if (ParamValueWizard.isParameterValueWizardApplyable(this.modeler, nodeFigure, nodeParam.getSocket().getName())) {
                        JaspiraAction wizardGroup = new JaspiraAction("popupwizard", null, null, null, null, 2, "group");
                        wizardGroup.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.paramvaluewizard"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ParamValueWizard.displayParameterValueWizard(ModelerInteractionModule.this.modeler, nodeFigure, nodeParam.getSocket().getName(), nodeParam.getName());
                            }
                        });
                        ie.add(wizardGroup);
                    }
                    String paramName = nodeParam.getName();
                    if (nodeParam.getProcess().getProcessVariableByName(paramName) == null) {
                        JaspiraAction wizardGroup = new JaspiraAction("processvargroup", null, null, null, null, 2, "group");
                        wizardGroup.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.createprocessvarfromparam"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ModelerInteractionModule.this.modeler.fireEvent("variables.createprocessvarfromparam", nodeParam);
                            }
                        });
                        ie.add(wizardGroup);
                    }
                }
                if (flavor[i].equals(ModelerFlavors.SOCKET_FIGURE)) {
                    SocketFigure socketFigure = (SocketFigure)ie.getSafeTransferData(flavor[i]);
                    final NodeSocket socket = socketFigure.getNodeSocket();
                    ParamVisibilityHelper.addParamMenu(ie, this.modeler, socketFigure);
                    final NodeFigure nodeFigure = (NodeFigure)socketFigure.getParent();
                    if (ParamValueWizard.isParameterValueWizardApplyable(this.modeler, nodeFigure, socket.getName())) {
                        JaspiraAction wizardGroup = new JaspiraAction("popupwizard", null, null, null, null, 2, "group");
                        wizardGroup.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.paramvaluewizard"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ParamValueWizard.displayParameterValueWizard(ModelerInteractionModule.this.modeler, nodeFigure, socket.getName(), null);
                            }
                        });
                        ie.add(wizardGroup);
                    }
                }
                if (flavor[i].equals(ModelerFlavors.NODE_FIGURE)) {
                    final NodeFigure nodeFigure = (NodeFigure)ie.getSafeTransferData(flavor[i]);
                    group.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.mirrororientation"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ModelerInteractionModule.this.modeler.startUndo("Flip Orientation");
                            nodeFigure.flipOrientation();
                            workspaceView.checkDamage();
                            ModelerInteractionModule.this.modeler.endUndo();
                        }
                    });
                    group.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.rotateorientationcw"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ModelerInteractionModule.this.modeler.startUndo("Rotate Orientation");
                            nodeFigure.changeOrientation(1);
                            workspaceView.checkDamage();
                            ModelerInteractionModule.this.modeler.endUndo();
                        }
                    });
                    group.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.rotateorientationccw"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ModelerInteractionModule.this.modeler.startUndo("Rotate Orientation");
                            nodeFigure.changeOrientation(2);
                            workspaceView.checkDamage();
                            ModelerInteractionModule.this.modeler.endUndo();
                        }
                    });
                }
                if (flavor[i].equals(ModelerFlavors.COLORIZABLE) && (col = (Colorizable)ie.getSafeTransferData(flavor[i])).getFillColor() != null && !col.getFillColor().equals(col.getDefaultFillColor())) {
                    group.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.resetcolor"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ModelerInteractionModule.this.modeler.startUndo("Reset Color");
                            col.setFillColor(col.getDefaultFillColor());
                            workspaceView.checkDamage();
                            ModelerInteractionModule.this.modeler.endUndo();
                        }
                    });
                }
                if (!flavor[i].equals(ModelerFlavors.PARAM_CONNECTION_FIGURE)) continue;
                final ParamConnection connection = (ParamConnection)ie.getSafeTransferData(flavor[i]);
                JaspiraAction lockAction = new JaspiraAction(this.modeler, "modeler.edit.lockorientation"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelerInteractionModule.this.modeler.startUndo("Lock Orientation");
                        connection.toggleOrientationLock();
                        ModelerInteractionModule.this.modeler.endUndo();
                    }
                };
                lockAction.setSelected(connection.isOrientationLocked());
                group.addMenuChild(lockAction);
                group.addMenuChild(new JaspiraAction(this.modeler, "modeler.edit.fliporientation"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelerInteractionModule.this.modeler.startUndo("Flip Orientation");
                        connection.flipOrientation();
                        ModelerInteractionModule.this.modeler.endUndo();
                    }
                });
            }
            ie.add(group);
            boolean copyEnabled = this.modeler.canCopy();
            boolean cutEnabled = this.modeler.canCut();
            boolean deleteEnabled = this.modeler.canDelete();
            boolean pasteEnabled = this.modeler.canPaste(ClipboardMgr.getInstance().getCurrentEntry());
            if (copyEnabled || deleteEnabled || cutEnabled || pasteEnabled) {
                JaspiraAction copyPasteGroup = new JaspiraAction("copypaste", null, null, null, null, 2, "group");
                JaspiraAction ja = new JaspiraAction(this.modeler, "modeler.edit.copy"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelerInteractionModule.this.modeler.fireEvent(new JaspiraActionEvent((Plugin)ModelerInteractionModule.this.modeler, "global.clipboard.copy", 0));
                    }
                };
                ja.setEnabled(copyEnabled);
                copyPasteGroup.addMenuChild(ja);
                ja = new JaspiraAction(this.modeler, "modeler.edit.cut"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelerInteractionModule.this.modeler.fireEvent(new JaspiraActionEvent((Plugin)ModelerInteractionModule.this.modeler, "global.clipboard.cut", 0));
                    }
                };
                ja.setEnabled(cutEnabled);
                copyPasteGroup.addMenuChild(ja);
                ja = new JaspiraAction(this.modeler, "modeler.edit.paste"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelerInteractionModule.this.modeler.fireEvent(new JaspiraActionEvent((Plugin)ModelerInteractionModule.this.modeler, "global.clipboard.paste", 0));
                    }
                };
                ja.setEnabled(pasteEnabled);
                copyPasteGroup.addMenuChild(ja);
                ie.add(copyPasteGroup);
                ja = new JaspiraAction(this.modeler, "modeler.edit.delete"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelerInteractionModule.this.modeler.fireEvent(new JaspiraActionEvent((Plugin)ModelerInteractionModule.this.modeler, "global.clipboard.delete", 0));
                    }
                };
                ja.setEnabled(deleteEnabled);
                ie.add(ja);
            }
        }
        return EVENT_HANDLED;
    }
}

