/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.undo.ModelerUndoPlugin;
import org.openbp.cockpit.plugins.debugger.DebuggerPlugin;
import org.openbp.cockpit.plugins.debugger.InspectorPlugin;
import org.openbp.cockpit.plugins.debugger.StackTracePlugin;
import org.openbp.cockpit.plugins.infopanel.InfoPanelPlugin;
import org.openbp.cockpit.plugins.itembrowser.ItemBrowserPlugin;
import org.openbp.cockpit.plugins.miniview.MiniViewPlugin;
import org.openbp.cockpit.plugins.toolbox.StandardToolBoxPlugin;
import org.openbp.cockpit.plugins.variables.VariablesPlugin;
import org.openbp.common.CommonUtil;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.OpenEventInfo;
import org.openbp.guiclient.event.QualifierEvent;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.action.JaspiraToolbarCombo;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.event.RequestEvent;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.JaspiraPageContainer;
import org.openbp.jaspira.gui.plugin.PluginDivider;
import org.openbp.jaspira.gui.plugin.TabbedPluginContainer;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugins.colorchooser.ColorChooserPlugin;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserPlugin;
import org.openbp.swing.components.JMsgBox;

public class ModelerPage
extends JaspiraPage {
    public static final int MAX_HISTORY_SIZE = 20;
    private TabbedPluginContainer modelerContainer;
    private List historyList;
    private int historyIndex;
    private boolean historyDebug;
    private JaspiraAction forwardAction;
    private JaspiraAction backwardAction;
    private String forwardActionText;
    private String backwardActionText;
    private boolean skipNextHistoryEvent;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    @Override
    public void layoutDefaultContent() {
        this.historyList = new ArrayList();
        this.historyIndex = -1;
        PluginMgr pm = PluginMgr.getInstance();
        pm.createInstance(DebuggerPlugin.class, (Plugin)this);
        pm.createInstance(ModelerUndoPlugin.class, (Plugin)this);
        JComponent leftArea = this.createLeftArea();
        JComponent rightArea = this.createRightArea();
        JComponent bottomArea = this.createBottomArea();
        PluginDivider verticalDivider = new PluginDivider(1);
        PluginDivider horizontalDivider = new PluginDivider(0);
        horizontalDivider.addClient(rightArea);
        horizontalDivider.addClient(bottomArea);
        horizontalDivider.setClientProportions(new double[]{0.75, 0.25});
        verticalDivider.addClient(leftArea);
        verticalDivider.addClient((Component)((Object)horizontalDivider));
        verticalDivider.setClientProportions(new double[]{0.2, 0.8});
        this.setPluginDivider(verticalDivider);
        this.displayWelcomePage();
        PluginMgr.getInstance().loadCustomPlugins("openbp.cockpit.plugins.modelerpage");
    }

    private JComponent createLeftArea() {
        PluginMgr pm = PluginMgr.getInstance();
        TabbedPluginContainer toolContainer = new TabbedPluginContainer();
        toolContainer.addPlugin(pm.createVisibleInstance(StandardToolBoxPlugin.class, (Plugin)this), true);
        toolContainer.addPlugin(pm.createVisibleInstance(MiniViewPlugin.class, (Plugin)this), false);
        TabbedPluginContainer itemContainer = new TabbedPluginContainer();
        itemContainer.addPlugin(pm.createVisibleInstance(ItemBrowserPlugin.class, (Plugin)this));
        TabbedPluginContainer infoContainer = new TabbedPluginContainer();
        infoContainer.addPlugin(pm.createVisibleInstance(InfoPanelPlugin.class, (Plugin)this));
        PluginDivider divider = new PluginDivider(0);
        divider.addContainer(toolContainer);
        divider.addContainer(itemContainer);
        divider.addContainer(infoContainer);
        divider.setClientProportions(new double[]{0.25, 0.5, 0.25});
        return divider;
    }

    private JComponent createRightArea() {
        this.modelerContainer = new TabbedPluginContainer();
        this.modelerContainer.setAlwaysTabs(true);
        this.modelerContainer.setSolid(true);
        return this.modelerContainer;
    }

    private JComponent createBottomArea() {
        PluginMgr pm = PluginMgr.getInstance();
        TabbedPluginContainer leftContainer = new TabbedPluginContainer();
        leftContainer.addPlugin(pm.createVisibleInstance(PropertyBrowserPlugin.class, (Plugin)this), true);
        ColorChooserPlugin colorChooser = (ColorChooserPlugin)pm.createInstance(ColorChooserPlugin.class, (Plugin)this);
        colorChooser.setHelpText(this.getPluginResourceCollection().getOptionalString("chooserhelptext"));
        TabbedPluginContainer rightContainer = new TabbedPluginContainer();
        rightContainer.addPlugin(pm.createVisibleInstance(VariablesPlugin.class, (Plugin)this), true);
        rightContainer.addPlugin((VisiblePlugin)colorChooser, false);
        rightContainer.addPlugin(pm.createVisibleInstance(InspectorPlugin.class, (Plugin)this), false);
        rightContainer.addPlugin(pm.createVisibleInstance(StackTracePlugin.class, (Plugin)this), false);
        PluginDivider divider = new PluginDivider();
        divider.addContainer(leftContainer);
        divider.addContainer(rightContainer);
        divider.setClientProportions(new double[]{0.5, 0.5});
        return divider;
    }

    public void displayWelcomePage() {
    }

    @Override
    protected void pluginInstalled() {
        super.pluginInstalled();
        JaspiraAction action = this.getAction("modelerpage.view.controlanchor");
        if (action != null) {
            action.setSelected(!ViewModeMgr.getInstance().isControlAnchorVisible());
        }
        if ((action = this.getAction("modelerpage.view.controltoggle")) != null) {
            action.setSelected(!ViewModeMgr.getInstance().isControlLinkVisible());
        }
        if ((action = this.getAction("modelerpage.view.datatoggle")) != null) {
            action.setSelected(!ViewModeMgr.getInstance().isDataLinkVisible());
        }
        this.backwardAction = this.getAction("modelerpage.view.processback");
        this.forwardAction = this.getAction("modelerpage.view.processforward");
        if (this.backwardAction != null) {
            this.backwardActionText = this.backwardAction.getDescription();
        }
        if (this.forwardAction != null) {
            this.forwardActionText = this.forwardAction.getDescription();
        }
        this.updateNavigationButtons();
    }

    @Override
    protected void pluginUninstalled() {
        super.pluginUninstalled();
        this.modelerContainer = null;
    }

    protected Modeler addModelerView(ProcessItem process, boolean readOnly) {
        Modeler modeler = (Modeler)PluginMgr.getInstance().createInstance(Modeler.class, (Plugin)this);
        try {
            modeler.setProcess(process, readOnly);
        }
        catch (RuntimeException e) {
            PluginMgr.getInstance().removeInstance(modeler);
            throw e;
        }
        int nModelersBefore = this.modelerContainer.getNumberOfPlugins();
        this.modelerContainer.addPlugin(modeler);
        int nModelersAfter = this.modelerContainer.getNumberOfPlugins();
        if (nModelersBefore == 0 || nModelersAfter == 0) {
            JaspiraPageContainer pageContainer = (JaspiraPageContainer)this.getParentContainer();
            pageContainer.buildMenu();
        }
        modeler.focusPlugin();
        return modeler;
    }

    protected void updateNavigationButtons() {
        this.updateNavigationButton(this.backwardAction, this.backwardActionText, -1);
        this.updateNavigationButton(this.forwardAction, this.forwardActionText, 1);
    }

    private void updateNavigationButton(JaspiraAction action, String text, int offset) {
        if (action != null) {
            ModelQualifier qualifier = null;
            if (this.getHistoryIndex() >= 0) {
                qualifier = this.getHistoryEntryAt(this.getHistoryIndex() + offset);
            }
            action.setEnabled(qualifier != null);
            if (qualifier != null) {
                action.setDescription(text + " (" + qualifier.toUntypedString() + ")");
            } else {
                action.setDescription(text);
            }
        }
    }

    protected void addQualifierToHistory(ModelQualifier qualifier) {
        if (this.skipNextHistoryEvent) {
            this.skipNextHistoryEvent = false;
        } else {
            for (int i = this.historyList.size() - 1; i > this.historyIndex; --i) {
                this.historyList.remove(i);
            }
            while (this.historyList.size() >= 20) {
                this.historyList.remove(0);
            }
            this.historyList.add(qualifier);
            this.historyIndex = this.historyList.size() - 1;
            this.debugHistory("after add");
        }
        this.updateNavigationButtons();
    }

    protected ModelQualifier getHistoryEntryAt(int index) {
        if (index >= 0 && index < this.historyList.size()) {
            return (ModelQualifier)this.historyList.get(index);
        }
        return null;
    }

    public int getHistoryIndex() {
        return this.historyIndex;
    }

    protected boolean canGoBackward() {
        return this.historyIndex > 0;
    }

    protected boolean canGoForward() {
        return this.historyIndex >= 0 && this.historyIndex < this.historyList.size() - 1;
    }

    protected void goBackward() {
        if (this.historyIndex > 0) {
            --this.historyIndex;
            ModelQualifier qualifier = (ModelQualifier)this.historyList.get(this.historyIndex);
            this.displayProcess(qualifier);
            this.debugHistory("after back");
        }
    }

    protected void goForward() {
        if (this.historyIndex >= 0 && this.historyIndex < this.historyList.size() - 1) {
            ++this.historyIndex;
            ModelQualifier qualifier = (ModelQualifier)this.historyList.get(this.historyIndex);
            this.displayProcess(qualifier);
            this.debugHistory("after forward");
        }
    }

    protected void displayProcess(ModelQualifier qualifier) {
        this.skipNextHistoryEvent = true;
        JaspiraEventMgr.fireGlobalEvent(new OpenEvent(this, "open.modeler", qualifier));
    }

    private void debugHistory(String title) {
        if (this.historyDebug) {
            System.out.println("***** Browse history (" + title + ") *****");
            for (int i = 0; i < this.historyList.size(); ++i) {
                ModelQualifier qualifier = (ModelQualifier)this.historyList.get(i);
                System.out.println((i == this.historyIndex ? "*" : " ") + "history[" + i + "] = " + (qualifier != null ? qualifier.toUntypedString() : "null"));
            }
            System.out.println();
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "modelerpage.view";
        }

        @Override
        public int getPriority() {
            return 1;
        }

        public JaspiraEventHandlerCode plugin_association_supports(RequestEvent event) {
            String mimeType = (String)event.getObject();
            if ("application/x-openbp-process".equals(mimeType) || "application/x-openbp-process-node".equals(mimeType)) {
                event.addResult(new OpenEventInfo("open.modeler", mimeType, ModelerPage.this.getPluginResourceCollection().getRequiredString("title.association.modeler")));
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JaspiraEventHandlerCode open_modeler(OpenEvent oe) {
            Object o = oe.getObject();
            ApplicationUtil.waitCursorOn();
            try {
                ModelQualifier qualifier = null;
                if (o instanceof String) {
                    qualifier = new ModelQualifier((String)o);
                    qualifier.setItemType("Process");
                }
                if (o instanceof ModelQualifier) {
                    qualifier = (ModelQualifier)o;
                }
                if (qualifier != null) {
                    String itemType = qualifier.getItemType();
                    if (itemType != null && !itemType.equals("Process")) {
                        JaspiraEventHandlerCode jaspiraEventHandlerCode = EVENT_IGNORED;
                        return jaspiraEventHandlerCode;
                    }
                    qualifier.setItemType("Process");
                    try {
                        o = ModelConnector.getInstance().getItemByQualifier(qualifier, true);
                    }
                    catch (ModelException e) {
                        String msg = "The process '" + qualifier + "' does not exist.";
                        JMsgBox.show(null, (String)msg, (int)262144);
                        JaspiraEventHandlerCode jaspiraEventHandlerCode = EVENT_CONSUMED;
                        ApplicationUtil.waitCursorOff();
                        return jaspiraEventHandlerCode;
                    }
                }
                if (o instanceof ProcessItem) {
                    ProcessItem process = (ProcessItem)o;
                    ModelerPage.this.addModelerView(process, oe.isReadonly());
                    if (qualifier != null && qualifier.getObjectPath() != null) {
                        ModelerPage.this.fireEvent(new QualifierEvent((Plugin)ModelerPage.this, "modeler.view.select", qualifier));
                    }
                    JaspiraEventHandlerCode jaspiraEventHandlerCode = EVENT_CONSUMED;
                    return jaspiraEventHandlerCode;
                }
            }
            finally {
                ApplicationUtil.waitCursorOff();
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                ModelQualifier qualifier = ((Modeler)o).getProcess().getQualifier();
                ModelerPage.this.addQualifierToHistory(qualifier);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_addtohistory(QualifierEvent je) {
            ModelerPage.this.addQualifierToHistory(je.getQualifier());
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode controlanchor(JaspiraActionEvent jae) {
            boolean visible = ViewModeMgr.getInstance().isControlAnchorVisible();
            visible = !visible;
            ViewModeMgr.getInstance().setControlAnchorVisible(visible);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode controltoggle(JaspiraActionEvent jae) {
            boolean visible = ViewModeMgr.getInstance().isControlLinkVisible();
            visible = !visible;
            ViewModeMgr.getInstance().setControlLinkVisible(visible);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode datatoggle(JaspiraActionEvent jae) {
            boolean visible = ViewModeMgr.getInstance().isDataLinkVisible();
            visible = !visible;
            ViewModeMgr.getInstance().setDataLinkVisible(visible);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode gridtoggle(JaspiraActionEvent jae) {
            boolean showGrid = OptionMgr.getInstance().getBooleanOption("editor.grid.display", false);
            showGrid = !showGrid;
            OptionMgr.getInstance().setOption("editor.grid.display", (Object)new Boolean(showGrid));
            OptionMgr.getInstance().saveOptions();
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode processback(JaspiraActionEvent jae) {
            ModelerPage.this.goBackward();
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode processforward(JaspiraActionEvent jae) {
            ModelerPage.this.goForward();
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode zoomfactor(JaspiraActionEvent jae) {
            JaspiraToolbarCombo combo;
            String text = null;
            ActionEvent ae = jae.getActionEvent();
            if (ae.getSource() instanceof JaspiraToolbarCombo && (text = (combo = (JaspiraToolbarCombo)ae.getSource()).getText()) != null) {
                int i = text.indexOf(32);
                if (i < 0) {
                    i = text.indexOf(37);
                }
                if (i > 0) {
                    text = text.substring(0, i);
                }
            }
            double factor = 1.0;
            if (text != null) {
                try {
                    factor = Double.parseDouble(text) / 100.0;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ModelerPage.this.fireEvent("modeler.view.setzoomfactor", new Double(factor));
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode showzoomfactor(JaspiraEvent je) {
            JaspiraAction action = ModelerPage.this.getAction("modelerpage.view.zoomfactor");
            if (action != null) {
                Double factor = (Double)je.getObject();
                if (factor != null) {
                    action.putValue("text", "" + CommonUtil.rnd((double)(factor * 100.0)) + " %");
                    action.setEnabled(true);
                } else {
                    action.putValue("text", null);
                    action.setEnabled(false);
                }
            }
            return EVENT_CONSUMED;
        }
    }
}

