/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import org.openbp.cockpit.itemeditor.NodeItemEditorPlugin;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.common.setting.SettingUtil;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.event.JaspiraEventMgr;

public final class ViewModeMgr {
    private boolean controlAnchorVisible = SettingUtil.getBooleanSetting((String)"editor.view.controlanchorvisibility", (boolean)false);
    private boolean controlLinkVisible = SettingUtil.getBooleanSetting((String)"editor.view.controllinkvisibility", (boolean)true);
    private boolean dataLinkVisible = SettingUtil.getBooleanSetting((String)"editor.view.datalinkvisibility", (boolean)true);
    private int tagState = 0;
    private static ViewModeMgr singletonInstance;

    public static synchronized ViewModeMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ViewModeMgr();
        }
        return singletonInstance;
    }

    private ViewModeMgr() {
        if (this.controlAnchorVisible) {
            this.tagState |= 4;
        }
        if (this.dataLinkVisible) {
            this.tagState |= 8;
        }
    }

    public boolean isControlAnchorVisible(VisualElement ve) {
        if (this.isDisplayedInNodeItemEditor(ve)) {
            return true;
        }
        return this.controlAnchorVisible;
    }

    public boolean isControlAnchorVisible() {
        return this.controlAnchorVisible;
    }

    public void setControlAnchorVisible(boolean controlAnchorVisible) {
        this.controlAnchorVisible = controlAnchorVisible;
        this.tagState = controlAnchorVisible ? (this.tagState |= 4) : (this.tagState &= 0xFFFFFFFB);
        SettingUtil.setBooleanSetting((String)"editor.view.controlanchorvisibility", (boolean)controlAnchorVisible);
        SettingUtil.saveSettings(null);
        JaspiraAction action = ActionMgr.getInstance().getAction("modelerpage.view.controlanchor");
        if (action != null) {
            action.setSelected(!controlAnchorVisible);
        }
        JaspiraEventMgr.fireGlobalEvent("modeler.view.modechange");
    }

    public boolean isControlLinkVisible(VisualElement ve) {
        if (this.isDisplayedInNodeItemEditor(ve)) {
            return true;
        }
        return this.controlLinkVisible;
    }

    public boolean isControlLinkVisible() {
        return this.controlLinkVisible;
    }

    public void setControlLinkVisible(boolean controlLinkVisible) {
        this.controlLinkVisible = controlLinkVisible;
        SettingUtil.setBooleanSetting((String)"editor.view.controllinkvisibility", (boolean)controlLinkVisible);
        SettingUtil.saveSettings(null);
        JaspiraAction action = ActionMgr.getInstance().getAction("modelerpage.view.controltoggle");
        if (action != null) {
            action.setSelected(!controlLinkVisible);
        }
        JaspiraEventMgr.fireGlobalEvent("modeler.view.modechange");
    }

    public boolean isDataLinkVisible(VisualElement ve) {
        if (this.isDisplayedInNodeItemEditor(ve)) {
            return true;
        }
        return this.dataLinkVisible;
    }

    public boolean isDataLinkVisible() {
        return this.dataLinkVisible;
    }

    public void setDataLinkVisible(boolean dataLinkVisible) {
        this.dataLinkVisible = dataLinkVisible;
        this.tagState = dataLinkVisible ? (this.tagState |= 8) : (this.tagState &= 0xFFFFFFF7);
        SettingUtil.setBooleanSetting((String)"editor.view.datalinkvisibility", (boolean)dataLinkVisible);
        SettingUtil.saveSettings(null);
        JaspiraAction action = ActionMgr.getInstance().getAction("modelerpage.view.datatoggle");
        if (action != null) {
            action.setSelected(!dataLinkVisible);
        }
        JaspiraEventMgr.fireGlobalEvent("modeler.view.modechange");
    }

    public int getTagState(VisualElement ve) {
        if (this.isDisplayedInNodeItemEditor(ve)) {
            return this.tagState | 4 | 8;
        }
        return this.tagState;
    }

    public int getTagState(DrawingEditorPlugin editor) {
        if (editor instanceof NodeItemEditorPlugin) {
            return this.tagState | 4 | 8;
        }
        return this.tagState;
    }

    public int getTagState() {
        return this.tagState;
    }

    public void setTagState(int tagState) {
        this.tagState = tagState;
    }

    private boolean isDisplayedInNodeItemEditor(VisualElement ve) {
        ProcessDrawing drawing;
        return ve != null && (drawing = ve.getDrawing()) != null && drawing.getEditor() instanceof NodeItemEditorPlugin;
    }
}

