/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.drawing;

import CH.ifa.draw.framework.Figure;
import java.awt.Color;
import java.util.List;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.generic.ChildFigure;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.decoration.FilteredDecorator;
import org.openbp.jaspira.plugin.Plugin;

public class SelectionDecorator {
    private WorkspaceDrawingView view;
    private Plugin provider;
    private FrameDecorator frameDecorator;
    private StrokeDecorator strokeDecorator;
    private FillDecorator fillDecorator;
    private OverlayDecorator overlayDecorator;
    private ContentStateDecorator contentStateDecorator;

    public SelectionDecorator(WorkspaceDrawingView view, Plugin provider) {
        this.view = view;
        this.provider = provider;
        this.frameDecorator = new FrameDecorator();
        this.strokeDecorator = new StrokeDecorator();
        this.fillDecorator = new FillDecorator();
        this.overlayDecorator = new OverlayDecorator();
        this.contentStateDecorator = new ContentStateDecorator();
        DecorationMgr.addDecorator(provider, "Figure.FrameStroke", this.strokeDecorator);
        DecorationMgr.addDecorator(provider, "Figure.FrameColor", this.frameDecorator);
        DecorationMgr.addDecorator(provider, "Figure.FillColor", this.fillDecorator);
        DecorationMgr.addDecorator(provider, "Figure.Overlay", this.overlayDecorator);
        DecorationMgr.addDecorator(provider, "Tag.ContentType", this.contentStateDecorator);
    }

    public void uninstall() {
        DecorationMgr.removeDecorator(this.provider, "Figure.FrameStroke", this.strokeDecorator);
        DecorationMgr.removeDecorator(this.provider, "Figure.FrameColor", this.frameDecorator);
        DecorationMgr.removeDecorator(this.provider, "Figure.FillColor", this.fillDecorator);
        DecorationMgr.removeDecorator(this.provider, "Figure.Overlay", this.overlayDecorator);
        DecorationMgr.removeDecorator(this.provider, "Tag.ContentType", this.contentStateDecorator);
    }

    boolean isSelectable(Object o) {
        return o instanceof ProcessElementContainer;
    }

    boolean isHovered(Object o) {
        return o == this.view.getFigureUnderCursor();
    }

    boolean isSelected(Object o) {
        return this.view.isFigureSelected((Figure)o);
    }

    boolean isAncestorSelected(Object o) {
        if (this.isSelected(o)) {
            return true;
        }
        while (o instanceof ChildFigure) {
            if (!this.view.isFigureSelected((Figure)(o = ((ChildFigure)o).getParent()))) continue;
            return true;
        }
        return false;
    }

    boolean isSocketRelativeSelected(SocketFigure socketFigure) {
        if (this.view.isFigureSelected(socketFigure)) {
            return true;
        }
        if (this.view.isFigureSelected(socketFigure.getParent())) {
            return true;
        }
        int n = socketFigure.getNumberOfContents();
        for (int i = 0; i < n; ++i) {
            Figure c = socketFigure.getContentFigureAt(i);
            if (!this.view.isFigureSelected(c)) continue;
            return true;
        }
        return false;
    }

    boolean hasExpression(Object o) {
        ParamFigure paramFigure;
        NodeParam param;
        String expression;
        return o instanceof ParamFigure && (expression = (param = (paramFigure = (ParamFigure)o).getNodeParam()).getExpression()) != null && !expression.equals("null") && !expression.equals("\"\"") && !expression.equals("false") && !expression.equals("0");
    }

    public class OverlayDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            return FigureResources.getExpressionOverlay(owner);
        }

        @Override
        public boolean qualifies(Object owner) {
            return SelectionDecorator.this.hasExpression(owner);
        }
    }

    public class FillDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            return value != null ? ((Color)value).brighter() : null;
        }

        @Override
        public boolean qualifies(Object owner) {
            return SelectionDecorator.this.isSelectable(owner) && SelectionDecorator.this.isAncestorSelected(owner);
        }
    }

    public class StrokeDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            if (SelectionDecorator.this.isSelected(owner)) {
                return ModelerGraphics.selectionStroke;
            }
            return ModelerGraphics.hoveredStroke;
        }

        @Override
        public boolean qualifies(Object owner) {
            return SelectionDecorator.this.isSelectable(owner) && (SelectionDecorator.this.isHovered(owner) || SelectionDecorator.this.isSelected(owner));
        }
    }

    public class FrameDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            if (SelectionDecorator.this.isSelected(owner)) {
                return ModelerColors.SELECTED_BORDER;
            }
            return ModelerColors.HOVERED_BORDER;
        }

        @Override
        public boolean qualifies(Object owner) {
            return SelectionDecorator.this.isSelectable(owner) && (SelectionDecorator.this.isHovered(owner) || SelectionDecorator.this.isSelected(owner));
        }
    }

    public class ContentStateDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            Integer stateObject = (Integer)value;
            int state = stateObject;
            if ((state & 4) == 0) {
                boolean decorate = false;
                SocketFigure socketFigure = null;
                if (owner instanceof SocketFigure) {
                    socketFigure = (SocketFigure)owner;
                    if ((socketFigure.getVisualStatus() & 2) != 0) {
                        decorate = true;
                    } else {
                        List connections;
                        decorate = SelectionDecorator.this.isSocketRelativeSelected(socketFigure);
                        if (!decorate && socketFigure != null && (connections = socketFigure.getFlowConnections()) != null) {
                            int n = connections.size();
                            for (int i = 0; i < n; ++i) {
                                FlowConnection connection = (FlowConnection)connections.get(i);
                                if (!SelectionDecorator.this.isSelected(connection)) continue;
                                decorate = true;
                                break;
                            }
                        }
                    }
                }
                if (decorate) {
                    return new Integer(state | 4 | 2);
                }
            }
            return value;
        }

        @Override
        public boolean qualifies(Object owner) {
            return owner instanceof SocketFigure || owner instanceof ParamFigure;
        }
    }
}

