/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.Quarter;

public class CircleConstants {
    public static final int EIGHTH_E = 0;
    public static final int EIGHTH_SE = 1;
    public static final int EIGHTH_S = 2;
    public static final int EIGHTH_SW = 3;
    public static final int EIGHTH_W = 4;
    public static final int EIGHTH_NW = 5;
    public static final int EIGHTH_N = 6;
    public static final int EIGHTH_NE = 7;
    private static final double CIRCLE = Math.PI * 2;

    private CircleConstants() {
    }

    public static double normalizeAngle(double angle) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static int determineEighth(double angle, Rectangle rect) {
        int dir;
        if (rect != null) {
            double alpha = Math.atan(rect.getHeight() / rect.getWidth());
            dir = angle < alpha ? 1 : (angle < 1.5707963267948966 ? 2 : (angle < Math.PI - alpha ? 3 : (angle < Math.PI ? 4 : (angle < Math.PI + alpha ? 5 : (angle < 4.71238898038469 ? 6 : (angle < Math.PI * 2 - alpha ? 7 : 0))))));
        } else {
            int eighth;
            for (eighth = (int)(4.0 * angle / Math.PI); eighth < 0; eighth += 8) {
            }
            return eighth % 8;
        }
        return dir;
    }

    public static Quarter determineQuarter(double angle, Rectangle rect) {
        int eighth = CircleConstants.determineEighth(angle, rect);
        Quarter quarter = Quarter.SE;
        switch (eighth) {
            case 5: 
            case 6: {
                quarter = Quarter.NW;
                break;
            }
            case 3: 
            case 4: {
                quarter = Quarter.SW;
                break;
            }
            case 1: 
            case 2: {
                quarter = Quarter.SE;
                break;
            }
            case 0: 
            case 7: {
                quarter = Quarter.NE;
            }
        }
        return quarter;
    }

    public static Orientation determineOrientation(double angle, Rectangle rect) {
        int eighth = CircleConstants.determineEighth(angle, rect);
        Orientation orientation = Orientation.UNDETERMINED;
        switch (eighth) {
            case 6: 
            case 7: {
                orientation = Orientation.TOP;
                break;
            }
            case 0: 
            case 1: {
                orientation = Orientation.RIGHT;
                break;
            }
            case 2: 
            case 3: {
                orientation = Orientation.BOTTOM;
                break;
            }
            case 4: 
            case 5: {
                orientation = Orientation.LEFT;
            }
        }
        return orientation;
    }
}

