/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;

public final class GeometryUtil {
    private static DecimalFormat angleFormat = new DecimalFormat("#.##");

    private GeometryUtil() {
    }

    public static int parseInt(StringTokenizer st, String paramName, String objectName) {
        try {
            if (!st.hasMoreTokens()) {
                throw new GeometryException("Missing value for paramter '" + paramName + "'.", objectName);
            }
            String s = st.nextToken();
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new GeometryException("Invalid number format for paramter '" + paramName + "'.", objectName);
        }
    }

    public static double parseDouble(StringTokenizer st, String paramName, String objectName) {
        try {
            if (!st.hasMoreTokens()) {
                throw new GeometryException("Missing value for paramter '" + paramName + "'.", objectName);
            }
            String s = st.nextToken();
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new GeometryException("Invalid floating point number format for paramter '" + paramName + "'.", objectName);
        }
    }

    public static double parseDouble(String s, String paramName, String objectName) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new GeometryException("Invalid floating point number format for paramter '" + paramName + "'.", objectName);
        }
    }

    public static Color parseColor(StringTokenizer st, String paramName, String objectName) {
        int r = GeometryUtil.parseInt(st, paramName, objectName);
        int g = GeometryUtil.parseInt(st, paramName, objectName);
        int b = GeometryUtil.parseInt(st, paramName, objectName);
        return new Color(r, g, b);
    }

    public static double parseAngle(StringTokenizer st, String paramName, String objectName) {
        double angle;
        if (!st.hasMoreTokens()) {
            throw new GeometryException("Missing value for paramter '" + paramName + "'.", objectName);
        }
        String s = st.nextToken();
        if (s.length() == 0) {
            throw new GeometryException("Empty value for paramter '" + paramName + "'.", objectName);
        }
        if (s.charAt(0) == 'd') {
            s = s.substring(1);
            s = s.replace(',', '.');
            double degree = GeometryUtil.parseDouble(s, paramName, objectName);
            angle = Math.toRadians(degree);
        } else {
            angle = GeometryUtil.parseDouble(s, paramName, objectName);
        }
        return angle;
    }

    public static String printAngle(double angle) {
        double degree = Math.toDegrees(angle);
        return "d" + angleFormat.format(degree);
    }
}

