/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import javax.swing.ImageIcon;
import org.openbp.cockpit.modeler.figures.generic.BasicFigure;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.XFigureDescriptor;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.common.CommonUtil;
import org.openbp.swing.draw.RadialGradientPaint;

public abstract class XFigure
extends BasicFigure {
    public static final String DECO_FRAMESTROKE = "Figure.FrameStroke";
    public static final String DECO_FRAMECOLOR = "Figure.FrameColor";
    public static final String DECO_FILLCOLOR2 = "Figure.FillColor2";
    private Orientation orientation = Orientation.BOTTOM;
    private transient Stroke frameStroke = FigureResources.standardStroke1;
    private transient Color frameColor;
    private transient Color fillColor2;
    private transient ImageIcon imageIcon;
    protected transient XFigureDescriptor descriptor;
    protected transient Paint paint;
    protected transient boolean needUpdatePaint;

    public XFigure() {
        this.requestPaintUpdate();
    }

    @Override
    public Object clone() {
        XFigure c = (XFigure)super.clone();
        c.orientation = this.orientation;
        c.frameStroke = this.frameStroke;
        c.frameColor = this.frameColor;
        c.fillColor2 = this.fillColor2;
        c.imageIcon = this.imageIcon;
        c.descriptor = this.descriptor;
        c.requestPaintUpdate();
        return c;
    }

    public XFigureDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(XFigureDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void initialize() {
    }

    @Override
    public void draw(Graphics g) {
        Stroke stroke;
        Color c;
        Graphics2D g2 = (Graphics2D)g;
        if (this.needUpdatePaint) {
            this.updatePaint();
        }
        if (this.paint != null) {
            Paint oldPaint = g2.getPaint();
            g2.setPaint(this.paint);
            this.drawFigure(g2);
            g2.setPaint(oldPaint);
        }
        if ((c = this.getFrameColor()) == null) {
            c = this.getDefaultFrameColor();
        }
        if ((c = (Color)this.decorateValue(DECO_FRAMECOLOR, c)) != null && (stroke = (Stroke)this.decorateValue(DECO_FRAMESTROKE, this.getFrameStroke())) != null) {
            Color oldColor = g2.getColor();
            g2.setColor(c);
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(stroke);
            this.drawFrame(g2);
            this.drawAppliances(g2);
            g2.setStroke(oldStroke);
            g2.setColor(oldColor);
        }
        this.drawImage(g2);
    }

    public void changed() {
        super.changed();
        this.requestPaintUpdate();
    }

    protected void drawFrame(Graphics g) {
    }

    protected void drawAppliances(Graphics g) {
    }

    protected void drawImage(Graphics g) {
        if (this.imageIcon == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle db = this.displayBox();
        int x = db.x;
        int y = db.y;
        int xScale = 1;
        int yScale = 1;
        switch (this.orientation) {
            case LEFT: {
                x = -x - db.width;
                xScale = -1;
                break;
            }
            case TOP: {
                y = -y - db.height;
                yScale = -1;
            }
        }
        if (xScale != 1 || yScale != 1) {
            g2.scale(xScale, yScale);
        }
        g.drawImage(this.imageIcon.getImage(), x, y, db.width, db.height, this.imageIcon.getImageObserver());
        if (xScale != 1 || yScale != 1) {
            g2.scale(xScale, yScale);
        }
    }

    public void requestPaintUpdate() {
        this.needUpdatePaint = true;
    }

    public void updatePaint() {
        Color c1 = this.getFillColor();
        if (c1 == null) {
            c1 = this.getDefaultFillColor();
        }
        if ((c1 = (Color)this.decorateValue("Figure.FillColor", c1)) != null) {
            Color c2 = this.getFillColor2();
            if (c2 == null) {
                c2 = this.getDefaultFillColor2();
            }
            if ((c2 = (Color)this.decorateValue(DECO_FILLCOLOR2, c2)) != null && !c1.equals(c2)) {
                Rectangle r = this.displayBox();
                Orientation orientation = this.getOrientation();
                int gradientPos1 = this.descriptor != null ? this.descriptor.getGradientPos1() : -1;
                int gradientPos2 = this.descriptor != null ? this.descriptor.getGradientPos2() : 2;
                boolean cyclic = this.descriptor != null ? this.descriptor.isCyclicGradient() : true;
                Point2D p1 = this.determineGradientPoint(gradientPos1, orientation, r);
                Point2D p2 = this.determineGradientPoint(gradientPos2, orientation, r);
                if (cyclic) {
                    Point2D.Double radius = new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
                    this.paint = new RadialGradientPaint(p1, c1, (Point2D)radius, c2);
                } else {
                    this.paint = new GradientPaint(p1, c1, p2, c2, true);
                }
            } else {
                this.paint = c1;
            }
        } else {
            this.paint = null;
        }
        this.needUpdatePaint = false;
    }

    private Point2D determineGradientPoint(int gradientPos, Orientation orientation, Rectangle r) {
        double y;
        double x;
        int offset = 0;
        switch (orientation) {
            case BOTTOM: {
                offset = 0;
                break;
            }
            case LEFT: {
                offset = 2;
                break;
            }
            case TOP: {
                offset = 4;
                break;
            }
            case RIGHT: {
                offset = 6;
            }
        }
        gradientPos = (gradientPos + offset) % 8;
        switch (gradientPos) {
            case 0: {
                x = r.getMinX();
                y = r.getCenterY();
                break;
            }
            case 1: {
                x = r.getMinX();
                y = r.getMaxY();
                break;
            }
            case 2: {
                x = r.getCenterX();
                y = r.getMaxY();
                break;
            }
            case 3: {
                x = r.getMaxX();
                y = r.getMaxY();
                break;
            }
            case 4: {
                x = r.getMaxX();
                y = r.getCenterY();
                break;
            }
            case 5: {
                x = r.getMaxX();
                y = r.getMinY();
                break;
            }
            case 6: {
                x = r.getCenterX();
                y = r.getMinY();
                break;
            }
            case 7: {
                x = r.getMinX();
                y = r.getMinY();
                break;
            }
            default: {
                x = r.getCenterX();
                y = r.getCenterY();
            }
        }
        return new Point2D.Float((float)x, (float)y);
    }

    public abstract Rectangle placeAdjacent(Rectangle var1, double var2);

    public Shape createShape() {
        return null;
    }

    public RectangularShape createRectangularShape() {
        return null;
    }

    @Override
    public void setFillColor(Color fillColor) {
        if (!CommonUtil.equalsNull((Object)this.getFillColor(), (Object)fillColor)) {
            super.setFillColor(fillColor);
            this.requestPaintUpdate();
        }
    }

    @Override
    public Color getDefaultFillColor() {
        return this.descriptor != null ? this.descriptor.getFillColor() : null;
    }

    public Color getFillColor2() {
        return this.fillColor2;
    }

    public void setFillColor2(Color fillColor2) {
        if (!CommonUtil.equalsNull((Object)this.fillColor2, (Object)fillColor2)) {
            this.fillColor2 = fillColor2;
            this.requestPaintUpdate();
        }
    }

    public Color getDefaultFillColor2() {
        return this.descriptor != null ? this.descriptor.getFillColor2() : null;
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public Color getDefaultFrameColor() {
        return this.descriptor != null ? this.descriptor.getFrameColor() : null;
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.requestPaintUpdate();
        }
    }

    public Stroke getFrameStroke() {
        return this.frameStroke;
    }

    public void setFrameStroke(Stroke frameStroke) {
        this.frameStroke = frameStroke;
    }
}

