/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.XRectangleFigure;
import org.openbp.common.CollectionUtil;

public abstract class XPolygonFigure
extends XRectangleFigure {
    protected Polygon polygon;

    public boolean containsPoint(int x, int y) {
        Shape shape = this.createShape();
        return shape.contains(x, y);
    }

    @Override
    protected void drawFigure(Graphics g) {
        Polygon p = this.getPolygon();
        g.fillPolygon(p);
    }

    @Override
    protected void drawFrame(Graphics g) {
        Polygon p = this.getPolygon();
        g.drawPolygon(p);
    }

    @Override
    public void changed() {
        super.changed();
        this.polygon = null;
    }

    @Override
    public Vector handles() {
        return CollectionUtil.EMPTY_VECTOR;
    }

    public Insets connectionInsets() {
        Insets insets = null;
        Rectangle r = this.box;
        Orientation orientation = this.getOrientation();
        switch (orientation) {
            case BOTTOM: {
                insets = new Insets(0, r.width / 2, r.height, r.width / 2);
                break;
            }
            case LEFT: {
                insets = new Insets(r.height / 2, r.width, r.height / 2, 0);
                break;
            }
            case TOP: {
                insets = new Insets(r.height, r.width / 2, 0, r.width / 2);
                break;
            }
            case RIGHT: {
                insets = new Insets(r.height / 2, 0, r.height / 2, r.width);
            }
        }
        return insets;
    }

    public Point center() {
        return new Point((int)this.box.getCenterX(), (int)this.box.getCenterY());
    }

    @Override
    public Shape createShape() {
        return this.getPolygon();
    }

    public abstract Polygon getPolygon();
}

