/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.BoxHandleKit;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Vector;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigureDescriptor;
import org.openbp.common.CommonUtil;

public class XRectangleFigure
extends XFigure {
    protected int frameDistance;
    protected int frameCount = 1;
    protected int barHeight = 10;
    protected int nBars;
    protected Rectangle box = new Rectangle();
    private static final int SECTOR_E = 1;
    private static final int SECTOR_S = 2;
    private static final int SECTOR_W = 3;
    private static final int SECTOR_N = 4;

    public void basicDisplayBox(Point origin, Point corner) {
        this.box = new Rectangle(origin);
        this.box.add(corner);
    }

    public Vector handles() {
        Vector handles = new Vector();
        BoxHandleKit.addHandles((Figure)this, handles);
        return handles;
    }

    public Rectangle displayBox() {
        return new Rectangle(this.box);
    }

    protected void basicMoveBy(int x, int y) {
        this.box.translate(x, y);
    }

    @Override
    public void initialize() {
        super.initialize();
        XFigureDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            this.frameDistance = descriptor.getCustomIntAttributeValue("frame-distance", this.frameDistance);
            this.frameCount = descriptor.getCustomIntAttributeValue("frame-count", this.frameCount);
            this.barHeight = descriptor.getCustomIntAttributeValue("bar-height", this.barHeight);
            this.nBars = descriptor.getCustomIntAttributeValue("bar-number", this.nBars);
        }
    }

    @Override
    protected void drawFigure(Graphics g) {
        Rectangle r = this.box;
        if (this.frameDistance > 0 || this.frameCount > 1) {
            r = new Rectangle(r);
            r.grow(-this.frameDistance * this.frameCount, -this.frameDistance * this.frameCount);
        }
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    @Override
    protected void drawFrame(Graphics g) {
        Rectangle r = this.box;
        g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
        if (this.frameCount > 1) {
            r = new Rectangle(r);
            for (int i = 1; i < this.frameCount; ++i) {
                r.grow(-this.frameDistance, -this.frameDistance);
                g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
            }
        }
    }

    @Override
    protected void drawAppliances(Graphics g) {
        if (this.nBars > 0) {
            if (this.nBars > 1) {
                int barDistance = (this.box.height - this.nBars * this.barHeight) / (this.nBars - 1);
                int y = this.box.y;
                for (int i = 0; i < this.nBars; ++i) {
                    g.fillRect(this.box.x, y, this.box.width, this.barHeight);
                    g.drawRect(this.box.x, y, this.box.width - 1, this.barHeight - 1);
                    y += this.barHeight + barDistance;
                }
            } else {
                int y = this.box.y + (this.box.height - this.barHeight) / 2;
                g.fillRect(this.box.x, y, this.box.width, this.barHeight);
                g.drawRect(this.box.x, y, this.box.width - 1, this.barHeight - 1);
            }
        }
    }

    @Override
    public Rectangle placeAdjacent(Rectangle rect, double angle) {
        double xRectCenter = rect.getWidth() / 2.0;
        double yRectCenter = rect.getHeight() / 2.0;
        Rectangle db = this.displayBox();
        db.grow(-1, -1);
        double xBoxCenter = db.getWidth() / 2.0;
        double yBoxCenter = db.getHeight() / 2.0;
        double alpha = Math.atan(db.getHeight() / db.getWidth());
        int sector = 0.0 <= angle && angle <= alpha ? 1 : (angle > alpha && angle < Math.PI - alpha ? 4 : (angle >= Math.PI - alpha && angle <= Math.PI + alpha ? 3 : (angle > Math.PI + alpha && angle < Math.PI * 2 - alpha ? 2 : 1)));
        double ratio = xBoxCenter / yBoxCenter;
        double x = 0.0;
        double y = 0.0;
        double tana = Math.tan(angle);
        switch (sector) {
            case 1: {
                x = xBoxCenter + xRectCenter;
                y = tana * (yBoxCenter + yRectCenter) / (1.0 / ratio);
                break;
            }
            case 2: {
                x = -((xBoxCenter + xRectCenter) / tana) / ratio;
                y = -(yBoxCenter + yRectCenter);
                break;
            }
            case 3: {
                x = -(xBoxCenter + xRectCenter);
                y = -(tana * (yBoxCenter + yRectCenter)) / (1.0 / ratio);
                break;
            }
            case 4: {
                x = (xBoxCenter + xRectCenter) / tana / ratio;
                y = yBoxCenter + yRectCenter;
            }
        }
        Point c = this.center();
        int xPos = c.x + CommonUtil.rnd((double)(x -= xRectCenter));
        int yPos = c.y + CommonUtil.rnd((double)(y -= yRectCenter));
        rect.setLocation(xPos, yPos);
        return rect;
    }

    @Override
    public Shape createShape() {
        return this.createRectangularShape();
    }

    @Override
    public RectangularShape createRectangularShape() {
        Rectangle2D.Double shape = new Rectangle2D.Double();
        Rectangle r = this.displayBox();
        shape.setFrame(r);
        return shape;
    }
}

