/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.layouter;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.generic.Expandable;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.layouter.AbstractTagLayouter;
import org.openbp.cockpit.modeler.figures.layouter.LayoutableTag;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.common.CommonUtil;

public class VerticalLayouter
extends AbstractTagLayouter {
    protected Orientation hAlign = Orientation.CENTER;
    protected Orientation vAlign = Orientation.CENTER;

    public VerticalLayouter(AbstractTagFigure tagFigure) {
        super(tagFigure);
    }

    @Override
    public void applyDirection() {
        this.vAlign = this.direction < 4 ? Orientation.BOTTOM : Orientation.TOP;
        this.hAlign = Orientation.CENTER;
    }

    @Override
    public boolean isVerticalLayouter() {
        return true;
    }

    @Override
    public Rectangle calculateSize() {
        int height = 0;
        int width = 0;
        FigureEnumeration en = this.tagFigure.figures();
        while (en.hasMoreElements()) {
            Figure subFigure = en.nextFigure();
            Rectangle r = subFigure instanceof Expandable ? ((Expandable)subFigure).compactDisplayBox() : (subFigure instanceof LayoutableTag ? ((LayoutableTag)subFigure).getLayouter().calculateSize() : subFigure.displayBox());
            width = Math.max(r.width, width);
            height += r.height + this.insets.top + this.insets.bottom;
        }
        return new Rectangle(0, 0, width += this.insets.left + this.insets.right, height);
    }

    @Override
    public void performLayout(Rectangle box) {
        FigureEnumeration en;
        double xFactor;
        int xBaseLine;
        switch (this.hAlign) {
            case LEFT: {
                xBaseLine = box.x + this.insets.left;
                xFactor = 0.0;
                break;
            }
            case RIGHT: {
                xBaseLine = box.x + box.width - this.insets.right;
                xFactor = -1.0;
                break;
            }
            default: {
                xBaseLine = box.x + box.width / 2;
                xFactor = -0.5;
            }
        }
        int yPos = this.insets.top + box.y;
        FigureEnumeration figureEnumeration = en = this.vAlign == Orientation.BOTTOM ? this.tagFigure.figures() : this.tagFigure.figuresReverse();
        while (en.hasMoreElements()) {
            Figure subFigure = en.nextFigure();
            Rectangle r = subFigure instanceof Expandable ? ((Expandable)subFigure).compactDisplayBox() : (subFigure instanceof LayoutableTag ? ((LayoutableTag)subFigure).getLayouter().calculateSize() : subFigure.displayBox());
            int x = xBaseLine + CommonUtil.rnd((double)(xFactor * (double)r.width));
            r.setLocation(x, yPos);
            subFigure.displayBox(r);
            yPos += this.insets.top + this.insets.bottom + r.height;
        }
    }
}

