/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.generic.Colorizable;
import org.openbp.cockpit.modeler.figures.generic.SimpleImageFigure;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.cockpit.modeler.util.ProcessElementFactory;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.SubprocessNode;
import org.openbp.core.model.item.process.WorkflowNode;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.gui.interaction.Importer;
import org.openbp.swing.SwingUtil;

public class MultiSocketNodeFigure
extends NodeFigure
implements Colorizable {
    @Override
    protected void initIcon() {
        super.initIcon();
        this.initOverlayIcon();
    }

    @Override
    protected Icon determineCenterIcon() {
        Icon icon = null;
        ProcessItem item = null;
        if (this.node instanceof SubprocessNode) {
            item = ((SubprocessNode)this.node).getSubprocess();
        }
        String skinName = this.getDrawing().getProcessSkin().getName();
        if (item != null) {
            icon = ItemIconMgr.getInstance().getIcon(skinName, (Item)item, 48);
        }
        if (icon == null && this.node.getModelObjectSymbolName() != null) {
            icon = ItemIconMgr.getInstance().getIcon(skinName, this.node.getModelObjectSymbolName(), 48);
        }
        return icon;
    }

    protected void initOverlayIcon() {
        ImageIcon overlayImage = ((SymbolDescriptor)this.presentationFigure.getDescriptor()).getOverlayIcon();
        SimpleImageFigure overlayFigure = null;
        if (overlayImage != null) {
            overlayFigure = new SimpleImageFigure(overlayImage);
        }
        this.setIconOverlayFigure((Figure)overlayFigure);
    }

    @Override
    protected void initTextFigure(String textPosition) {
        MultiSocketNode msNode = (MultiSocketNode)this.node;
        String customImagePath = msNode.getImagePath();
        if (customImagePath != null && (textPosition == null || textPosition.equals("c"))) {
            textPosition = "e";
        }
        super.initTextFigure(textPosition);
    }

    public void removeSocket(SocketFigure socketFigure) {
        this.willChange();
        ((MultiSocketNode)this.node).removeSocket(socketFigure.getNodeSocket());
        this.remove(socketFigure);
        this.changed();
    }

    @Override
    public Color getDefaultFillColor() {
        return this.presentationFigure.getDefaultFillColor();
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        List ret = super.getDropRegions(flavors, data, mouseEvent);
        if (ret != null) {
            return ret;
        }
        String regionId = this.getDropRegionIdForFlavor(flavors, data, mouseEvent);
        if (regionId != null) {
            return Collections.singletonList(this.createNodeDropRegion(regionId, flavors));
        }
        return null;
    }

    protected String getDropRegionIdForFlavor(List flavors, Transferable data, MouseEvent mouseEvent) {
        boolean accept = false;
        String regionId = this.node.getQualifier().toString();
        if (flavors.contains(ModelerFlavors.COLOR)) {
            accept = true;
            if (mouseEvent != null && mouseEvent.isControlDown()) {
                regionId = regionId + "-All";
            }
        } else if (flavors.contains(ClientFlavors.NODE_SOCKET)) {
            accept = true;
        }
        if (accept) {
            return regionId;
        }
        return null;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        if (super.importData(regionId, data, p)) {
            return true;
        }
        p = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)this.getDrawing().getView()));
        MultiSocketNode msNode = (MultiSocketNode)this.node;
        try {
            if (data.isDataFlavorSupported(ClientFlavors.NODE_SOCKET)) {
                boolean hasDefault;
                this.getDrawing().getEditor().startUndo("Add Socket");
                NodeSocket other = (NodeSocket)data.getTransferData(ClientFlavors.NODE_SOCKET);
                String name = other.isEntrySocket() ? "In" : "Out";
                NodeSocket toAdd = msNode.createSocket(name);
                if (msNode instanceof WorkflowNode) {
                    ProcessElementFactory.getInstance().ensureWorkflowTaskParameter(toAdd);
                }
                toAdd.setEntrySocket(other.isEntrySocket());
                boolean bl = hasDefault = msNode.getDefaultSocket(other.isEntrySocket()) != null;
                if (!hasDefault) {
                    toAdd.setDefaultSocket(true);
                }
                msNode.addSocket(toAdd);
                SocketFigure socketFigure = this.addSocket(toAdd);
                socketFigure.setAngle(Math.atan2(p.getY() - this.center().getY(), p.getX() - this.center().getX()));
                this.getDrawing().getEditor().endUndo();
                ((WorkspaceDrawingView)this.getDrawing().getEditor().view()).singleSelect(socketFigure);
                this.getDrawing().getEditor().fireEvent("modeler.drawing.socketadded", socketFigure);
                return true;
            }
            if (data.isDataFlavorSupported(ModelerFlavors.COLOR)) {
                Color color = (Color)data.getTransferData(ModelerFlavors.COLOR);
                this.getDrawing().getEditor().startUndo("Set Color");
                this.setFillColor(color);
                if (regionId instanceof String && ((String)regionId).endsWith("-All")) {
                    FigureEnumeration fe = this.figures();
                    while (fe.hasMoreElements()) {
                        Figure f = fe.nextFigure();
                        if (!(f instanceof SocketFigure)) continue;
                        SocketFigure socketFigure = (SocketFigure)f;
                        socketFigure.setFillColor(color);
                        socketFigure.invalidate();
                    }
                }
                this.invalidate();
                this.getDrawing().getEditor().endUndo();
                this.getDrawing().getEditor().focusPlugin();
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    @Override
    public List getImportersAt(Point p) {
        WorkspaceDrawingView view = this.getDrawing().getView();
        Point docPoint = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)view));
        if (this.presentationFigure.containsPoint(docPoint.x, docPoint.y)) {
            return Collections.singletonList(new Importer(this.node.getQualifier(), this, new DataFlavor[]{ClientFlavors.NODE_SOCKET, ModelerFlavors.COLOR}));
        }
        return null;
    }
}

