/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.spline;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.figures.spline.PolySplineFigure;
import org.openbp.common.CommonUtil;

public class ControlPointHandle
extends AbstractHandle {
    private int splineIndex;
    private int side;

    public ControlPointHandle(PolySplineFigure owner, int splineIndex, int side) {
        super((Figure)owner);
        this.splineIndex = splineIndex;
        this.side = side;
    }

    private PolySplineFigure getOwningSpline() {
        return (PolySplineFigure)this.owner();
    }

    public void invokeStart(int x, int y, DrawingView view) {
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.getOwningSpline().setCtrlPointAt(this.splineIndex, this.side, new Point(x, y));
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
    }

    public Point locate() {
        Point2D splinePoint = this.getOwningSpline().getCtrlPointAt(this.splineIndex, this.side);
        return new Point(CommonUtil.rnd((double)splinePoint.getX()), CommonUtil.rnd((double)splinePoint.getY()));
    }

    protected Point locateWayPoint() {
        Point2D splinePoint = this.getOwningSpline().getPointAt(this.splineIndex);
        return new Point(CommonUtil.rnd((double)splinePoint.getX()), CommonUtil.rnd((double)splinePoint.getY()));
    }

    public Rectangle displayBox() {
        Point p = this.locate();
        return new Rectangle(p.x - 5, p.y - 5, 10, 10);
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Point p1 = this.locateWayPoint();
        Point p2 = this.locate();
        Stroke old = ((Graphics2D)g).getStroke();
        g2.setStroke(ModelerGraphics.labelHandleStroke);
        g.setColor(ModelerColors.HANDLE_LINE);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g2.setStroke(old);
        Rectangle r = this.displayBox();
        g.setColor(ModelerColors.HANDLE_WAYPOINT_FILL);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(ModelerColors.HANDLE_WAYPOINT_BORDER);
        g.drawRect(r.x, r.y, r.width, r.height);
    }
}

