/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.tag;

import java.awt.Point;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.layouter.MultiplexLayouter;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;

public class StraightTagFigure
extends AbstractTagFigure {
    protected Orientation tagOrientation;

    public StraightTagFigure(VisualElement parent, Object modelObject, Point origin) {
        super(parent, modelObject);
        this.origin = origin;
        this.tagOrientation = Orientation.UNDETERMINED;
    }

    @Override
    protected void initTagLayouter() {
        this.layouter = MultiplexLayouter.getStraightInstance(this);
    }

    @Override
    protected Rectangle positionDisplayBox(Rectangle rect) {
        rect.translate((int)this.origin.getX(), (int)this.origin.getY());
        Rectangle cb = this.compactDisplayBox();
        Orientation orientation = this.getTagOrientation();
        if (orientation != null) {
            switch (orientation) {
                case BOTTOM: {
                    rect.translate(-cb.width / 2, -cb.height / 2);
                    break;
                }
                case TOP: {
                    rect.translate(-cb.width / 2, -rect.height + cb.height / 2);
                    break;
                }
                case RIGHT: {
                    rect.translate(-cb.width / 2, -cb.height / 2);
                    break;
                }
                case LEFT: {
                    rect.translate(-rect.width + cb.width / 2, -cb.height / 2);
                }
            }
        }
        return rect;
    }

    public Orientation getTagOrientation() {
        return this.tagOrientation;
    }

    @Override
    public void basicSetAngle(double angle) {
        super.basicSetAngle(angle);
        Rectangle db = this.getCenterFigureBox();
        this.tagOrientation = CircleConstants.determineOrientation(angle, db);
    }
}

