/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.paramvaluewizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.paramvaluewizard.ConfigurationBeanPage;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueBooleanPage;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueDataTypePage;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueIntegerPage;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValuePage;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueStringPage;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizardPart;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.core.model.WorkflowTaskDescriptor;
import org.openbp.core.model.item.ConfigurationBean;
import org.openbp.core.model.item.process.ActivityNode;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.SubprocessNode;
import org.openbp.core.model.item.process.WorkflowNode;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.components.wizard.WizardImpl;
import org.openbp.swing.components.wizard.WizardPage;

public class ParamValueWizard
extends WizardImpl {
    public static final Dimension DEFAULT_SIZE = new Dimension(600, 600);
    private final JDialog dialog;
    private final List valueParams;
    private final Node node;
    private final ConfigurationBean configurationBean;
    private boolean finished;

    public static boolean isParameterValueWizardApplyable(Modeler modeler, NodeFigure nodeFigure, String socketName) {
        Node node = nodeFigure.getNode();
        NodeSocket socket = null;
        socket = socketName != null ? node.getSocketByName(socketName) : node.getDefaultEntrySocket();
        if (socket == null) {
            return false;
        }
        Iterator it = socket.getParams();
        while (it.hasNext()) {
            NodeParam param = (NodeParam)it.next();
            if (param.getParamValueWizard() == null) continue;
            return true;
        }
        if (node instanceof MultiSocketNode) {
            ProcessItem referencedItem = null;
            if (node instanceof SubprocessNode) {
                referencedItem = ((SubprocessNode)node).getSubprocess();
            } else if (node instanceof ActivityNode) {
                // empty if block
            }
            if (referencedItem != null && referencedItem.getConfigurationClassName() != null) {
                return true;
            }
        }
        return false;
    }

    public static void displayParameterValueWizard(Modeler modeler, NodeFigure nodeFigure, String socketName, String paramName) {
        Node node = nodeFigure.getNode();
        NodeSocket socket = null;
        socket = socketName != null ? node.getSocketByName(socketName) : node.getDefaultEntrySocket();
        ArrayList<NodeParam> valueParams = null;
        if (socket != null) {
            Iterator it = socket.getParams();
            while (it.hasNext()) {
                NodeParam param = (NodeParam)it.next();
                if (param.getParamValueWizard() == null) continue;
                if (valueParams == null) {
                    valueParams = new ArrayList<NodeParam>();
                }
                valueParams.add(param);
            }
        }
        WorkflowTaskDescriptor configurationBean = null;
        if (node instanceof MultiSocketNode) {
            MultiSocketNode msNode = (MultiSocketNode)node;
            ProcessItem referencedItem = null;
            if (node instanceof SubprocessNode) {
                referencedItem = ((SubprocessNode)node).getSubprocess();
            } else if (node instanceof ActivityNode) {
                // empty if block
            }
            if (socketName == null && referencedItem != null && !referencedItem.isHideSettingsInWizard() && (configurationBean = msNode.getConfigurationBean()) == null && referencedItem != null) {
                configurationBean = referencedItem.createConfigurationBean();
            }
        }
        if (node instanceof WorkflowNode) {
            configurationBean = ((WorkflowNode)node).getWorkflowTaskDescriptor();
        }
        if (valueParams != null || configurationBean != null) {
            modeler.startUndo("Assign Parameter Values");
            ParamValueWizard wizard = new ParamValueWizard(node, valueParams, (ConfigurationBean)configurationBean, paramName);
            if (wizard.showWizardDialog()) {
                modeler.endUndo();
                nodeFigure.changed();
            } else {
                modeler.cancelUndo();
            }
            ((Component)modeler.view()).requestFocus();
        }
    }

    public ParamValueWizard(Node node, List valueParams, ConfigurationBean configurationBean, String paramName) {
        super(null);
        this.setWizardResource(ResourceCollectionMgr.getDefaultInstance().getResource("cockpit", ((Object)((Object)this)).getClass()));
        this.node = node;
        this.valueParams = valueParams;
        this.configurationBean = configurationBean;
        this.setupPages();
        if (paramName != null) {
            if (this.getPage(paramName) != null) {
                this.displayPage(paramName);
            } else {
                this.displayFirst();
            }
        } else {
            this.displayFirst();
        }
        JFrame activeFrame = ApplicationUtil.getActiveWindow();
        this.dialog = new JDialog((Frame)activeFrame, true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ParamValueWizard.this.fireWizardEvent(1);
            }
        });
        this.dialog.setSize(DEFAULT_SIZE);
        this.dialog.setLocationRelativeTo(activeFrame);
        this.dialog.getContentPane().add((Component)((Object)this));
    }

    public boolean showWizardDialog() {
        this.dialog.setVisible(true);
        return this.finished;
    }

    protected void setupPages() {
        this.clearPages();
        if (this.valueParams != null) {
            int n = this.valueParams.size();
            for (int i = n - 1; i >= 0; --i) {
                NodeParam param = (NodeParam)this.valueParams.get(i);
                ParamValuePage page = null;
                String type = param.getParamValueWizard();
                if (type.equals("string")) {
                    page = new ParamValueStringPage(this, param);
                } else if (type.equals("integer")) {
                    page = new ParamValueIntegerPage(this, param);
                } else if (type.equals("boolean")) {
                    page = new ParamValueBooleanPage(this, param);
                } else if (type.equals("datatype")) {
                    page = new ParamValueDataTypePage(this, param);
                } else {
                    LogUtil.error(((Object)((Object)this)).getClass(), (String)"Unknown parameter value wizard type $0 for parameter $1", (Object)type, (Object)param.getQualifier());
                }
                if (page == null) continue;
                this.addAndLinkPage(param.getName(), (Component)((Object)page));
            }
        }
        if (this.configurationBean != null) {
            ConfigurationBeanPage page = new ConfigurationBeanPage(this, (MultiSocketNode)this.node, this.configurationBean);
            this.addAndLinkPage("node-settings", (Component)((Object)page));
        }
    }

    protected boolean fireWizardEvent(WizardEvent event) {
        if (!super.fireWizardEvent(event)) {
            return false;
        }
        if (event.eventType == 2) {
            Iterator it = this.getPages();
            while (it.hasNext()) {
                ParamValueWizardPart page = (ParamValueWizardPart)it.next();
                page.apply();
            }
            this.finished = true;
        }
        return true;
    }

    protected WizardPage createStringPage(NodeParam param) {
        return null;
    }

    protected WizardPage createIntegerPage(NodeParam param) {
        return null;
    }

    protected WizardPage createBooleanPage(NodeParam param) {
        return null;
    }

    protected WizardPage createDataTypePage(NodeParam param) {
        return null;
    }
}

