/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.paramvaluewizard;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.plugins.displayobject.DisplayObjectPlugin;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.event.InteractionEvent;

public class ParamVisibilityHelper {
    private ParamVisibilityHelper() {
    }

    public static void addParamMenu(InteractionEvent ie, final Modeler modeler, final SocketFigure socketFigure) {
        JaspiraAction group = null;
        NodeSocket socket = socketFigure.getNodeSocket();
        Iterator it = socket.getParams();
        while (it.hasNext()) {
            final NodeParam param = (NodeParam)it.next();
            JaspiraAction action = new JaspiraAction(modeler, "modeler.edit.paramvisibility.prototype"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    modeler.startUndo("Show/hide Parameter");
                    modeler.getDrawingView().clearSelection();
                    param.setVisible(!param.isVisible());
                    socketFigure.reinitParams(false);
                    modeler.endUndo();
                    modeler.getDrawingView().redraw();
                }
            };
            String name = DisplayObjectPlugin.getInstance().isTitleModeText() ? param.getDisplayText() : param.getName();
            action.setDisplayName(name);
            boolean canHide = !param.isVisible() || ParamVisibilityHelper.canHideParam(param);
            action.setEnabled(canHide);
            action.setSelected(param.isVisible());
            if (group == null) {
                group = new JaspiraAction(modeler, "modeler.edit.paramvisibility");
            }
            group.addMenuChild(action);
        }
        if (group != null) {
            ie.add(group);
        }
    }

    public static boolean canHideParam(NodeParam param) {
        if (param.getExpression() != null) {
            return false;
        }
        ProcessItem process = param.getProcess();
        if (process != null) {
            Iterator it = process.getDataLinks();
            while (it.hasNext()) {
                DataLink link = (DataLink)it.next();
                if (param != link.getSourceParam() && param != link.getTargetParam()) continue;
                return false;
            }
        }
        return true;
    }
}

