/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.skins;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.List;
import org.openbp.awt.Color2StringConverter;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.common.MsgFormat;

public class LinkDescriptor {
    public static final int DEFAULT_STROKE_WIDTH = 10;
    public static final int LINETYPE_SOLID = 0;
    public static final int LINETYPE_DOTTED = 1;
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_ARROW = 1;
    private String linkType;
    private Color color;
    private Color color2;
    private Color color3;
    private Color color4;
    private int strokeWidth = 10;
    private int lineType = 0;
    private int startDecoration = 0;
    private int endDecoration = 1;
    private Stroke stroke;

    public boolean validate(String descriptorDir, List errorMsgs) {
        boolean ret = true;
        if (this.strokeWidth < 5 || this.strokeWidth > 50) {
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Stroke width not between {0} and {1}.", (Object)new Integer(5), (Object)new Integer(50)));
            ret = false;
        }
        return ret;
    }

    private void addErrorMsg(List errorMsgs, String errorMsg) {
        errorMsgs.add(MsgFormat.format((String)"Data/control link: $0", (Object)errorMsg));
    }

    public boolean initialize(String skinResPath) {
        return true;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getColorStr() {
        return Color2StringConverter.color2Str((Color)this.color);
    }

    public void setColorStr(String s) {
        this.color = Color2StringConverter.str2Color((String)s);
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }

    public String getColor2Str() {
        return Color2StringConverter.color2Str((Color)this.color2);
    }

    public void setColor2Str(String s) {
        this.color2 = Color2StringConverter.str2Color((String)s);
    }

    public Color getColor3() {
        return this.color3;
    }

    public void setColor3(Color color3) {
        this.color3 = color3;
    }

    public String getColor3Str() {
        return Color2StringConverter.color2Str((Color)this.color3);
    }

    public void setColor3Str(String s) {
        this.color3 = Color2StringConverter.str2Color((String)s);
    }

    public Color getColor4() {
        return this.color4;
    }

    public void setColor4(Color color4) {
        this.color4 = color4;
    }

    public String getColor4Str() {
        return Color2StringConverter.color2Str((Color)this.color4);
    }

    public void setColor4Str(String s) {
        this.color4 = Color2StringConverter.str2Color((String)s);
    }

    public boolean hasStrokeWidth() {
        return this.strokeWidth != 10;
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int lineType) {
        this.lineType = lineType;
    }

    public String getLineTypeStr() {
        return this.lineType == 1 ? "dotted" : null;
    }

    public void setLineTypeStr(String lineTypeStr) {
        this.lineType = "dotted".equals(lineTypeStr) ? 1 : 0;
    }

    public int getStartDecoration() {
        return this.startDecoration;
    }

    public void setStartDecoration(int startDecoration) {
        this.startDecoration = startDecoration;
    }

    public String getStartDecorationStr() {
        return this.startDecoration == 1 ? "arrow" : null;
    }

    public void setStartDecorationStr(String startDecorationStr) {
        this.startDecoration = "arrow".equals(startDecorationStr) ? 1 : 0;
    }

    public int getEndDecoration() {
        return this.endDecoration;
    }

    public void setEndDecoration(int endDecoration) {
        this.endDecoration = endDecoration;
    }

    public String getEndDecorationStr() {
        return this.endDecoration == 1 ? "arrow" : null;
    }

    public void setEndDecorationStr(String endDecorationStr) {
        this.endDecoration = "arrow".equals(endDecorationStr) ? 1 : 0;
    }

    public Stroke getStroke() {
        if (this.stroke == null && this.strokeWidth > 0) {
            if (this.lineType == 0) {
                this.stroke = this.strokeWidth == 10 ? FigureResources.standardStroke1 : (this.strokeWidth == 20 ? FigureResources.standardStroke2 : (this.strokeWidth == 30 ? FigureResources.standardStroke3 : new BasicStroke((float)this.strokeWidth / 10.0f)));
            } else {
                float[] dash = new float[]{4.0f};
                this.stroke = new BasicStroke((float)this.strokeWidth / 10.0f, 1, 2, 0.0f, dash, 0.0f);
            }
        }
        return this.stroke;
    }
}

