/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.skins;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.skins.SkinMgr;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.action.JaspiraToolbarCombo;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.option.SelectionOption;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.OptionModule;

public class SkinPlugin
extends AbstractPlugin {
    private Modeler currentModeler;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    @Override
    protected void pluginInstalled() {
        super.pluginInstalled();
        this.fillSkinSelectionBox();
    }

    protected void updateSkinSelectionBox(Skin skin) {
        JaspiraAction action = this.getAction("plugin.skin.selectskin");
        if (action != null) {
            String text = skin != null ? skin.getDisplayText() : null;
            action.putValue("text", text);
            action.setEnabled(text != null);
        }
    }

    protected void fillSkinSelectionBox() {
        JaspiraAction action = this.getAction("plugin.skin.selectskin");
        if (action != null) {
            action.clearValues();
            List skins = SkinMgr.getInstance().getSkinList();
            int n = skins.size();
            for (int i = 0; i < n; ++i) {
                Skin skin = (Skin)((Object)skins.get(i));
                String text = skin.getDisplayText();
                action.putValue("selectionvalue" + i, (Object)skin);
                action.putValue("selectiontext" + i, text);
            }
            action.putValue("text", null);
            action.setEnabled(false);
        }
    }

    public class SkinOptions
    extends OptionModule {

        public class SkinOption
        extends SelectionOption {
            public SkinOption() {
                super(SkinPlugin.this.getPluginResourceCollection(), "editor.skin.default", (Object)SkinMgr.getInstance().getDefaultSkin(), SkinMgr.getInstance().getSkinNames(), (Object[])SkinMgr.getInstance().getSkins());
            }
        }
    }

    public class SkinEvents
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.skin";
        }

        public JaspiraEventHandlerCode selectskin(JaspiraActionEvent jae) {
            ActionEvent ae = jae.getActionEvent();
            if (ae.getSource() instanceof JaspiraToolbarCombo) {
                JaspiraToolbarCombo combo = (JaspiraToolbarCombo)ae.getSource();
                Skin skin = (Skin)((Object)combo.getSelectedItem());
                if (SkinPlugin.this.currentModeler != null) {
                    WorkspaceDrawingView view = SkinPlugin.this.currentModeler.getDrawingView();
                    view.clearSelection();
                    ProcessDrawing drawing = (ProcessDrawing)view.drawing();
                    drawing.encodeGeometry();
                    SkinPlugin.this.currentModeler.startUndo("Change Presentation Skin");
                    ProcessItem process = drawing.getProcess();
                    process.setSkinName(skin.getName());
                    drawing.setProcess(process);
                    SkinPlugin.this.currentModeler.endUndo();
                    view.redraw();
                    if (SkinPlugin.this.currentModeler.getPluginComponent().isShowing()) {
                        SkinPlugin.this.currentModeler.focusPlugin();
                    }
                    SkinPlugin.this.fireEvent("modeler.view.skinchanged", SkinPlugin.this.currentModeler);
                }
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode displayskin(JaspiraEvent je) {
            JaspiraAction action = SkinPlugin.this.getAction("plugin.skin.selectskin");
            if (action != null) {
                Skin skin = (Skin)((Object)je.getObject());
                String text = skin != null ? skin.getDisplayText() : null;
                action.putValue("text", text);
                action.setEnabled(text != null);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                SkinPlugin.this.currentModeler = (Modeler)o;
                SkinPlugin.this.updateSkinSelectionBox(SkinPlugin.this.currentModeler.getDrawing().getProcessSkin());
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_closed(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                SkinPlugin.this.currentModeler = null;
                SkinPlugin.this.updateSkinSelectionBox(null);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }
}

