/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolDecisionTableEntry;
import org.openbp.cockpit.modeler.tools.ProcessElementInPlaceEditorTool;
import org.openbp.cockpit.modeler.tools.RubberBandTool;
import org.openbp.cockpit.modeler.util.InputState;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.plugins.statusbar.StatusBarTextEvent;

public class ModelerToolSupport
extends AbstractTool {
    private DrawingEditorPlugin editor;
    private WorkspaceDrawingView view;
    private ModelerTool currentTool;
    private ProcessElementInPlaceEditorTool inPlaceEditorTool;
    private Point lastPoint;
    private VisualElement lastFigure;
    private Handle lastHandle;
    private Timer inPlaceEditorDelayTimer;
    private static final int TRACK_SIZE = 75;
    private List<ModelerToolDecisionTableEntry> tooDecisionTable;

    public ModelerToolSupport(DrawingEditorPlugin editor) {
        super((DrawingEditor)editor);
        this.editor = editor;
        this.view = (WorkspaceDrawingView)editor.view();
        this.lastPoint = new Point();
        this.tooDecisionTable = new ArrayList<ModelerToolDecisionTableEntry>();
        this.inPlaceEditorTool = new ProcessElementInPlaceEditorTool(this);
    }

    public void addToolDecisionTableEntry(ModelerTool tool, Class figureClass, int requiredInputState) {
        this.tooDecisionTable.add(new ModelerToolDecisionTableEntry(tool, figureClass, requiredInputState));
    }

    public void deactivate() {
        super.deactivate();
        if (this.currentTool != null) {
            this.currentTool.deactivate();
            this.currentTool = null;
        }
    }

    public void activateTool(ModelerTool tool, Object objectUnderCursor) {
        this.currentTool = tool;
        this.currentTool.setAffectedObject(objectUnderCursor);
        this.currentTool.activate();
    }

    protected void clearTool() {
        this.currentTool = null;
        this.updateToolState();
    }

    public Point getLastPoint() {
        return new Point(this.lastPoint);
    }

    public VisualElement getLastFigure() {
        return this.lastFigure;
    }

    public DrawingEditorPlugin getEditor() {
        return this.editor;
    }

    public WorkspaceDrawingView getView() {
        return this.view;
    }

    public void mouseMove(MouseEvent e, int x, int y) {
        x = this.view.applyScale(x, true);
        y = this.view.applyScale(y, true);
        if (this.currentTool != null) {
            this.currentTool.mouseMove(e, x, y);
            this.lastPoint.x = e.getX();
            this.lastPoint.y = e.getY();
            return;
        }
        Object objectUnderCursor = null;
        this.lastHandle = this.view.findHandle(x, y);
        if (this.lastHandle != null) {
            objectUnderCursor = this.lastHandle;
        } else {
            VisualElement figure = ((ProcessDrawing)this.drawing()).findVisualElementInside(x, y);
            if (figure != null) {
                objectUnderCursor = figure;
            }
            if (figure != this.lastFigure) {
                if (this.lastFigure != null && (figure == null || figure.getParentElement() != this.lastFigure)) {
                    this.lastFigure.invalidate();
                    this.lastFigure.handleEvent(new VisualElementEvent("CursorLeft", this.editor, e, x, y));
                }
                if (figure != null) {
                    figure.handleEvent(new VisualElementEvent("CursorEntered", this.editor, e, x, y));
                }
                this.lastFigure = figure;
                this.view.setFigureUnderCursor(figure);
                if (figure != null) {
                    figure.invalidate();
                }
                this.view.repairDamage();
            }
        }
        String hintMsg = null;
        Cursor cursor = ModelerGraphics.standardCursor;
        ModelerToolDecisionTableEntry entry = this.determineTool(objectUnderCursor);
        if (entry != null) {
            ModelerTool tool = entry.getTool();
            hintMsg = tool.getToolHintMsg();
            cursor = tool.getToolCursor();
            if ((entry.getRequiredInputState() & 0x800) != 0) {
                this.activateTool(tool, objectUnderCursor);
                this.currentTool.mouseMove(e, x, y);
            }
        }
        this.editor.fireEvent(new StatusBarTextEvent(this.editor, hintMsg));
        this.view.setCursor(cursor);
        this.lastPoint.x = e.getX();
        this.lastPoint.y = e.getY();
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        x = this.view.applyScale(x, true);
        y = this.view.applyScale(y, true);
        InputState.updateStateOnMouseDownEvent(e);
        if (this.currentTool != null) {
            this.currentTool.mouseDown(e, x, y);
            return;
        }
        if (InputState.isLeftButtonDown()) {
            ModelerToolDecisionTableEntry entry;
            Object objectUnderCursor = this.lastHandle;
            if (objectUnderCursor == null) {
                objectUnderCursor = this.lastFigure;
            }
            if ((entry = this.determineTool(objectUnderCursor)) != null && (entry.getRequiredInputState() & 0x800) == 0) {
                ModelerTool tool = entry.getTool();
                this.activateTool(tool, objectUnderCursor);
                this.currentTool.mouseDown(e, x, y);
            }
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        boolean rightButton;
        x = this.view.applyScale(x, true);
        y = this.view.applyScale(y, true);
        if (this.currentTool != null) {
            this.currentTool.mouseUp(e, x, y);
            if (e.getClickCount() == 1) {
                return;
            }
        }
        if (rightButton = InputState.isRightButtonDown()) {
            VisualElement f = null;
            ProcessElementContainer pec = ((ProcessDrawing)this.drawing()).findProcessElementContainerInside(x, y);
            f = pec != null && pec != this.drawing() ? pec : ((ProcessDrawing)this.drawing()).findVisualElementInside(x, y);
            if (f != null && f != this.drawing()) {
                this.view.displayPopupMenu(f, e);
                this.lastFigure = (ProcessDrawing)this.drawing();
            }
        } else if (e.getClickCount() == 2) {
            Figure figure;
            if (this.inPlaceEditorDelayTimer != null) {
                this.inPlaceEditorDelayTimer.cancel();
                this.inPlaceEditorDelayTimer = null;
            }
            if ((figure = this.drawing().findFigure(x, y)) instanceof VisualElement && ((VisualElement)figure).handleEvent(new VisualElementEvent("DoubleClick", this.editor, e, x, y))) {
                return;
            }
            if (figure instanceof ProcessElementContainer) {
                ProcessElementContainer pec = ((ProcessElementContainer)figure).findProcessElementContainerInside(x, y);
                JaspiraEventMgr.fireGlobalEvent("plugin.association.open", new BasicTransferable(pec.getReferredProcessElement()));
            }
        }
        InputState.updateStateOnMouseUpEvent(e);
        this.updateToolState();
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        this.lastPoint.x = x;
        this.lastPoint.y = y;
        x = this.view.applyScale(x, true);
        y = this.view.applyScale(y, true);
        if (!InputState.isRightButtonDown()) {
            if (this.currentTool instanceof RubberBandTool) {
                ((RubberBandTool)this.currentTool).eraseRubberBand();
            }
            this.view.scrollRectToVisible(new Rectangle(x, y, 75, 75));
            if (this.currentTool != null) {
                this.currentTool.mouseDrag(e, x, y);
            }
        }
    }

    public void keyDown(KeyEvent e, int key) {
        this.updateToolState(e);
        if (this.currentTool != null) {
            this.currentTool.keyDown(e, key);
            return;
        }
    }

    public void keyUp(KeyEvent e, int key) {
        if (this.currentTool != null) {
            this.currentTool.keyUp(e, key);
        } else if (key == 10 && InputState.isAltDown()) {
            Figure selectedFigure = null;
            Iterator it = this.getView().selection().iterator();
            if (it.hasNext()) {
                selectedFigure = (Figure)it.next();
            }
            if (selectedFigure instanceof ProcessElementContainer && !(selectedFigure instanceof ProcessDrawing)) {
                this.toggleInPlaceEditor((ProcessElementContainer)selectedFigure, false);
                this.currentTool.keyDown(e, key);
                return;
            }
        }
        this.updateToolState(e);
    }

    public void displayInPlaceEditor(ProcessElementContainer figure) {
        this.activateTool(this.inPlaceEditorTool, figure);
    }

    public void toggleInPlaceEditor(final ProcessElementContainer figure, boolean delay) {
        if (this.currentTool == this.inPlaceEditorTool && this.inPlaceEditorTool.getAffectedFigure() == figure) {
            this.clearTool();
        } else if (delay) {
            this.inPlaceEditorDelayTimer = new Timer();
            this.inPlaceEditorDelayTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ModelerToolSupport.this.activateTool(ModelerToolSupport.this.inPlaceEditorTool, figure);
                    ModelerToolSupport.this.inPlaceEditorDelayTimer.cancel();
                    ModelerToolSupport.this.inPlaceEditorDelayTimer = null;
                }
            }, 400L);
        } else {
            this.activateTool(this.inPlaceEditorTool, figure);
        }
    }

    public void updateToolState() {
        this.updateToolState(null);
    }

    protected void updateToolState(KeyEvent e) {
        int modifiers;
        long when;
        Object source;
        if (e != null) {
            InputState.updateStateOnInputEvent(e);
        } else {
            InputState.setState(0);
        }
        int x = this.lastPoint.x;
        int y = this.lastPoint.y;
        if (e != null) {
            source = (Component)e.getSource();
            when = e.getWhen();
            modifiers = e.getModifiers();
        } else {
            source = this.view;
            when = 0L;
            modifiers = 0;
        }
        MouseEvent me = new MouseEvent((Component)source, 0, when, modifiers, x, y, 0, false);
        if (InputState.isLeftButtonDown() || InputState.isMiddleButtonDown() || InputState.isRightButtonDown()) {
            this.mouseDrag(me, x, y);
        } else {
            this.mouseMove(me, x, y);
        }
    }

    protected ModelerToolDecisionTableEntry determineTool(Object object) {
        int currentState = InputState.getState() & 0xA;
        for (ModelerToolDecisionTableEntry entry : this.tooDecisionTable) {
            ModelerTool tool;
            Class objectClass;
            boolean wantsObject;
            int requiredInputState = entry.getRequiredInputState() & 0xA;
            if (currentState != requiredInputState) continue;
            boolean hasObject = object != null;
            if (hasObject != (wantsObject = (objectClass = entry.getObjectClass()) != null) || objectClass != null && !objectClass.isInstance(object) || !(tool = entry.getTool()).appliesTo(object)) continue;
            return entry;
        }
        return null;
    }
}

