/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.standard.AbstractFigure;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.common.icon.MultiIcon;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.decoration.Decorator;
import org.openbp.jaspira.decoration.FilteredDecorator;
import org.openbp.jaspira.gui.interaction.DragDropPane;

public class ParamReorderTracker
extends ModelerTool {
    private ParamFigure paramFigure;
    private SocketFigure socketFigure;
    private int selectedIndex;
    private Rectangle[] regions;
    private Decorator targetDecorator = new SingleFigureDecorator();
    private Rectangle socketDisplayBox;
    private Cursor accept;
    private Cursor reject;
    private TargetFigure socketOverlayFigure = new TargetFigure();

    public ParamReorderTracker(ModelerToolSupport toolSupport) {
        super(toolSupport);
        MultiIcon dragImage = ItemIconMgr.getMultiIcon(ItemIconMgr.getInstance().getIcon("Type", 16));
        this.accept = DragDropPane.acceptCursorPrototype.createCursor(dragImage);
        this.reject = DragDropPane.rejectCursorPrototype.createCursor(dragImage);
    }

    @Override
    public void setAffectedObject(Object affectedObject) {
        super.setAffectedObject(affectedObject);
        if (affectedObject != null) {
            this.paramFigure = (ParamFigure)affectedObject;
            this.socketFigure = (SocketFigure)this.paramFigure.getParent();
            this.socketFigure.reinitParams(true);
            this.socketDisplayBox = this.socketFigure.displayBox();
            this.selectedIndex = this.socketFigure.getParamList().indexOf(this.paramFigure);
            this.regions = this.socketFigure.getParamRegions();
        } else {
            this.socketFigure = null;
            this.regions = null;
        }
    }

    @Override
    public void activate() {
        super.activate();
        this.getEditor().startUndo("Reorder Parameters");
        DecorationMgr.addDecorator(this.getEditor(), "Figure.Overlay", this.targetDecorator);
        this.getView().redraw();
    }

    @Override
    public void deactivate() {
        DecorationMgr.removeDecorator(this.getEditor(), "Figure.Overlay", this.targetDecorator);
        this.paramFigure = null;
        this.socketFigure = null;
        this.selectedIndex = 0;
        this.regions = null;
        this.socketDisplayBox = null;
        super.deactivate();
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        Cursor cursor = !this.socketDisplayBox.contains(x, y) || this.regions[this.selectedIndex].contains(x, y) || this.selectedIndex < this.regions.length - 1 && this.regions[this.selectedIndex + 1].contains(x, y) ? this.reject : this.accept;
        this.getView().setCursor(cursor);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.socketDisplayBox.contains(x, y)) {
            for (int i = 0; i < this.regions.length; ++i) {
                if (!this.regions[i].contains(x, y)) continue;
                this.socketFigure.moveParameter(this.selectedIndex, i);
                this.getView().setCursor(null);
                break;
            }
        }
        this.socketFigure.reinitParams(false);
        this.getView().singleSelect(this.paramFigure);
        this.getEditor().endUndo();
        super.mouseUp(e, x, y);
    }

    public class TargetFigure
    extends AbstractFigure {
        public void basicDisplayBox(Point origin, Point corner) {
        }

        protected void basicMoveBy(int dx, int dy) {
        }

        public Rectangle displayBox() {
            return ParamReorderTracker.this.socketDisplayBox;
        }

        public void draw(Graphics g) {
            for (int i = 0; i < ParamReorderTracker.this.regions.length; ++i) {
                if (i == ParamReorderTracker.this.selectedIndex || i == ParamReorderTracker.this.selectedIndex + 1) continue;
                g.setColor(ModelerColors.CONNECTION_ACCEPT);
                g.fillRoundRect(((ParamReorderTracker)ParamReorderTracker.this).regions[i].x, ((ParamReorderTracker)ParamReorderTracker.this).regions[i].y, ((ParamReorderTracker)ParamReorderTracker.this).regions[i].width, ((ParamReorderTracker)ParamReorderTracker.this).regions[i].height, 8, 8);
                g.setColor(Color.BLACK);
                g.drawRoundRect(((ParamReorderTracker)ParamReorderTracker.this).regions[i].x, ((ParamReorderTracker)ParamReorderTracker.this).regions[i].y, ((ParamReorderTracker)ParamReorderTracker.this).regions[i].width, ((ParamReorderTracker)ParamReorderTracker.this).regions[i].height, 8, 8);
            }
        }

        public Vector handles() {
            return null;
        }
    }

    public class SingleFigureDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            return ParamReorderTracker.this.socketOverlayFigure;
        }

        @Override
        public boolean qualifies(Object owner) {
            return owner == ParamReorderTracker.this.socketFigure;
        }
    }
}

