/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.common.CommonUtil;

public class RotationTracker
extends ModelerTool {
    private AbstractTagFigure tagFigure;
    private int anchorX;
    private int anchorY;
    private Point origin;
    private boolean moved;
    private static final int ANGLE_CONSTRAINT = 8;

    public RotationTracker(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public void setAffectedObject(Object affectedObject) {
        super.setAffectedObject(affectedObject);
        this.tagFigure = (AbstractTagFigure)affectedObject;
    }

    @Override
    public void activate() {
        super.activate();
        this.getEditor().startUndo("Rotate Socket");
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this.getView().singleSelect(this.tagFigure);
        this.anchorX = x;
        this.anchorY = y;
        this.moved = false;
        this.origin = this.tagFigure.getOrigin();
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        boolean bl = this.moved = Math.abs(x - this.anchorX) > 4 || Math.abs(y - this.anchorY) > 4;
        if (this.moved) {
            double angle = Math.atan2(y - this.origin.y, x - this.origin.x);
            angle = CircleConstants.normalizeAngle(angle);
            Rectangle box = this.tagFigure.getCenterFigureBox();
            int dir = CircleConstants.determineEighth(angle, box);
            switch (dir) {
                case 2: 
                case 3: {
                    y = box.y + box.height;
                    break;
                }
                case 4: 
                case 5: {
                    x = box.x;
                    break;
                }
                case 6: 
                case 7: {
                    y = box.y;
                    break;
                }
                case 0: 
                case 1: {
                    x = box.x + box.width;
                }
            }
            if (x < box.x + 1) {
                x = box.x + 1;
            }
            if (x > box.x + box.width - 1) {
                x = box.x + box.width - 1;
            }
            if (y < box.y) {
                y = box.y;
            }
            if (y > box.y + box.height) {
                y = box.y + box.height;
            }
            angle = Math.atan2(y - this.origin.y, x - this.origin.x);
            angle = CircleConstants.normalizeAngle(angle);
            if (e.isShiftDown()) {
                angle /= Math.PI * 2;
                angle = (double)CommonUtil.rnd((double)(angle * 8.0)) / 8.0 * 2.0 * Math.PI;
            }
            this.tagFigure.setAngle(angle);
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.moved) {
            this.moved = false;
            this.getEditor().endUndo();
        }
        super.mouseUp(e, x, y);
    }
}

