/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.Figure;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.generic.XCircleFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigureDescriptor;
import org.openbp.cockpit.modeler.figures.generic.XTriangleFigure;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;

public class ScaleTracker
extends ModelerTool {
    private int anchorX;
    private int anchorY;
    private int origX;
    private int origY;
    private boolean moved;
    private boolean maintainRatio;
    private boolean heightOnly;

    public ScaleTracker(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public void setAffectedObject(Object affectedObject) {
        super.setAffectedObject(affectedObject);
        if (affectedObject != null) {
            Figure presentationFigure = this.getAffectedFigure();
            if (affectedObject instanceof VisualElement) {
                presentationFigure = ((VisualElement)affectedObject).getPresentationFigure();
            }
            this.maintainRatio = presentationFigure instanceof XTriangleFigure;
            this.heightOnly = presentationFigure instanceof XCircleFigure;
            Rectangle db = presentationFigure.displayBox();
            this.origX = db.width;
            this.origY = db.height;
        }
    }

    @Override
    public void activate() {
        super.activate();
        this.getEditor().startUndo("Resize Element");
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this.anchorX = x;
        this.anchorY = y;
        this.moved = false;
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        boolean bl = this.moved = Math.abs(x - this.anchorX) > 4 || Math.abs(y - this.anchorY) > 4;
        if (this.moved) {
            int minX = 20;
            int minY = 100;
            int maxX = 20;
            int maxY = 500;
            NodeFigure nf = null;
            if (this.getAffectedObject() instanceof NodeFigure) {
                nf = (NodeFigure)this.getAffectedObject();
                XFigure presentationFigure = (XFigure)nf.getPresentationFigure();
                XFigureDescriptor fd = presentationFigure.getDescriptor();
                minX = fd.getMinSizeX();
                minY = fd.getMinSizeY();
                maxX = fd.getMaxSizeX();
                maxY = fd.getMaxSizeY();
            }
            int newX = this.origX * (100 + x - this.anchorX) / 100;
            int newY = this.origY * (100 + y - this.anchorY) / 100;
            newX = Math.min(newX, maxX);
            newY = Math.min(newY, maxY);
            newX = Math.max(newX, minX);
            newY = Math.max(newY, minY);
            if (nf != null) {
                if (this.maintainRatio) {
                    newY = newX;
                } else if (this.heightOnly) {
                    newY = this.origY * (100 + x - this.anchorX) / 100;
                    newY = Math.min(newY, maxY);
                    newY = Math.max(newY, minY);
                    newX = this.origX;
                }
                nf.setSize(newX, newY);
            } else {
                Rectangle db = this.getAffectedFigure().displayBox();
                db.grow((newX - db.width) / 2, (newY - db.height) / 2);
                this.getAffectedFigure().displayBox(db);
            }
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.moved) {
            this.moved = false;
            this.getEditor().endUndo();
        }
        super.mouseUp(e, x, y);
    }
}

