/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.ToolTipManager;
import org.openbp.cockpit.modeler.AutoConnector;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.figures.tag.TagConnector;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.cockpit.modeler.util.InputState;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.DataLinkImpl;
import org.openbp.core.model.item.process.Param;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.decoration.Decorator;
import org.openbp.jaspira.decoration.FilteredDecorator;

public abstract class XConnectionTool
extends ModelerTool {
    private PolySplineConnection connectionFigure;
    private Connector startConnector;
    private Connector targetConnector;
    private Figure targetFigure;
    private Figure addedFigure;
    private Decorator canConnectDecorator = new CanConnectDecorator();
    private int anchorX;
    private int anchorY;
    private boolean moved;
    private boolean wasSelected;

    public XConnectionTool(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public boolean appliesTo(Object affectedObject) {
        return true;
    }

    @Override
    public void activate() {
        super.activate();
    }

    @Override
    public void deactivate() {
        if (this.targetFigure != null) {
            this.targetFigure.connectorVisibility(false);
        }
        this.toggleDecorator(false);
        if (this.connectionFigure != null) {
            this.getView().remove(this.connectionFigure);
        }
        this.connectionFigure = null;
        this.startConnector = null;
        this.targetConnector = null;
        this.targetFigure = null;
        this.addedFigure = null;
        super.deactivate();
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this.anchorX = x;
        this.anchorY = y;
        this.moved = false;
        this.wasSelected = this.getView().isFigureSelected(this.getAffectedFigure());
        if (!this.wasSelected) {
            this.getView().singleSelect(this.getAffectedFigure());
        }
        this.targetFigure = this.findConnectionStart(x, y, this.getDrawing());
        if (this.targetFigure != null) {
            this.startConnector = this.findConnector(x, y, this.targetFigure);
            if (this.startConnector != null) {
                this.getEditor().startUndo("Create Link");
                this.connectionFigure = this.createConnection();
                this.connectionFigure.startPoint(x, y);
                this.connectionFigure.endPoint(x, y);
                this.addedFigure = this.getView().add(this.connectionFigure);
                this.toggleDecorator(true);
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        boolean bl = this.moved = Math.abs(x - this.anchorX) > 4 || Math.abs(y - this.anchorY) > 4;
        if (this.moved) {
            ToolTipManager.sharedInstance().mouseMoved(e);
            Point p = new Point(x, y);
            if (this.connectionFigure != null) {
                this.trackConnectors(e, x, y);
                if (this.targetConnector != null) {
                    p = this.targetConnector.findEnd((ConnectionFigure)this.connectionFigure);
                }
                this.connectionFigure.endPoint(p.x, p.y);
            }
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        VisualElement lastFigure;
        Connector endConnector = null;
        if (this.moved) {
            Figure figure = null;
            if (this.startConnector != null && (figure = this.findTargetFigure(x, y, this.getDrawing())) != null) {
                endConnector = this.findConnector(x, y, figure);
            }
            this.toggleDecorator(false);
            if (figure != null && endConnector != null) {
                this.connectionFigure.connectStart(this.startConnector);
                this.connectionFigure.connectEnd(endConnector);
                if (this.connectionFigure instanceof ParamConnection) {
                    ParamConnection paramConnection = (ParamConnection)this.connectionFigure;
                    DataLink dataLink = paramConnection.getDataLink();
                    String newSourceMemberPath = DataLinkImpl.checkAutoConversion((Param)dataLink.getSourceParam(), (String)dataLink.getSourceMemberPath(), (Param)dataLink.getTargetParam(), (String)dataLink.getTargetMemberPath());
                    dataLink.setSourceMemberPath(newSourceMemberPath);
                }
                this.connectionFigure.layoutAndAdjustConnection();
                this.connectionFigure.setDrawDecorations(true);
                this.getView().singleSelect(this.addedFigure);
                this.getEditor().endUndo();
                if (this.connectionFigure instanceof FlowConnection && !InputState.isCtrlDown()) {
                    FlowConnection flowConnectionFigure = (FlowConnection)this.connectionFigure;
                    SocketFigure sourceSocketFigure = ((TagConnector)flowConnectionFigure.getStartConnector()).getSocketFigure();
                    SocketFigure targetSocketFigure = ((TagConnector)flowConnectionFigure.getEndConnector()).getSocketFigure();
                    AutoConnector autoConnector = new AutoConnector((Modeler)this.getEditor(), sourceSocketFigure, targetSocketFigure);
                    autoConnector.autoConnectDataLinks();
                }
            }
        }
        if (endConnector == null && this.connectionFigure != null) {
            this.getView().remove(this.connectionFigure);
        }
        this.connectionFigure = null;
        this.startConnector = null;
        this.addedFigure = null;
        super.mouseUp(e, x, y);
        if (!this.moved && this.wasSelected && (lastFigure = this.getToolSupport().getLastFigure()) instanceof ProcessElementContainer) {
            this.getToolSupport().toggleInPlaceEditor((ProcessElementContainer)lastFigure, true);
        }
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        this.trackConnectors(e, x, y);
    }

    protected abstract PolySplineConnection createConnection();

    protected void trackConnectors(MouseEvent e, int x, int y) {
        Figure figure = null;
        figure = this.startConnector == null ? this.findSourceFigure(x, y, this.getDrawing()) : this.findTargetFigure(x, y, this.getDrawing());
        if (figure != this.targetFigure) {
            if (this.targetFigure != null) {
                this.targetFigure.connectorVisibility(false);
            }
            this.targetFigure = figure;
            if (this.targetFigure != null) {
                this.targetFigure.connectorVisibility(true);
            }
        }
        Connector connector = null;
        if (figure != null) {
            connector = this.findConnector(x, y, figure);
        }
        if (connector != this.targetConnector) {
            this.targetConnector = connector;
        }
        this.getView().checkDamage();
    }

    protected Figure findSourceFigure(int x, int y, Drawing drawing) {
        return this.findConnectableFigure(x, y, drawing);
    }

    protected Figure findTargetFigure(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        Figure start = this.startConnector.owner();
        if (target != null && this.connectionFigure != null && target.canConnect() && !target.includes(start) && this.canLinkFigures(start, target)) {
            return target;
        }
        return null;
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect()) {
            return target;
        }
        return null;
    }

    protected Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if ((figure = figure.findFigureInside(x, y)) == null || figure.includes((Figure)this.connectionFigure) || !figure.canConnect()) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure figure) {
        return figure.connectorAt(x, y);
    }

    public boolean canLinkFigures(Figure start, Figure target) {
        int flags = 0;
        if (InputState.isShiftDown()) {
            flags = 1;
        } else if (AutoConnector.getDataLinkAutoConnectorMode() >= 5) {
            flags = 2;
        }
        return this.connectionFigure.canConnectFigures(start, target, flags);
    }

    private void toggleDecorator(boolean on) {
        if (this.startConnector != null && this.connectionFigure instanceof FlowConnection) {
            Figure startSocketFigure = this.startConnector.owner();
            if (!ViewModeMgr.getInstance().isControlAnchorVisible()) {
                Iterator it = ((ProcessDrawing)this.getDrawing()).getNodeFigures();
                while (it.hasNext()) {
                    NodeFigure nodeFigure = (NodeFigure)it.next();
                    FigureEnumeration fe = nodeFigure.figures();
                    while (fe.hasMoreElements()) {
                        Figure f = fe.nextFigure();
                        if (!(f instanceof SocketFigure)) continue;
                        SocketFigure socketFigure = (SocketFigure)f;
                        boolean affected = false;
                        if (socketFigure == this.startConnector.owner()) {
                            affected = true;
                        }
                        if (socketFigure == this.connectionFigure.startFigure() || socketFigure == this.connectionFigure.endFigure()) {
                            affected = true;
                        }
                        if (this.canLinkFigures(startSocketFigure, socketFigure)) {
                            affected = true;
                        }
                        if (!affected) continue;
                        String eventType = on ? "SetDropTarget" : "UnsetDropTarget";
                        socketFigure.handleEvent(new VisualElementEvent(eventType, this.getEditor()));
                    }
                }
            }
        }
        if (on) {
            DecorationMgr.addDecorator(this.getEditor(), "Figure.Overlay", this.canConnectDecorator);
        } else {
            DecorationMgr.removeDecorator(this.getEditor(), "Figure.Overlay", this.canConnectDecorator);
        }
        this.getView().redraw();
    }

    public class CanConnectDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            return FigureResources.getAcceptOverlay(owner);
        }

        @Override
        public boolean qualifies(Object owner) {
            if (XConnectionTool.this.connectionFigure == null) {
                return false;
            }
            if (XConnectionTool.this.connectionFigure instanceof FlowConnection && !(owner instanceof SocketFigure)) {
                return false;
            }
            return XConnectionTool.this.canLinkFigures(XConnectionTool.this.startConnector.owner(), (Figure)owner);
        }
    }
}

