/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;

public class XDragTracker
extends ModelerTool {
    private int anchorX;
    private int anchorY;
    private int lastX;
    private int lastY;
    private boolean moved;
    private boolean wasSelected;

    public XDragTracker(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this.anchorX = x;
        this.anchorY = y;
        this.moved = false;
        this.lastX = x;
        this.lastY = y;
        this.wasSelected = this.getView().isFigureSelected(this.getAffectedFigure());
        if (e.isShiftDown()) {
            this.getView().toggleSelection(this.getAffectedFigure());
        } else if (!this.wasSelected) {
            this.getView().singleSelect(this.getAffectedFigure());
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        boolean bl = this.moved = Math.abs(x - this.anchorX) > 4 || Math.abs(y - this.anchorY) > 4;
        if (this.moved) {
            if (!this.getEditor().isUndoRecording()) {
                this.getEditor().startUndo("Move Element");
            }
            FigureEnumeration figures = this.getView().selectionElements();
            while (figures.hasMoreElements()) {
                figures.nextFigure().moveBy(x - this.lastX, y - this.lastY);
            }
        }
        this.lastX = x;
        this.lastY = y;
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        VisualElement lastFigure;
        if (this.moved) {
            this.getEditor().endUndo();
        }
        super.mouseUp(e, x, y);
        if (!this.moved && this.wasSelected && e.getClickCount() == 1 && (lastFigure = this.getToolSupport().getLastFigure()) instanceof ProcessElementContainer) {
            this.getToolSupport().toggleInPlaceEditor((ProcessElementContainer)lastFigure, true);
        }
        this.moved = false;
    }
}

