/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.undo;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.jaspira.undo.Undoable;

public class ModelerUndoable
implements Undoable {
    private String displayName;
    private Modeler modeler;
    private ProcessItem processBefore;
    private List selectionBefore;
    private ProcessItem processAfter;
    private List selectionAfter;

    public ModelerUndoable(Modeler modeler) {
        this.modeler = modeler;
        modeler.getDrawing().encodeGeometry();
        this.processBefore = this.copyProcess(modeler.getProcess());
        this.selectionBefore = this.saveSelection();
    }

    @Override
    public boolean undo() {
        if (this.processAfter == null) {
            this.modeler.getDrawing().encodeGeometry();
            this.processAfter = this.copyProcess(this.modeler.getProcess());
            this.selectionAfter = this.saveSelection();
        }
        this.modeler.getDrawingView().clearSelection();
        this.modeler.setProcessByUndoRedo(this.processBefore);
        this.restoreSelection(this.selectionBefore);
        return true;
    }

    @Override
    public boolean isRedoable() {
        return true;
    }

    @Override
    public boolean redo() {
        this.modeler.getDrawingView().clearSelection();
        this.modeler.setProcessByUndoRedo(this.processAfter);
        this.restoreSelection(this.selectionAfter);
        return true;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    protected ProcessItem copyProcess(ProcessItem process) {
        process.maintainReferences(5);
        try {
            process = (ProcessItem)process.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        process.maintainReferences(258);
        return process;
    }

    protected List saveSelection() {
        ArrayList<ModelQualifier> result = null;
        FigureEnumeration fe = this.modeler.getDrawingView().selectionElements();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof ProcessElementContainer)) continue;
            ProcessElementContainer pec = (ProcessElementContainer)f;
            ProcessObject pe = pec.getProcessElement();
            ModelQualifier qualifier = pe.getQualifier();
            if (result == null) {
                result = new ArrayList<ModelQualifier>();
            }
            result.add(qualifier);
        }
        return result;
    }

    protected void restoreSelection(List selectionQualifiers) {
        if (selectionQualifiers == null) {
            return;
        }
        WorkspaceDrawingView view = this.modeler.getDrawingView();
        Rectangle rect = null;
        int n = selectionQualifiers.size();
        for (int i = 0; i < n; ++i) {
            ModelQualifier qualifier = (ModelQualifier)selectionQualifiers.get(i);
            ProcessElementContainer pec = this.modeler.getDrawing().getFigureByQualifier(qualifier);
            if (pec == null) continue;
            view.addToSelection(pec);
            Rectangle db = pec.displayBox();
            rect = rect == null ? new Rectangle(db) : rect.union(db);
        }
        if (rect != null) {
            rect.grow(50, 50);
            view.scrollRectToVisible(rect);
        }
    }
}

