/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.util;

import CH.ifa.draw.framework.Figure;
import java.awt.BasicStroke;
import java.awt.Stroke;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.generic.XCircleFigure;
import org.openbp.cockpit.modeler.figures.generic.XEllipseFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.figures.generic.XRectangleFigure;
import org.openbp.cockpit.modeler.figures.generic.XRoundRectangleFigure;
import org.openbp.cockpit.modeler.figures.generic.XTriangleFigure;

public class FigureResources {
    public static final Stroke standardStroke1;
    public static final Stroke standardStroke2;
    public static final Stroke standardStroke3;
    private static final XFigure[] acceptOverlayFigures;
    private static final XFigure[] expressionOverlayFigures;
    private static final XFigure[] breakpointOverlayFigures;

    private FigureResources() {
    }

    public static Figure getAcceptOverlay(Object owner) {
        return FigureResources.getOverlay(owner, acceptOverlayFigures);
    }

    public static Figure getExpressionOverlay(Object owner) {
        return FigureResources.getOverlay(owner, expressionOverlayFigures);
    }

    public static Figure getBreakpointOverlay(Object owner) {
        return FigureResources.getOverlay(owner, breakpointOverlayFigures);
    }

    private static Figure getOverlay(Object owner, XFigure[] overlayFigures) {
        Figure presentationFigure = null;
        if (owner instanceof VisualElement) {
            presentationFigure = ((VisualElement)owner).getPresentationFigure();
        } else if (owner instanceof Figure) {
            presentationFigure = (Figure)owner;
        }
        if (presentationFigure != null) {
            Class<?> presentationClass = presentationFigure.getClass();
            for (int i = 0; i < overlayFigures.length; ++i) {
                XFigure figure = overlayFigures[i];
                if (!figure.getClass().isAssignableFrom(presentationClass)) continue;
                figure.displayBox(presentationFigure.displayBox());
                if (presentationFigure instanceof XFigure) {
                    figure.setOrientation(((XFigure)presentationFigure).getOrientation());
                }
                if (presentationFigure instanceof XRoundRectangleFigure) {
                    XRoundRectangleFigure sourceRR = (XRoundRectangleFigure)presentationFigure;
                    XRoundRectangleFigure targetRR = (XRoundRectangleFigure)figure;
                    targetRR.setArcWidth(sourceRR.getArcWidth());
                    targetRR.setArcHeight(sourceRR.getArcHeight());
                }
                return figure;
            }
        }
        return null;
    }

    static {
        XFigure figure;
        int i;
        standardStroke1 = new BasicStroke(1.0f);
        standardStroke2 = new BasicStroke(2.0f);
        standardStroke3 = new BasicStroke(3.0f);
        acceptOverlayFigures = new XFigure[]{new XCircleFigure(), new XEllipseFigure(), new XRoundRectangleFigure(), new XRectangleFigure(), new XTriangleFigure()};
        expressionOverlayFigures = new XFigure[]{new XCircleFigure(), new XEllipseFigure(), new XRoundRectangleFigure(), new XRectangleFigure(), new XTriangleFigure()};
        breakpointOverlayFigures = new XFigure[]{new XCircleFigure(), new XEllipseFigure(), new XRoundRectangleFigure(), new XRectangleFigure(), new XTriangleFigure()};
        for (i = 0; i < acceptOverlayFigures.length; ++i) {
            figure = acceptOverlayFigures[i];
            figure.setFrameColor(ModelerColors.CONNECTION_ACCEPT);
            figure.setFillColor(ModelerColors.CONNECTION_ACCEPT);
            figure.setFillColor2(null);
        }
        for (i = 0; i < expressionOverlayFigures.length; ++i) {
            figure = expressionOverlayFigures[i];
            figure.setFrameColor(null);
            figure.setFillColor(ModelerColors.EXPRESSION_OVERLAY);
            figure.setFillColor2(null);
        }
        for (i = 0; i < breakpointOverlayFigures.length; ++i) {
            figure = breakpointOverlayFigures[i];
            figure.setFrameColor(null);
            figure.setFillColor(ModelerColors.BREAKPOINT_OVERLAY);
            figure.setFillColor2(null);
        }
    }
}

