/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.util;

import org.openbp.common.ExceptionUtil;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.ActivityNodeImpl;
import org.openbp.core.model.item.process.DecisionNodeImpl;
import org.openbp.core.model.item.process.FinalNodeImpl;
import org.openbp.core.model.item.process.ForkNodeImpl;
import org.openbp.core.model.item.process.InitialNodeImpl;
import org.openbp.core.model.item.process.JoinNodeImpl;
import org.openbp.core.model.item.process.MergeNodeImpl;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeParamImpl;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.NodeSocketImpl;
import org.openbp.core.model.item.process.PlaceholderNodeImpl;
import org.openbp.core.model.item.process.ProcessUtil;
import org.openbp.core.model.item.process.VisualNodeImpl;
import org.openbp.core.model.item.process.WaitStateNodeImpl;
import org.openbp.core.model.item.process.WorkflowEndNodeImpl;
import org.openbp.core.model.item.process.WorkflowNodeImpl;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.model.ModelConnector;

public class ProcessElementFactory {
    public static final String SYSTEM_TYPE_OBJECT = "Object";
    public static final String SYSTEM_TYPE_STRING = "String";
    public static final String SYSTEM_TYPE_INTEGER = "Integer";
    public static final String SYSTEM_TYPE_WORKFLOWTASK = "WorkflowTask";
    private static ProcessElementFactory singletonInstance;

    public static synchronized ProcessElementFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ProcessElementFactory();
        }
        return singletonInstance;
    }

    private ProcessElementFactory() {
    }

    public InitialNodeImpl createStandardInitialNode() {
        InitialNodeImpl node = new InitialNodeImpl();
        node.setName("In");
        NodeSocket socket = this.createExitSocket("Out", true);
        socket.setGeometry(ProcessUtil.createSocketGeometry((String)"s"));
        node.setSocket(socket);
        return node;
    }

    public FinalNodeImpl createStandardFinalNode() {
        FinalNodeImpl node = new FinalNodeImpl();
        node.setName("Out");
        NodeSocket socket = this.createEntrySocket("In", true);
        socket.setGeometry(ProcessUtil.createSocketGeometry((String)"n"));
        node.setSocket(socket);
        return node;
    }

    public DecisionNodeImpl createStandardDecisionNode() {
        DecisionNodeImpl node = new DecisionNodeImpl();
        this.createStandardName((Node)node);
        NodeSocket inSocket = this.createEntrySocket("In", true);
        NodeSocket yesSocket = this.createExitSocket("Yes", true);
        NodeSocket noSocket = this.createExitSocket("No", false);
        inSocket.setGeometry(ProcessUtil.createSocketGeometry((String)"n"));
        yesSocket.setGeometry(ProcessUtil.createSocketGeometry((String)"s"));
        noSocket.setGeometry(ProcessUtil.createSocketGeometry((String)"e"));
        node.addSocket(inSocket);
        node.addSocket(yesSocket);
        node.addSocket(noSocket);
        return node;
    }

    public ForkNodeImpl createStandardForkNode() {
        ForkNodeImpl node = new ForkNodeImpl();
        this.createStandardName((Node)node);
        NodeSocket inSocket = this.createEntrySocket("In", true);
        NodeSocket outSocket = this.createExitSocket("Out", true);
        this.createNodeParam("Collection", "Collection", "If present, for each element in the collection, a separate token will be created. The element can be retrieved at the outgoing token of the fork node using the CollectionElement parameter.", SYSTEM_TYPE_OBJECT, false, true, inSocket);
        this.createNodeParam("CollectionElement", "Collection element", "Collection element that spawned the token.\nNote that the leaving token can run in non-interactive mode only. No visuals may be displayed here.", SYSTEM_TYPE_OBJECT, false, true, outSocket);
        node.addSocket(inSocket);
        node.addSocket(outSocket);
        return node;
    }

    public JoinNodeImpl createStandardJoinNode() {
        JoinNodeImpl node = new JoinNodeImpl();
        this.configureStandardNode((MultiSocketNode)node);
        return node;
    }

    public WaitStateNodeImpl createStandardWaitStateNode() {
        WaitStateNodeImpl node = new WaitStateNodeImpl();
        this.configureStandardNode((MultiSocketNode)node);
        return node;
    }

    public PlaceholderNodeImpl createStandardPlaceholderNode() {
        PlaceholderNodeImpl node = new PlaceholderNodeImpl();
        this.configureStandardNode((MultiSocketNode)node);
        return node;
    }

    public ActivityNodeImpl createStandardActivityNode() {
        ActivityNodeImpl node = new ActivityNodeImpl();
        this.configureStandardNode((MultiSocketNode)node);
        return node;
    }

    public VisualNodeImpl createStandardVisualNode() {
        VisualNodeImpl node = new VisualNodeImpl();
        this.configureStandardNode((MultiSocketNode)node);
        return node;
    }

    public WorkflowNodeImpl createStandardWorkflowNode() {
        WorkflowNodeImpl node = new WorkflowNodeImpl();
        this.createStandardName((Node)node);
        NodeSocket inSocket = this.createEntrySocket("In", true);
        NodeSocket publishedSocket = this.createExitSocket("TaskPublished", false);
        NodeSocket acceptedSocket = this.createExitSocket("TaskAccepted", true);
        this.createNodeParam("StepName", "Step name", "System name of this workflow step for dynamic assignment", SYSTEM_TYPE_STRING, false, true, inSocket);
        this.createNodeParam("StepDisplayName", "Step title", "Title of this workflow step for dynamic assignment", SYSTEM_TYPE_STRING, false, true, inSocket);
        this.createNodeParam("StepDescription", "Step description", "Detailled description of this workflow step for dynamic assignment", SYSTEM_TYPE_STRING, false, true, inSocket);
        this.createNodeParam("RoleId", "Role id", "Id of the role this workflow task is assigned to (public worklist) for dynamic assignment", SYSTEM_TYPE_STRING, false, true, inSocket);
        this.createNodeParam("UserId", "User id", "Id of the user this workflow task is assigned to (private worklist) for dynamic assignment", SYSTEM_TYPE_STRING, false, true, inSocket);
        this.createNodeParam("Priority", "Priority", "Priority of this workflow task (1-5) for dynamic assignment", SYSTEM_TYPE_INTEGER, false, true, inSocket);
        this.createNodeParam("RoleDefinitions", "Role definitions", "XML string describing ad-hoc role definitions that may override standard user-role assignments", SYSTEM_TYPE_STRING, false, true, inSocket);
        this.createNodeParam("DocumentIds", "Document ids", "List of ids (strings) or a single id of the documents or the dodcument that is processed by this workflow", SYSTEM_TYPE_OBJECT, false, true, inSocket);
        this.createNodeParam("DocumentMode", "Document mode", "Identifier that describes the processing mode of the document (application-specific, i. e. 'read', 'write' etc.", SYSTEM_TYPE_STRING, false, true, inSocket);
        this.createNodeParam(SYSTEM_TYPE_WORKFLOWTASK, "Workflow task", "Workflow task in case of reassignment of an existing task", SYSTEM_TYPE_WORKFLOWTASK, false, true, inSocket);
        this.createNodeParam(SYSTEM_TYPE_WORKFLOWTASK, "Workflow task", "Created workflow task", SYSTEM_TYPE_WORKFLOWTASK, false, true, publishedSocket);
        this.createNodeParam(SYSTEM_TYPE_WORKFLOWTASK, "Workflow task", "Resumed workflow task", SYSTEM_TYPE_WORKFLOWTASK, false, true, acceptedSocket);
        node.addSocket(inSocket);
        node.addSocket(publishedSocket);
        node.addSocket(acceptedSocket);
        return node;
    }

    public WorkflowEndNodeImpl createStandardWorkflowEndNode() {
        WorkflowEndNodeImpl node = new WorkflowEndNodeImpl();
        this.createStandardName((Node)node);
        NodeSocket inSocket = this.createEntrySocket("In", true);
        this.createNodeParam(SYSTEM_TYPE_WORKFLOWTASK, "Workflow task", "Workflow task that identifies the current workflow group or null to end all workflows that run in the current workflow group", SYSTEM_TYPE_WORKFLOWTASK, false, true, inSocket);
        node.addSocket(inSocket);
        return node;
    }

    public void ensureWorkflowTaskParameter(NodeSocket socket) {
        if (socket.getParamByName(SYSTEM_TYPE_WORKFLOWTASK) == null) {
            this.createNodeParam(SYSTEM_TYPE_WORKFLOWTASK, "Workflow task", "Resumed workflow task", SYSTEM_TYPE_WORKFLOWTASK, false, true, socket);
        }
    }

    public MergeNodeImpl createStandardMergeNode() {
        MergeNodeImpl node = new MergeNodeImpl();
        this.createStandardName((Node)node);
        NodeSocket inSocket1 = this.createEntrySocket("In1", true);
        NodeSocket inSocket2 = this.createEntrySocket("In2", false);
        NodeSocket outSocket = this.createExitSocket("Out", true);
        inSocket1.setGeometry(ProcessUtil.createSocketGeometry((String)"n"));
        inSocket2.setGeometry(ProcessUtil.createSocketGeometry((String)"e"));
        outSocket.setGeometry(ProcessUtil.createSocketGeometry((String)"s"));
        node.addSocket(inSocket1);
        node.addSocket(inSocket2);
        node.addSocket(outSocket);
        return node;
    }

    public NodeSocket createEntrySocket(String name, boolean isDefault) {
        NodeSocketImpl socket = new NodeSocketImpl();
        socket.setName(name);
        socket.setEntrySocket(true);
        socket.setDefaultSocket(isDefault);
        return socket;
    }

    public NodeSocket createExitSocket(String name, boolean isDefault) {
        NodeSocketImpl socket = new NodeSocketImpl();
        socket.setName(name);
        socket.setEntrySocket(false);
        socket.setDefaultSocket(isDefault);
        return socket;
    }

    private void configureStandardNode(MultiSocketNode node) {
        this.createStandardName((Node)node);
        NodeSocket inSocket = this.createEntrySocket("In", true);
        NodeSocket outSocket = this.createExitSocket("Out", true);
        node.addSocket(inSocket);
        node.addSocket(outSocket);
    }

    private NodeParam createNodeParam(String name, String displayName, String description, String systemTypeName, boolean visible, boolean optional, NodeSocket socket) {
        NodeParamImpl param = new NodeParamImpl();
        param.setName(name);
        param.setDisplayName(displayName);
        param.setDescription(description);
        ModelQualifier typeQualifier = new ModelQualifier("System", systemTypeName, "Type", null);
        DataTypeItem dataType = null;
        try {
            dataType = (DataTypeItem)ModelConnector.getInstance().getItemByQualifier(typeQualifier, true);
        }
        catch (ModelException e) {
            ExceptionUtil.printTrace((Throwable)e);
            return null;
        }
        param.setDataType(dataType);
        param.setTypeName(systemTypeName);
        param.setVisible(visible);
        param.setOptional(optional);
        if (socket != null) {
            socket.addParam((NodeParam)param);
        }
        return param;
    }

    private void createStandardName(Node node) {
        String s = node.getClass().getName();
        int i = s.lastIndexOf(46);
        if ((i = (s = s.substring(i + 1)).lastIndexOf("Node")) > 0) {
            s = s.substring(0, i);
        }
        node.setName(s);
    }
}

