/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.association;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.openbp.cockpit.plugins.association.MimeTypeAssociation;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.util.CopyUtil;

public class AssociationBean
extends DisplayObjectImpl {
    private List mimeTypes;

    public List getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(List mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public void addMimeType(MimeTypeAssociation mimeType) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new ArrayList();
        }
        this.mimeTypes.add(mimeType);
    }

    public MimeTypeAssociation getMimeTypeAssociation(String mimeType) {
        if (this.mimeTypes != null) {
            int n = this.mimeTypes.size();
            for (int i = 0; i < n; ++i) {
                MimeTypeAssociation a = (MimeTypeAssociation)((Object)this.mimeTypes.get(i));
                if (!mimeType.equals(a.getName())) continue;
                return a;
            }
        }
        return null;
    }

    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        AssociationBean sourceBean = (AssociationBean)((Object)source);
        this.mimeTypes = (List)CopyUtil.copyCollection((Collection)sourceBean.getMimeTypes(), (int)copyMode);
    }

    String serialize() {
        StringBuffer serialized = new StringBuffer(200);
        serialized.append("AssociationBean#");
        if (this.mimeTypes != null) {
            Iterator it = this.mimeTypes.iterator();
            while (it.hasNext()) {
                serialized.append(((MimeTypeAssociation)((Object)it.next())).serialize());
                serialized.append('*');
            }
        }
        serialized.append('#');
        return serialized.toString();
    }

    static AssociationBean deserialize(String serialized) {
        AssociationBean retVal = null;
        if (serialized != null && serialized.startsWith("AssociationBean#")) {
            retVal = new AssociationBean();
            serialized = serialized.substring(16, serialized.length() - 2);
            StringTokenizer st = new StringTokenizer(serialized, "*");
            while (st.hasMoreTokens()) {
                MimeTypeAssociation mta = MimeTypeAssociation.deserialize(st.nextToken());
                if (mta == null) continue;
                retVal.addMimeType(mta);
            }
        }
        return retVal;
    }
}

