/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.association;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openbp.cockpit.plugins.association.AssociationBean;
import org.openbp.cockpit.plugins.association.AssociationMimeTypesUtil;
import org.openbp.cockpit.plugins.association.MimeTypeAssociation;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionUtil;
import org.openbp.common.string.StringUtil;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.OpenEventInfo;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.event.RequestEvent;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.option.widget.PropertyBrowserWidget;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.OptionModule;
import org.openbp.swing.components.JMsgBox;

public class ExternalAssociationPlugin
extends AbstractPlugin {
    private AssociationBean assocBean;

    public ExternalAssociationPlugin() {
        XMLDriver xmlDriver = XMLDriver.getInstance();
        try {
            xmlDriver.loadMapping(AssociationBean.class);
            xmlDriver.loadMapping(MimeTypeAssociation.class);
        }
        catch (XMLDriverException e) {
            ExceptionUtil.printTrace((Throwable)e);
            return;
        }
    }

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    private boolean doOpenTarget(String target, String[] mimeTypes) {
        for (int i = 0; i < mimeTypes.length; ++i) {
            String program;
            MimeTypeAssociation mta = this.getMimeTypeAssociation(mimeTypes[i]);
            if (mta == null || (program = mta.getAssociatedProgram()) == null) continue;
            try {
                String[] cmdArray = new String[]{program, target};
                Runtime.getRuntime().exec(cmdArray);
            }
            catch (IOException e) {
                String msg = ResourceCollectionUtil.formatMsg((ResourceCollection)this.getPluginResourceCollection(), (String)"messages.execerror", (Object[])new Object[]{program});
                JMsgBox.show(null, (String)msg, (int)262144);
            }
            return true;
        }
        return false;
    }

    public MimeTypeAssociation getMimeTypeAssociation(String mimeType) {
        this.loadAssociations();
        return this.assocBean.getMimeTypeAssociation(mimeType);
    }

    private void loadAssociations() {
        if (this.assocBean == null) {
            this.assocBean = (AssociationBean)((Object)OptionMgr.getInstance().getOption("associations.mimetypes").getValue());
        }
    }

    private void clearCache() {
        this.assocBean = null;
    }

    public class AssociationOptionModule
    extends OptionModule {

        public class AssociationOption
        extends Option {
            public AssociationOption() {
                super(ExternalAssociationPlugin.this.getPluginResourceCollection(), "associations.mimetypes", (Object)new AssociationBean());
            }

            @Override
            public OptionWidget createOptionWidget() {
                return new PropertyBrowserWidget(this, null, 1);
            }

            @Override
            public String saveToString() {
                return ((AssociationBean)((Object)this.getValue())).serialize();
            }

            @Override
            public Object loadFromString(String cryptString) {
                return AssociationBean.deserialize(cryptString);
            }

            @Override
            public Object getValue() {
                AssociationBean associations = (AssociationBean)((Object)super.getValue());
                List assocList = associations.getMimeTypes();
                assocList = AssociationMimeTypesUtil.addDefaultAssociations(assocList, ExternalAssociationPlugin.this.getPluginResourceCollection());
                associations.setMimeTypes(assocList);
                return associations;
            }
        }
    }

    public class ExternalAssociationEvents
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.externalassociation";
        }

        public JaspiraEventHandlerCode openfile(OpenEvent openEvent) {
            File f;
            boolean isUrl;
            String fileName = (String)openEvent.getObject();
            if (fileName == null) {
                return EVENT_IGNORED;
            }
            boolean bl = isUrl = fileName.startsWith("http:") || fileName.startsWith("https:") || fileName.startsWith("ftp:");
            if (!isUrl && !(f = new File(fileName = StringUtil.normalizePathName((String)fileName))).exists()) {
                String msg = ResourceCollectionUtil.formatMsg((ResourceCollection)ExternalAssociationPlugin.this.getPluginResourceCollection(), (String)"messages.filedoesnotexist", (Object[])new Object[]{fileName});
                JMsgBox.show(null, (String)msg, (int)262144);
                return EVENT_CONSUMED;
            }
            if (ExternalAssociationPlugin.this.doOpenTarget(fileName, openEvent.getMimeTypes())) {
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode associations_mimetypes(JaspiraEvent je) {
            ExternalAssociationPlugin.this.clearCache();
            JaspiraEventMgr.fireGlobalEvent("plugin.association.update");
            return EVENT_HANDLED;
        }
    }

    public class AssociationEvents
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.association";
        }

        public JaspiraEventHandlerCode supports(RequestEvent event) {
            String mimeType = (String)event.getObject();
            MimeTypeAssociation mta = ExternalAssociationPlugin.this.getMimeTypeAssociation(mimeType);
            if (mta != null && mta.getAssociatedProgram() != null) {
                event.addResult(new OpenEventInfo("plugin.externalassociation.openfile", mimeType, mta.getDescription()));
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }
}

