/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.debugger;

import CH.ifa.draw.framework.Figure;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openbp.cockpit.Cockpit;
import org.openbp.cockpit.itemeditor.NodeItemEditorPlugin;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.cockpit.plugins.debugger.DebuggerOptionModule;
import org.openbp.cockpit.plugins.debugger.DebuggerServerEvent;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.setting.SettingUtil;
import org.openbp.core.OpenBPException;
import org.openbp.core.engine.debugger.DebuggerEvent;
import org.openbp.core.engine.debugger.DebuggerService;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.ControlLink;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.SingleSocketNode;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.QualifierEvent;
import org.openbp.guiclient.remote.ServerConnection;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.decoration.Decorator;
import org.openbp.jaspira.decoration.FilteredDecorator;
import org.openbp.jaspira.decoration.ListDecorator;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugins.errordialog.ErrorEvent;
import org.openbp.swing.components.JMsgBox;

public class DebuggerPlugin
extends AbstractPlugin {
    public static final Integer LINKTRACE_SKIP = new Integer(0);
    public static final Integer LINKTRACE_TARGET = new Integer(1);
    public static final Integer LINKTRACE_ANIMATION_STOP = new Integer(2);
    public static final Integer LINKTRACE_ANIMATION_GO = new Integer(3);
    private String clientId;
    private static DebuggerService debuggerService;
    private PollingThread poller;
    private boolean pollerActive;
    private ModelQualifier haltedPosition;
    private StepDecorator stepDecorator;
    private BreakPointDecorator breakpointDecorator;
    private AnimationThread animator;
    private ProcessItem currentProcess;
    private Integer controlLinkTraceMode;
    private Integer dataLinkTraceMode;
    private JaspiraAction toggleBreakpointsAction;
    private JaspiraAction clearBreakpointsAction;
    private JaspiraAction setBreakOnTopLevelAction;
    private JaspiraAction setBreakOnWorkflowAction;
    private JaspiraAction setBreakOnExceptionAction;
    private JaspiraAction stepIntoAction;
    private JaspiraAction stepOverAction;
    private JaspiraAction stepOutAction;
    private JaspiraAction stepNextAction;
    private JaspiraAction resumeAction;
    private JaspiraAction stopAction;
    private int maxStepCount;
    private int maxStepTime;
    private static final Double noStep;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.debugger";
    }

    protected void keepCompilerHappy() {
        if (this.controlLinkTraceMode == 0 && this.dataLinkTraceMode == 0 && this.currentProcess == null) {
            this.currentProcess = null;
        }
    }

    @Override
    protected Class[] getExternalOptionModuleClasses() {
        return new Class[]{DebuggerOptionModule.class};
    }

    @Override
    public void installFirstPlugin() {
        super.installFirstPlugin();
        this.maxStepCount = SettingUtil.getIntSetting((String)"openbp.cockpit.debugger.maxstepcount", (int)-1);
        this.maxStepTime = SettingUtil.getIntSetting((String)"openbp.cockpit.debugger.maxsteptime", (int)-1);
        this.registerDebugger(false);
    }

    DebuggerService getDebugger() {
        if (debuggerService == null && !this.registerDebugger(false)) {
            String msg = this.getPluginResourceCollection().getRequiredString("messages.nodebuggerservice");
            throw new OpenBPException("NoDebugger", msg);
        }
        return debuggerService;
    }

    boolean registerDebugger(boolean silentMode) {
        debuggerService = (DebuggerService)ServerConnection.getInstance().lookupOptionalService(DebuggerService.class);
        if (debuggerService == null) {
            return false;
        }
        try {
            int mode;
            String givenId = OptionMgr.getInstance().getStringOption("debugger.debuggerid", null);
            this.clientId = debuggerService.registerClient(givenId, 3600);
            int oldMode = mode = this.getDebugger().getDebuggerMode(this.clientId);
            boolean skipSystemModel = OptionMgr.getInstance().getBooleanOption("debugger.skipsystemmodel", true);
            mode = skipSystemModel ? (mode |= 4) : (mode &= 0xFFFFFFFB);
            if (mode != oldMode) {
                this.getDebugger().setDebuggerMode(this.clientId, mode);
            }
        }
        catch (Exception e) {
            if (!silentMode) {
                LogUtil.error(this.getClass(), (String)"Error connecting to the debugger service.", (Object)e);
            }
            debuggerService = null;
            return false;
        }
        this.startPoller();
        return true;
    }

    void unregisterDebugger() {
        if (this.clientId != null) {
            this.stopPoller();
            if (debuggerService != null) {
                try {
                    this.getDebugger().unregisterClient(this.clientId);
                }
                catch (Exception e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    this.clientId = null;
                }
                debuggerService = null;
            }
        }
    }

    private void handleError(Exception e) {
        String msg = ExceptionUtil.getNestedMessage((Throwable)e);
        JMsgBox.show(null, (String)msg, (int)65536);
    }

    @Override
    protected void pluginInstalled() {
        this.stepDecorator = new StepDecorator();
        this.toggleBreakpointsAction = this.getAction("debugger.client.togglebreakpoints");
        this.clearBreakpointsAction = this.getAction("debugger.client.clearbreakpoints");
        this.setBreakOnTopLevelAction = this.getAction("debugger.client.setbreakontoplevel");
        this.setBreakOnWorkflowAction = this.getAction("debugger.client.setbreakonworkflow");
        this.setBreakOnExceptionAction = this.getAction("debugger.client.setbreakonexception");
        this.stepIntoAction = this.getAction("debugger.client.stepinto");
        this.stepOverAction = this.getAction("debugger.client.stepover");
        this.stepOutAction = this.getAction("debugger.client.stepout");
        this.stepNextAction = this.getAction("debugger.client.stepnext");
        this.resumeAction = this.getAction("debugger.client.resume");
        this.stopAction = this.getAction("debugger.client.stop");
        try {
            int mode = this.getDebugger().getDebuggerMode(this.clientId);
            if (this.setBreakOnTopLevelAction != null) {
                this.setBreakOnTopLevelAction.setSelected((mode & 0x10) != 0);
            }
            if (this.setBreakOnWorkflowAction != null) {
                this.setBreakOnWorkflowAction.setSelected((mode & 0x20) != 0);
            }
            if (this.setBreakOnExceptionAction != null) {
                this.setBreakOnExceptionAction.setSelected((mode & 8) != 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateActions();
    }

    @Override
    protected void pluginUninstalled() {
        super.pluginUninstalled();
        this.deactivateStepDecorator();
        this.deactivateBreakpointDecorator();
    }

    @Override
    public void uninstallLastPlugin() {
        super.uninstallLastPlugin();
        this.unregisterDebugger();
    }

    void setHaltedPosition(ModelQualifier newPos) {
        if (this.haltedPosition != null) {
            ModelQualifier oldPosition = this.haltedPosition;
            this.haltedPosition = null;
            this.fireEvent(new QualifierEvent((Plugin)this, "modeler.view.invalidate", oldPosition));
        }
        this.haltedPosition = newPos;
        if (this.haltedPosition != null) {
            this.activateStepDecorator();
        } else {
            this.deactivateStepDecorator();
        }
        if (newPos != null) {
            ModelQualifier processQualifier = new ModelQualifier(newPos);
            processQualifier.setItemType("Process");
            processQualifier.setObjectPath(null);
            this.fireEvent(new OpenEvent(this, "open.modeler", processQualifier));
            this.fireEvent(new QualifierEvent((Plugin)this, "modeler.view.invalidate", newPos));
            this.scrollIntoView(newPos, true);
        }
        if (this.animator != null) {
            this.animator.abort();
        }
        this.fireEvent(new JaspiraEvent(this, "modeler.view.refresh"));
        this.updateActions();
    }

    void scrollIntoView(final ModelQualifier position, boolean addEnlargement) {
        final String eventName = addEnlargement ? "modeler.view.show" : "modeler.view.showexact";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggerPlugin.this.fireEvent(new QualifierEvent((Plugin)DebuggerPlugin.this, eventName, position));
            }
        });
    }

    void performDeferredRefresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggerPlugin.this.fireEvent("modeler.view.refresh");
            }
        });
    }

    void updateActions() {
        boolean hasSelection;
        boolean haveBreakpoints = this.breakpointDecorator != null;
        boolean haveHaltedProcess = this.haltedPosition != null;
        AskEvent ae = new AskEvent(this, "modeler.view.getselectioncount");
        this.fireEvent(ae);
        Integer selectionCount = (Integer)ae.getAnswer();
        boolean bl = hasSelection = selectionCount != null && selectionCount > 0;
        if (this.toggleBreakpointsAction != null) {
            this.toggleBreakpointsAction.setEnabled(hasSelection);
        }
        if (this.clearBreakpointsAction != null) {
            this.clearBreakpointsAction.setEnabled(haveBreakpoints);
        }
        if (this.stepIntoAction != null) {
            this.stepIntoAction.setEnabled(haveHaltedProcess);
        }
        if (this.stepOverAction != null) {
            this.stepOverAction.setEnabled(haveHaltedProcess);
        }
        if (this.stepOutAction != null) {
            this.stepOutAction.setEnabled(haveHaltedProcess);
        }
        if (this.stepNextAction != null) {
            this.stepNextAction.setEnabled(haveHaltedProcess);
        }
    }

    void runEntry(InitialNode initialNode, boolean step) {
        if (step) {
            ModelQualifier processQualifier = initialNode.getProcess().getQualifier();
            this.fireEvent(new OpenEvent(this, "open.modeler", processQualifier));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DebuggerPlugin.this.startPoller();
                }
                catch (Exception e) {
                    DebuggerPlugin.this.handleError(e);
                }
            }
        });
    }

    boolean autoSave() {
        if (OptionMgr.getInstance().getBooleanOption("debugger.autosave", true)) {
            this.fireEvent(new JaspiraActionEvent((Plugin)this, "standard.file.saveall", 0));
        }
        return true;
    }

    void startPoller() {
        if (!Cockpit.disableTimersForDebug && debuggerService != null) {
            this.pollerActive = true;
            if (this.poller == null) {
                this.poller = new PollingThread();
                this.poller.start();
            }
            this.fireEvent(new JaspiraEvent(this, "debugger.client.statuschange", this.clientId));
        }
    }

    void stopPoller() {
        this.pollerActive = false;
        this.fireEvent(new JaspiraEvent(this, "debugger.client.statuschange", null));
    }

    private void activateStepDecorator() {
        DecorationMgr.addDecorator(this, "Figure.FrameStroke", this.stepDecorator);
        DecorationMgr.addDecorator(this, "Figure.FrameColor", this.stepDecorator);
        DecorationMgr.addDecorator(this, "Tag.ContentType", this.stepDecorator);
    }

    private void deactivateStepDecorator() {
        DecorationMgr.removeDecorator(this, "Figure.FrameStroke", this.stepDecorator);
        DecorationMgr.removeDecorator(this, "Figure.FrameColor", this.stepDecorator);
        DecorationMgr.removeDecorator(this, "Tag.ContentType", this.stepDecorator);
    }

    protected void addBreakpoint(ModelQualifier qualifier) {
        this.activateBreakpointDecorator();
        this.breakpointDecorator.add(qualifier);
        this.fireEvent(new QualifierEvent((Plugin)this, "modeler.view.invalidate", qualifier));
    }

    void removeBreakpoint(ModelQualifier qualifier) {
        if (this.breakpointDecorator != null) {
            this.breakpointDecorator.remove(qualifier);
            this.fireEvent(new QualifierEvent((Plugin)this, "modeler.view.invalidate", qualifier));
            if (this.breakpointDecorator.isEmpty()) {
                this.deactivateBreakpointDecorator();
            }
        }
    }

    boolean hasBreakpoint(ModelQualifier qualifier) {
        if (this.breakpointDecorator != null) {
            return this.breakpointDecorator.qualifies(qualifier);
        }
        return false;
    }

    private void activateBreakpointDecorator() {
        if (this.breakpointDecorator == null) {
            this.breakpointDecorator = new BreakPointDecorator();
            DecorationMgr.addDecorator(this, "Figure.Overlay", this.breakpointDecorator);
            DecorationMgr.addDecorator(this, "Tag.ContentType", this.breakpointDecorator);
        }
    }

    void deactivateBreakpointDecorator() {
        if (this.breakpointDecorator != null) {
            DecorationMgr.removeDecorator(this, "Figure.Overlay", this.breakpointDecorator);
            DecorationMgr.removeDecorator(this, "Tag.ContentType", this.breakpointDecorator);
            this.breakpointDecorator = null;
        }
    }

    static {
        noStep = new Double(Double.NaN);
    }

    class AnimationThread
    extends Thread
    implements Decorator {
        private Double stepDecorationValue;
        private transient PolySplineConnection connection;
        private double stepWidth;
        private int stepTime;
        private boolean aborted;
        private boolean autoStep;

        public AnimationThread(ModelQualifier qualifier, boolean autoStep) {
            super("Debugger animation");
            this.stepDecorationValue = noStep;
            this.setDaemon(true);
            AskEvent ae = new AskEvent(DebuggerPlugin.this, "modeler.view.getbyqualifier", qualifier);
            DebuggerPlugin.this.fireEvent(ae);
            if (ae.getAnswer() instanceof PolySplineConnection) {
                this.connection = (PolySplineConnection)ae.getAnswer();
                DebuggerPlugin.this.animator = this;
                this.autoStep = autoStep;
                Rectangle box = this.connection.getSplineBounds();
                int l = (int)Math.sqrt(box.width * box.width + box.height * box.height);
                int steps = l / 5;
                if (steps < 10) {
                    steps = l / 3;
                    if (steps < 10) {
                        steps = Math.max(l, 10);
                    }
                } else if (steps > 100) {
                    steps = 100;
                }
                if (DebuggerPlugin.this.maxStepCount > 0 && steps > DebuggerPlugin.this.maxStepCount) {
                    steps = DebuggerPlugin.this.maxStepCount;
                }
                this.stepWidth = 1.0 / (double)steps;
                this.stepTime = 1000 / steps;
                if (DebuggerPlugin.this.maxStepTime >= 0 && this.stepTime > DebuggerPlugin.this.maxStepTime) {
                    this.stepTime = DebuggerPlugin.this.maxStepTime;
                }
                DecorationMgr.addDecorator(DebuggerPlugin.this, "Line.Animation", this);
                this.start();
            } else if (autoStep) {
                DebuggerPlugin.this.fireEvent(new JaspiraActionEvent((Plugin)DebuggerPlugin.this, "debugger.client.stepnext", 0));
            }
        }

        @Override
        public void run() {
            for (double currentStep = 0.0; currentStep < 1.0 && !this.aborted; currentStep += this.stepWidth) {
                this.stepDecorationValue = new Double(currentStep);
                if (this.connection != null) {
                    this.connection.invalidate();
                    DebuggerPlugin.this.performDeferredRefresh();
                }
                if (this.stepTime <= 0) continue;
                try {
                    Thread.sleep(this.stepTime);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.autoStep && !this.aborted) {
                DebuggerPlugin.this.fireEvent(new JaspiraActionEvent((Plugin)DebuggerPlugin.this, "debugger.client.stepnext", 0));
            }
            this.aborted = false;
            DebuggerPlugin.this.animator = null;
            DecorationMgr.removeDecorator(DebuggerPlugin.this, "Line.Animation", this);
            if (this.connection != null) {
                this.connection.invalidate();
                DebuggerPlugin.this.performDeferredRefresh();
            }
        }

        @Override
        public Object decorate(Object owner, String key, Object value) {
            if (this.connection == owner) {
                return this.stepDecorationValue;
            }
            return value;
        }

        public void abort() {
            this.aborted = true;
        }
    }

    public class BreakPointDecorator
    extends ListDecorator {
        @Override
        public boolean qualifies(Object owner) {
            ModelQualifier qualifier = null;
            if (owner instanceof ModelQualifier) {
                qualifier = (ModelQualifier)owner;
            } else if (owner instanceof SocketFigure) {
                SocketFigure socketFigure = (SocketFigure)owner;
                qualifier = socketFigure.getNodeSocket().getQualifier();
            }
            return super.qualifies(qualifier);
        }

        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            if (key == "Figure.Overlay" && owner instanceof SocketFigure) {
                Figure overlay = FigureResources.getBreakpointOverlay(owner);
                return overlay;
            }
            if (key == "Tag.ContentType") {
                return new Integer((Integer)value | 4 | 2);
            }
            return value;
        }
    }

    public class StepDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            if (key == "Figure.FrameStroke") {
                return ModelerGraphics.debuggerStroke;
            }
            if (key == "Figure.FrameColor") {
                return ModelerColors.DEBUGGER_BORDER;
            }
            if (key == "Tag.ContentType") {
                return new Integer((Integer)value | 4 | 2);
            }
            return value;
        }

        @Override
        public boolean qualifies(Object owner) {
            ModelQualifier qualifier;
            if (owner instanceof ModelQualifier) {
                qualifier = (ModelQualifier)owner;
            } else {
                if (!(owner instanceof ProcessElementContainer)) {
                    return false;
                }
                qualifier = ((ProcessElementContainer)owner).getProcessElement().getQualifier();
            }
            return qualifier.matches((Object)DebuggerPlugin.this.haltedPosition);
        }
    }

    class PollingThread
    extends Thread {
        public PollingThread() {
            super("Debugger event poller");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (DebuggerPlugin.this.pollerActive) {
                try {
                    DebuggerEvent event = DebuggerPlugin.this.getDebugger().getEvent(DebuggerPlugin.this.clientId);
                    if (event != null) {
                        DebuggerPlugin.this.stopPoller();
                        DebuggerPlugin.this.fireEvent(new DebuggerServerEvent((Plugin)DebuggerPlugin.this, event));
                    }
                }
                catch (Exception e) {
                    if (!DebuggerPlugin.this.registerDebugger(true)) break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            DebuggerPlugin.this.poller = null;
        }
    }

    public class ServerEvents
    extends EventModule {
        @Override
        public String getName() {
            return "debugger.server";
        }

        public JaspiraEventHandlerCode nodeentry(DebuggerServerEvent dse) {
            ModelQualifier pos = new ModelQualifier(dse.getHaltedPosition());
            DebuggerPlugin.this.setHaltedPosition(pos);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode nodeexit(DebuggerServerEvent dse) {
            ModelQualifier pos = new ModelQualifier(dse.getHaltedPosition());
            DebuggerPlugin.this.setHaltedPosition(pos);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode controlflow(DebuggerServerEvent dse) {
            if (DebuggerPlugin.this.maxStepCount != 0) {
                DebuggerEvent de = dse.getDebuggerEvent();
                DebuggerPlugin.this.scrollIntoView(de.getControlLinkQualifier(), false);
                new AnimationThread(de.getControlLinkQualifier(), true);
            } else {
                DebuggerPlugin.this.fireEvent(new JaspiraActionEvent((Plugin)DebuggerPlugin.this, "debugger.client.stepnext", 0));
            }
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode dataflow(DebuggerServerEvent dse) {
            DebuggerEvent de = dse.getDebuggerEvent();
            ModelQualifier pos = dse.getHaltedPosition();
            if (ViewModeMgr.getInstance().isDataLinkVisible()) {
                DebuggerPlugin.this.setHaltedPosition(new ModelQualifier(pos));
            }
            if (DebuggerPlugin.this.maxStepCount != 0 && ViewModeMgr.getInstance().isDataLinkVisible()) {
                DebuggerPlugin.this.scrollIntoView(de.getDataLinkQualifier(), false);
                new AnimationThread(de.getDataLinkQualifier(), false);
            } else {
                DebuggerPlugin.this.fireEvent(new JaspiraActionEvent((Plugin)DebuggerPlugin.this, "debugger.client.stepnext", 0));
            }
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode processexception(DebuggerServerEvent dse) {
            ModelQualifier haltedPosition = dse.getHaltedPosition();
            DebuggerPlugin.this.setHaltedPosition(new ModelQualifier(haltedPosition));
            ModelQualifier msgPosition = new ModelQualifier(haltedPosition);
            msgPosition.setObjectPath(null);
            String message = "Exception in process '" + msgPosition + "':";
            if (dse.getException() != null) {
                DebuggerPlugin.this.fireEvent(new ErrorEvent((Plugin)DebuggerPlugin.this, message, dse.getException()));
            } else {
                DebuggerPlugin.this.fireEvent(new ErrorEvent((Plugin)DebuggerPlugin.this, message, dse.getExceptionString()));
            }
            return EVENT_HANDLED;
        }

        @Override
        protected JaspiraEventHandlerCode handleUnaccountedEvent(JaspiraEvent ev) {
            LogUtil.error(this.getClass(), (String)"Unknown server event $0.", (Object)ev);
            return super.handleUnaccountedEvent(ev);
        }
    }

    public class InteractionEvents
    extends InteractionModule {
        @Override
        public int getPriority() {
            return 2;
        }

        @Override
        public JaspiraEventHandlerCode popup(InteractionEvent ie) {
            if (ie.getSource() instanceof NodeItemEditorPlugin) {
                return EVENT_IGNORED;
            }
            if (ie.isDataFlavorSupported(ClientFlavors.INITIAL_NODE) || ie.isDataFlavorSupported(ClientFlavors.FINAL_NODE)) {
                SingleSocketNode node = ie.isDataFlavorSupported(ClientFlavors.INITIAL_NODE) ? (SingleSocketNode)ie.getSafeTransferData(ClientFlavors.INITIAL_NODE) : (SingleSocketNode)ie.getSafeTransferData(ClientFlavors.FINAL_NODE);
                NodeSocket socket = node.getSocket();
                this.setupSocketContextMenu(ie, socket);
            }
            if (ie.isDataFlavorSupported(ClientFlavors.NODE_SOCKET)) {
                NodeSocket socket = (NodeSocket)ie.getSafeTransferData(ClientFlavors.NODE_SOCKET);
                this.setupSocketContextMenu(ie, socket);
            }
            return EVENT_HANDLED;
        }

        @Override
        public JaspiraEventHandlerCode toolbar(InteractionEvent ie) {
            if (ie.getSourcePlugin() instanceof Modeler) {
                JaspiraAction group = new JaspiraAction("breakpoint", null, null, null, null, 2, "group");
                if (DebuggerPlugin.this.toggleBreakpointsAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.toggleBreakpointsAction);
                }
                if (DebuggerPlugin.this.clearBreakpointsAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.clearBreakpointsAction);
                }
                ie.add(group);
                group = new JaspiraAction("step", null, null, null, null, 3, "group");
                if (DebuggerPlugin.this.stepIntoAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.stepIntoAction);
                }
                if (DebuggerPlugin.this.stepOverAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.stepOverAction);
                }
                if (DebuggerPlugin.this.stepOutAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.stepOutAction);
                }
                if (DebuggerPlugin.this.stepNextAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.stepNextAction);
                }
                if (DebuggerPlugin.this.resumeAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.resumeAction);
                }
                if (DebuggerPlugin.this.stopAction != null) {
                    group.addToolbarChild(DebuggerPlugin.this.stopAction);
                }
                ie.add(group);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        private void setupSocketContextMenu(InteractionEvent ie, final NodeSocket socket) {
            JaspiraAction group = new JaspiraAction("popupbreakpoint", null, null, null, null, 1, "group");
            group.addMenuChild(new JaspiraAction(DebuggerPlugin.this, "debugger.client.togglebreakpoint"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebuggerPlugin.this.fireEvent(new QualifierEvent((Plugin)DebuggerPlugin.this, "debugger.client.togglebreakpoint", socket.getQualifier()));
                }
            });
            ie.add(group);
            if (DebuggerPlugin.this.haltedPosition != null) {
                group = new JaspiraAction("popupstep", null, null, null, null, 3, "group");
                group.addMenuChild(new JaspiraAction(DebuggerPlugin.this, "debugger.client.stepuntil"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DebuggerPlugin.this.fireEvent(new QualifierEvent((Plugin)DebuggerPlugin.this, "debugger.client.stepuntil", socket.getQualifier()));
                    }
                });
                ie.add(group);
            }
        }
    }

    public class OptionEvents
    extends EventModule {
        @Override
        public String getName() {
            return "debugger";
        }

        @Override
        public int getPriority() {
            return 100;
        }

        public JaspiraEventHandlerCode skipsystemmodel(JaspiraEvent je) {
            boolean skip = (Boolean)((Option)je.getObject()).getValue();
            try {
                int mode;
                int oldMode = mode = DebuggerPlugin.this.getDebugger().getDebuggerMode(DebuggerPlugin.this.clientId);
                mode = skip ? (mode |= 4) : (mode &= 0xFFFFFFFB);
                if (mode != oldMode) {
                    DebuggerPlugin.this.getDebugger().setDebuggerMode(DebuggerPlugin.this.clientId, mode);
                }
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode controllinktracemode(JaspiraEvent je) {
            DebuggerPlugin.this.controlLinkTraceMode = (Integer)((Option)je.getObject()).getValue();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode datalinktracemode(JaspiraEvent je) {
            DebuggerPlugin.this.dataLinkTraceMode = (Integer)((Option)je.getObject()).getValue();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode debuggerid(JaspiraEvent je) {
            DebuggerPlugin.this.unregisterDebugger();
            DebuggerPlugin.this.registerDebugger(false);
            return EVENT_HANDLED;
        }
    }

    public class ClientEvents
    extends EventModule {
        @Override
        public String getName() {
            return "debugger.client";
        }

        @Override
        public int getPriority() {
            return 100;
        }

        public JaspiraEventHandlerCode togglebreakpoints(JaspiraActionEvent jae) {
            ModelQualifier qualifier;
            int iQualifiers;
            AskEvent ae = new AskEvent(DebuggerPlugin.this, "modeler.view.getselection");
            DebuggerPlugin.this.fireEvent(ae);
            List selection = (List)ae.getAnswer();
            if (selection == null || selection.size() == 0) {
                return EVENT_IGNORED;
            }
            ArrayList<ModelQualifier> qualifiers = new ArrayList<ModelQualifier>();
            int nSelected = selection.size();
            for (int iSelected = 0; iSelected < nSelected; ++iSelected) {
                Object o = selection.get(iSelected);
                if (o instanceof SocketFigure) {
                    NodeSocket socket = ((SocketFigure)o).getNodeSocket();
                    qualifiers.add(socket.getQualifier());
                    continue;
                }
                if (o instanceof NodeFigure) {
                    Node node = ((NodeFigure)o).getNode();
                    Iterator itSockets = node.getSockets();
                    while (itSockets.hasNext()) {
                        NodeSocket socket = (NodeSocket)itSockets.next();
                        qualifiers.add(socket.getQualifier());
                    }
                    continue;
                }
                if (!(o instanceof FlowConnection)) continue;
                ControlLink controlLink = ((FlowConnection)o).getControlLink();
                qualifiers.add(controlLink.getSourceSocket().getQualifier());
                qualifiers.add(controlLink.getTargetSocket().getQualifier());
            }
            int nQualifiers = qualifiers.size();
            if (nQualifiers == 0) {
                return EVENT_IGNORED;
            }
            boolean setBp = false;
            for (iQualifiers = 0; iQualifiers < nQualifiers; ++iQualifiers) {
                qualifier = (ModelQualifier)qualifiers.get(iQualifiers);
                if (DebuggerPlugin.this.hasBreakpoint(qualifier)) continue;
                setBp = true;
                break;
            }
            try {
                for (iQualifiers = 0; iQualifiers < nQualifiers; ++iQualifiers) {
                    qualifier = (ModelQualifier)qualifiers.get(iQualifiers);
                    boolean hasBp = DebuggerPlugin.this.hasBreakpoint(qualifier);
                    if (setBp) {
                        if (hasBp) continue;
                        DebuggerPlugin.this.getDebugger().setBreakpoint(DebuggerPlugin.this.clientId, qualifier, 0);
                        DebuggerPlugin.this.addBreakpoint(qualifier);
                        continue;
                    }
                    if (!hasBp) continue;
                    DebuggerPlugin.this.getDebugger().clearBreakpoint(DebuggerPlugin.this.clientId, qualifier);
                    DebuggerPlugin.this.removeBreakpoint(qualifier);
                }
                DebuggerPlugin.this.fireEvent(new JaspiraEvent(DebuggerPlugin.this, "modeler.view.refresh"));
                DebuggerPlugin.this.updateActions();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode clearbreakpoints(JaspiraActionEvent jae) {
            try {
                DebuggerPlugin.this.getDebugger().clearBreakpoints(DebuggerPlugin.this.clientId, null);
                DebuggerPlugin.this.deactivateBreakpointDecorator();
                DebuggerPlugin.this.fireEvent(new JaspiraEvent(DebuggerPlugin.this, "modeler.view.redraw"));
                DebuggerPlugin.this.updateActions();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode setBreakOnTopLevel(JaspiraActionEvent jae) {
            try {
                int mode = DebuggerPlugin.this.getDebugger().getDebuggerMode(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.getDebugger().setDebuggerMode(DebuggerPlugin.this.clientId, mode ^= 0x10);
                if (DebuggerPlugin.this.setBreakOnTopLevelAction != null) {
                    DebuggerPlugin.this.setBreakOnTopLevelAction.setSelected((mode & 0x10) != 0);
                }
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode setBreakOnWorkflow(JaspiraActionEvent jae) {
            try {
                int mode = DebuggerPlugin.this.getDebugger().getDebuggerMode(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.getDebugger().setDebuggerMode(DebuggerPlugin.this.clientId, mode ^= 0x20);
                if (DebuggerPlugin.this.setBreakOnWorkflowAction != null) {
                    DebuggerPlugin.this.setBreakOnWorkflowAction.setSelected((mode & 0x20) != 0);
                }
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode setBreakOnException(JaspiraActionEvent jae) {
            try {
                int mode = DebuggerPlugin.this.getDebugger().getDebuggerMode(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.getDebugger().setDebuggerMode(DebuggerPlugin.this.clientId, mode ^= 8);
                if (DebuggerPlugin.this.setBreakOnExceptionAction != null) {
                    DebuggerPlugin.this.setBreakOnExceptionAction.setSelected((mode & 8) != 0);
                }
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode stepInto(JaspiraActionEvent jae) {
            if (!DebuggerPlugin.this.autoSave()) {
                return EVENT_CONSUMED;
            }
            DebuggerPlugin.this.setHaltedPosition(null);
            try {
                debuggerService.stepInto(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.startPoller();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode stepOut(JaspiraActionEvent jae) {
            if (!DebuggerPlugin.this.autoSave()) {
                return EVENT_CONSUMED;
            }
            DebuggerPlugin.this.setHaltedPosition(null);
            try {
                DebuggerPlugin.this.getDebugger().stepOut(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.startPoller();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode stepOver(JaspiraActionEvent jae) {
            if (!DebuggerPlugin.this.autoSave()) {
                return EVENT_CONSUMED;
            }
            DebuggerPlugin.this.setHaltedPosition(null);
            try {
                DebuggerPlugin.this.getDebugger().stepOver(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.startPoller();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode stepNext(JaspiraActionEvent jae) {
            if (!DebuggerPlugin.this.autoSave()) {
                return EVENT_CONSUMED;
            }
            DebuggerPlugin.this.setHaltedPosition(null);
            try {
                DebuggerPlugin.this.getDebugger().stepNext(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.startPoller();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode stop(JaspiraActionEvent jae) {
            if (!DebuggerPlugin.this.autoSave()) {
                return EVENT_CONSUMED;
            }
            DebuggerPlugin.this.setHaltedPosition(null);
            try {
                DebuggerPlugin.this.getDebugger().stop(DebuggerPlugin.this.clientId);
                DebuggerPlugin.this.startPoller();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode resume(JaspiraActionEvent jae) {
            if (!DebuggerPlugin.this.autoSave()) {
                return EVENT_CONSUMED;
            }
            if (DebuggerPlugin.this.haltedPosition == null) {
                DebuggerPlugin.this.startPoller();
            } else {
                DebuggerPlugin.this.setHaltedPosition(null);
                try {
                    DebuggerPlugin.this.getDebugger().run(DebuggerPlugin.this.clientId);
                    DebuggerPlugin.this.startPoller();
                }
                catch (Exception e) {
                    DebuggerPlugin.this.handleError(e);
                }
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode getdebuggerid(AskEvent ae) {
            try {
                DebuggerPlugin.this.getDebugger();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            ae.setAnswer(DebuggerPlugin.this.clientId);
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode toggleBreakpoint(QualifierEvent je) {
            ModelQualifier target = je.getQualifier();
            try {
                if (DebuggerPlugin.this.hasBreakpoint(target)) {
                    DebuggerPlugin.this.getDebugger().clearBreakpoint(DebuggerPlugin.this.clientId, target);
                    DebuggerPlugin.this.removeBreakpoint(target);
                } else {
                    DebuggerPlugin.this.getDebugger().setBreakpoint(DebuggerPlugin.this.clientId, target, 0);
                    DebuggerPlugin.this.addBreakpoint(target);
                }
                DebuggerPlugin.this.fireEvent(new JaspiraEvent(DebuggerPlugin.this, "modeler.view.refresh"));
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode stepUntil(QualifierEvent je) {
            if (!DebuggerPlugin.this.autoSave()) {
                return EVENT_CONSUMED;
            }
            DebuggerPlugin.this.setHaltedPosition(null);
            ModelQualifier target = je.getQualifier();
            try {
                DebuggerPlugin.this.getDebugger().stepUntil(DebuggerPlugin.this.clientId, target.toString());
                DebuggerPlugin.this.startPoller();
            }
            catch (Exception e) {
                DebuggerPlugin.this.handleError(e);
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode connectionlost(QualifierEvent je) {
            this.clearbreakpoints(null);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                DebuggerPlugin.this.currentProcess = ((Modeler)o).getProcess();
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_closed(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                DebuggerPlugin.this.currentProcess = null;
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_selectionchanged(JaspiraEvent je) {
            Object source = je.getSource();
            if (source instanceof Modeler) {
                Modeler modeler = (Modeler)source;
                if (modeler.getPluginComponent().isShowing()) {
                    DebuggerPlugin.this.updateActions();
                }
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode plugin_serverconnection_reconnect(JaspiraEvent je) {
            this.clearbreakpoints(null);
            return EVENT_HANDLED;
        }
    }
}

