/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.debugger;

import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import org.openbp.common.logger.LogUtil;
import org.openbp.core.OpenBPException;
import org.openbp.core.engine.debugger.DebuggerService;
import org.openbp.core.engine.debugger.ObjectMemberInfo;
import org.openbp.swing.components.treetable.DefaultTreeTableNode;

public class InspectorNode
extends DefaultTreeTableNode {
    private static final int NODESTATUS_UNKNOWN = 0;
    private static final int NODESTATUS_PARENT = 1;
    private static final int NODESTATUS_LEAF = 2;
    private String contextPath;
    private String expression;
    private ObjectMemberInfo info;
    private Dimension preferredSize;
    private int nodeStatus = 0;
    private boolean hasDetailInfo;
    private static String clientId;
    private static DebuggerService debuggerService;

    protected InspectorNode() {
    }

    protected InspectorNode(String clientId, DebuggerService debuggerService) {
        InspectorNode.clientId = clientId;
        InspectorNode.debuggerService = debuggerService;
        this.loadChildren();
    }

    private InspectorNode(ObjectMemberInfo info, String contextPath, String expression, InspectorNode parent) {
        this.info = info;
        this.contextPath = contextPath;
        this.expression = expression;
        this.parent = parent;
        if (!info.isParentMember()) {
            this.nodeStatus = 2;
        }
    }

    public ObjectMemberInfo getInfo() {
        return this.info;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getNodeText() {
        if (this.info == null) {
            return null;
        }
        return this.info.getKey();
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(0, 0);
        }
        return this.preferredSize;
    }

    public Object getColumnValue(int columnIndex) {
        if (columnIndex == 1) {
            if (this.info == null) {
                return null;
            }
            String[] multiText = new String[]{this.info.getType()};
            return multiText;
        }
        if (columnIndex == 2) {
            if (this.info == null) {
                return null;
            }
            String[] multiText = new String[]{this.info.getToStringValue()};
            return multiText;
        }
        return super.getColumnValue(columnIndex);
    }

    public boolean isLeaf() {
        return this.nodeStatus == 2;
    }

    void loadChildren() {
        if (this.nodeStatus != 0) {
            return;
        }
        if (debuggerService == null) {
            return;
        }
        if (this.info != null && "...".equals(this.info.getKey())) {
            return;
        }
        List list = null;
        try {
            list = debuggerService.getObjectMembers(clientId, this.contextPath, this.expression);
        }
        catch (OpenBPException e) {
            LogUtil.error(((Object)((Object)this)).getClass(), (String)"Error while connecting to the debugger service.", (Object)((Object)e));
        }
        if (list == null || list.size() == 0) {
            this.nodeStatus = 2;
            return;
        }
        Vector<InspectorNode> childrenList = new Vector<InspectorNode>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ObjectMemberInfo childInfo = (ObjectMemberInfo)list.get(i);
            String key = childInfo.getKey();
            String cp = null;
            String ex = null;
            if (this.contextPath == null) {
                cp = key;
            } else {
                cp = this.contextPath;
                ex = this.expression != null ? (key.startsWith("[") ? this.expression + key : this.expression + '.' + key) : key;
            }
            InspectorNode child = new InspectorNode(childInfo, cp, ex, this);
            childrenList.add(child);
        }
        this.children = childrenList;
        this.nodeStatus = 1;
    }

    void loadValueDetails() {
        if (this.hasDetailInfo) {
            return;
        }
        this.hasDetailInfo = true;
        if (debuggerService == null) {
            return;
        }
        try {
            ObjectMemberInfo valueInfo = debuggerService.getObjectValue(clientId, this.contextPath, this.expression);
            if (this.info != null && valueInfo != null) {
                this.info.setToStringValue(valueInfo.getToStringValue());
            }
        }
        catch (OpenBPException e) {
            LogUtil.error(((Object)((Object)this)).getClass(), (String)"Error while connecting to the debugger service.", (Object)((Object)e));
        }
    }
}

