/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.finder;

import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.openbp.cockpit.modeler.ModelerPage;
import org.openbp.cockpit.plugins.finder.FinderResultPlugin;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.TabbedPluginContainer;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;

public class FinderPlugin
extends AbstractPlugin {
    protected JaspiraAction findReferenceAction;
    protected FinderPlugin plugin = this;
    protected ModelObject contextModelObject;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.finder";
    }

    @Override
    protected void pluginInstalled() {
        super.pluginInstalled();
        this.findReferenceAction = this.getAction("plugin.finder.findref");
    }

    void extractModelObject(ModelObject core) {
        this.contextModelObject = null;
        if (core instanceof Item) {
            this.contextModelObject = core;
        } else if (core instanceof NodeParam) {
            this.contextModelObject = ((NodeParam)core).getDataType();
        } else if (core instanceof InitialNode) {
            this.contextModelObject = core;
        }
    }

    FinderResultPlugin determineFinderResultPlugin() {
        Iterator arpList = PluginMgr.getInstance().getPluginInstances("org.openbp.cockpit.plugins.finder.FinderResultPlugin");
        FinderResultPlugin plugin = !arpList.hasNext() ? (FinderResultPlugin)PluginMgr.getInstance().createVisibleInstance(FinderResultPlugin.class, (Plugin)this) : (FinderResultPlugin)arpList.next();
        TabbedPluginContainer tpc = plugin.getPluginPanel().getTabbedContainer();
        if (tpc == null) {
            JaspiraEvent je = new JaspiraEvent(this, "global.plugin.addtocontainer", plugin);
            je.setTargetClassName("org.openbp.cockpit.plugins.itembrowser.ItemBrowserPlugin");
            this.fireEvent(je);
        }
        return plugin;
    }

    public class InteractionEvents
    extends InteractionModule {
        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public JaspiraEventHandlerCode popup(InteractionEvent ie) {
            if (!ie.isDataFlavorSupported(ClientFlavors.MODEL_OBJECT) || FinderPlugin.this.findReferenceAction == null) {
                return EVENT_IGNORED;
            }
            if (ie.isDataFlavorSupported(ClientFlavors.ITEM)) {
                FinderPlugin.this.contextModelObject = (Item)ie.getSafeTransferData(ClientFlavors.ITEM);
            } else {
                ModelObject core = (ModelObject)ie.getSafeTransferData(ClientFlavors.MODEL_OBJECT);
                FinderPlugin.this.extractModelObject(core);
            }
            if (FinderPlugin.this.contextModelObject != null) {
                JaspiraAction group = new JaspiraAction("popup.finder", null, null, null, null, 120, "group");
                group.addMenuChild(FinderPlugin.this.findReferenceAction);
                ie.add(group);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.finder";
        }

        public JaspiraEventHandlerCode findref(JaspiraActionEvent je) {
            if (FinderPlugin.this.contextModelObject != null) {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        AskEvent ae = new AskEvent(FinderPlugin.this.plugin, "plugin.finder.register");
                        FinderPlugin.this.plugin.fireEvent(ae);
                        ((FinderResultPlugin)ae.getAnswer()).focusPlugin();
                        FinderPlugin.this.plugin.fireEvent("plugin.finderresult.present", FinderPlugin.this.contextModelObject);
                    }
                });
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode register(AskEvent ae) {
            ae.setAnswer(FinderPlugin.this.determineFinderResultPlugin());
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode global_page_added(JaspiraEvent je) {
            if (je.getObject() instanceof ModelerPage) {
                FinderPlugin.this.determineFinderResultPlugin();
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }
}

