/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.finder;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.cockpit.plugins.finder.FinderResultRenderer;
import org.openbp.cockpit.plugins.finder.RefStrategy;
import org.openbp.cockpit.plugins.finder.treemodel.GenericModel;
import org.openbp.cockpit.plugins.finder.treemodel.LeafNode;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionUtil;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.activity.ActivityParam;
import org.openbp.core.model.item.activity.ActivitySocket;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.type.DataMember;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.QualifierEvent;
import org.openbp.guiclient.model.item.itemfinder.FinderEngineImpl;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.action.JaspiraPopupMenu;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.swing.components.tree.TreeExpander;
import org.openbp.swing.plaf.sky.SkyTheme;

public class FinderResultPlugin
extends AbstractVisiblePlugin {
    private RefStrategy strategy;
    private JLabel label;
    private TreeExpander treeExpander;
    protected JTree tree;
    protected GenericModel model;
    protected ModelObject referenceObject;
    protected List referenceList;
    protected JPanel topPanel;
    protected JaspiraAction clearListAction;
    protected JaspiraAction refreshAction;
    static ImageIcon finderResultIcon;

    public FinderResultPlugin() {
        finderResultIcon = (ImageIcon)this.getPluginResourceCollection().getOptionalObject("icon.finder.result");
    }

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.finder";
    }

    @Override
    protected void initializeComponents() {
        this.clearListAction = this.getAction("plugin.finderresult.delete");
        if (this.clearListAction != null) {
            this.clearListAction.setEnabled(false);
        }
        this.refreshAction = this.getAction("plugin.finderresult.refresh");
        if (this.refreshAction != null) {
            this.refreshAction.setEnabled(false);
        }
        this.strategy = new RefStrategy();
        this.model = new GenericModel(this.strategy, true);
        this.tree = new JTree();
        this.treeExpander = new TreeExpander(this.tree);
        this.tree.setToggleClickCount(2);
        this.tree.setRootVisible(false);
        this.tree.setModel(this.model);
        this.tree.setCellRenderer(new FinderResultRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    FinderResultPlugin.this.showPopup(e.getPoint());
                } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                    FinderResultPlugin.this.focus(e.getPoint());
                }
            }
        });
        this.label = new JLabel();
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.topPanel.setVisible(false);
        this.topPanel.add(this.label);
        this.topPanel.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
        this.topPanel.setBorder(new EmptyBorder(1, 3, 4, 4));
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)new JScrollPane(this.tree), "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showPopup(Point pos) {
        int selectedRow = this.tree.getClosestRowForLocation(pos.x, pos.y);
        TreePath path = this.tree.getPathForRow(selectedRow);
        if (path == null) {
            return;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (!node.isLeaf()) {
            return;
        }
        ApplicationUtil.waitCursorOn();
        int row = this.tree.getRowForPath(path);
        this.tree.setSelectionRow(row);
        InteractionEvent iae = null;
        try {
            iae = new InteractionEvent((Plugin)this, "popup", new BasicTransferable(((LeafNode)((Object)node)).getLeafData()));
            this.fireEvent(iae);
        }
        finally {
            ApplicationUtil.waitCursorOff();
        }
        JaspiraPopupMenu menu = iae.createPopupMenu();
        if (menu != null) {
            menu.show(this.tree, pos.x, pos.y);
        }
    }

    @Override
    public int getToolbarType() {
        return 2;
    }

    void updateModel() {
        this.topPanel.setVisible(true);
        Integer n = new Integer(this.referenceList != null ? this.referenceList.size() : 0);
        String text = ResourceCollectionUtil.formatMsg((ResourceCollection)this.getPluginResourceCollection(), (String)"search.hits", (Object)n, (Object)this.referenceObject.getName());
        String toolTipText = ResourceCollectionUtil.formatMsg((ResourceCollection)this.getPluginResourceCollection(), (String)"search.hits", (Object)n, (Object)this.referenceObject.getQualifier());
        this.label.setText(text);
        this.label.setToolTipText(toolTipText);
        if (this.referenceList != null) {
            if (this.referenceObject instanceof Item) {
                this.strategy.setReferenceItemType(((Item)this.referenceObject).getItemType());
            } else {
                this.strategy.setReferenceItemType(this.referenceObject.getQualifier().getItemType());
            }
            this.model.reload(this.referenceList.iterator());
            this.treeExpander.simpleExpand(2);
        } else {
            this.model.clearModel();
        }
    }

    void focus(Point pos) {
        int selectedRow = this.tree.getClosestRowForLocation(pos.x, pos.y);
        if (selectedRow == -1) {
            return;
        }
        TreePath path = this.tree.getPathForRow(selectedRow);
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node instanceof LeafNode) {
            ModelObject mo = (ModelObject)((LeafNode)((Object)node)).getLeafData();
            ModelQualifier qualifier = mo.getQualifier();
            if (qualifier.getItemType().equals("Process")) {
                ProcessItem process = this.getProcess(mo);
                OpenEvent oEvent = new OpenEvent(this, "open.modeler", process);
                this.fireEvent(oEvent);
                QualifierEvent jEvent = new QualifierEvent((Plugin)this, "modeler.view.select", qualifier);
                this.fireEvent(jEvent);
                this.fireEvent(jEvent);
            } else if (qualifier.getItemType().equals("Activity") || qualifier.getItemType().equals("Webservice") || qualifier.getItemType().equals("Visual") || qualifier.getItemType().equals("Actor")) {
                ActivityItem activity = this.getActivity(mo);
                OpenEvent event = new OpenEvent(this, "global.edit.edit", activity);
                this.fireEvent(event);
            } else if (qualifier.getItemType().equals("Type")) {
                DataTypeItem data = this.getDataType(mo);
                OpenEvent event = new OpenEvent(this, "plugin.itembrowser.open", data);
                this.fireEvent(event);
            } else if (qualifier.getItemType().equals("Model")) {
                OpenEvent event = new OpenEvent(this, "plugin.itembrowser.open", mo);
                this.fireEvent(event);
            }
        }
    }

    private DataTypeItem getDataType(ModelObject mo) {
        if (mo instanceof DataMember) {
            return ((DataMember)mo).getParentDataType();
        }
        if (mo instanceof DataTypeItem) {
            return (DataTypeItem)mo;
        }
        return null;
    }

    private ProcessItem getProcess(ModelObject mo) {
        if (mo instanceof NodeParam) {
            return ((NodeParam)mo).getSocket().getNode().getProcess();
        }
        if (mo instanceof NodeSocket) {
            return ((NodeSocket)mo).getNode().getProcess();
        }
        if (mo instanceof Node) {
            return ((Node)mo).getProcess();
        }
        return null;
    }

    private ActivityItem getActivity(ModelObject mo) {
        if (mo instanceof ActivityParam) {
            return ((ActivityParam)mo).getSocket().getActivity();
        }
        if (mo instanceof ActivitySocket) {
            return ((ActivitySocket)mo).getActivity();
        }
        if (mo instanceof ActivityItem) {
            return (ActivityItem)mo;
        }
        return null;
    }

    public class Event
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.finderresult";
        }

        public JaspiraEventHandlerCode present(JaspiraEvent je) {
            FinderResultPlugin.this.referenceObject = (ModelObject)je.getObject();
            FinderEngineImpl finderEngine = new FinderEngineImpl();
            FinderResultPlugin.this.referenceList = finderEngine.createReferenceList(FinderResultPlugin.this.referenceObject, null);
            FinderResultPlugin.this.updateModel();
            FinderResultPlugin.this.refreshAction.setEnabled(true);
            FinderResultPlugin.this.clearListAction.setEnabled(FinderResultPlugin.this.referenceList != null);
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode delete(JaspiraActionEvent jae) {
            FinderResultPlugin.this.model.clearModel();
            FinderResultPlugin.this.topPanel.setVisible(false);
            FinderResultPlugin.this.clearListAction.setEnabled(false);
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode refresh(JaspiraActionEvent jae) {
            FinderEngineImpl finderEngine = new FinderEngineImpl();
            FinderResultPlugin.this.referenceList = finderEngine.createReferenceList(FinderResultPlugin.this.referenceObject, null);
            FinderResultPlugin.this.updateModel();
            FinderResultPlugin.this.clearListAction.setEnabled(FinderResultPlugin.this.referenceList != null);
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode displayobject_changed_titlemode(JaspiraEvent je) {
            FinderResultPlugin.this.tree.repaint();
            return EVENT_HANDLED;
        }
    }

    public class Interaction
    extends InteractionModule {
        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public JaspiraEventHandlerCode popup(InteractionEvent ie) {
            if (!(ie.getSourcePlugin() instanceof FinderResultPlugin)) {
                return EVENT_IGNORED;
            }
            JaspiraAction group = new JaspiraAction("popup.manage", null, null, null, null, 10, "group");
            if (FinderResultPlugin.this.refreshAction != null) {
                group.addMenuChild(FinderResultPlugin.this.refreshAction);
            }
            if (FinderResultPlugin.this.clearListAction != null) {
                group.addMenuChild(FinderResultPlugin.this.clearListAction);
            }
            ie.add(group);
            return EVENT_CONSUMED;
        }

        @Override
        public JaspiraEventHandlerCode toolbar(InteractionEvent ie) {
            if (!(ie.getSourcePlugin() instanceof FinderResultPlugin)) {
                return EVENT_IGNORED;
            }
            JaspiraAction group = new JaspiraAction("popup.manage.finder", null, null, null, null, 10, "group");
            if (FinderResultPlugin.this.refreshAction != null) {
                group.addToolbarChild(FinderResultPlugin.this.refreshAction);
            }
            if (FinderResultPlugin.this.clearListAction != null) {
                group.addToolbarChild(FinderResultPlugin.this.clearListAction);
            }
            ie.add(group);
            return EVENT_CONSUMED;
        }
    }
}

