/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.infopanel;

import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.string.TextUtil;
import org.openbp.core.model.ModelObject;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;

public class InfoPanelPlugin
extends AbstractVisiblePlugin {
    private JEditorPane panel;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    @Override
    protected void initializeComponents() {
        this.panel = new JEditorPane();
        this.panel.setContentType("text/html");
        this.panel.setEditable(false);
        JLabel label = new JLabel("Dummy");
        Font font = label.getFont();
        font = font.deriveFont(10.0f);
        this.panel.setFont(font);
        JScrollPane scrollPane = new JScrollPane(this.panel);
        this.getContentPane().add(scrollPane);
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.infopanel";
        }

        public JaspiraEventHandlerCode setinfotext(JaspiraEvent je) {
            Object o = je.getObject();
            String text = null;
            if (o instanceof DisplayObject) {
                String description;
                DisplayObject dob = (DisplayObject)o;
                String typeName = null;
                if (o instanceof ModelObject && (typeName = ((ModelObject)o).getModelObjectTypeName()) != null) {
                    typeName = " (" + typeName + ")";
                }
                if ((description = dob.getDescription()) != null) {
                    description = "&nbsp;\n" + description;
                }
                text = TextUtil.convertToHTML((String[])new String[]{dob.getDisplayText(), typeName, description}, (boolean)true, (int)-1, (int)-1);
            } else if (o instanceof String) {
                text = (String)o;
            }
            if (text != null) {
                int i1 = text.indexOf(62);
                int i2 = text.lastIndexOf(60);
                if (i1 > 0 && i2 > i1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("<html>");
                    sb.append("<head>");
                    sb.append("<style type=\"text/css\">");
                    sb.append("body ");
                    sb.append("{");
                    sb.append("font-family : Arial, Helvetica, sans-serif;");
                    sb.append("font-size : 10px;");
                    sb.append("}");
                    sb.append("td");
                    sb.append("{");
                    sb.append("font-family : Arial, Helvetica, sans-serif;");
                    sb.append("font-size : 10px;");
                    sb.append("}");
                    sb.append("ul");
                    sb.append("{");
                    sb.append("margin-left : 0.4cm");
                    sb.append("}");
                    sb.append("H1 ");
                    sb.append("{");
                    sb.append("font-size : 18px;");
                    sb.append("font-style : italic;");
                    sb.append("color : #FF6E15;");
                    sb.append("}");
                    sb.append("H2 ");
                    sb.append("{");
                    sb.append("font-size : 15px;");
                    sb.append("font-style : italic;");
                    sb.append("color : #0080ff");
                    sb.append("}");
                    sb.append("H3 ");
                    sb.append("{");
                    sb.append("font-size : 15px;");
                    sb.append("font-style : italic;");
                    sb.append("color : #FF6E15;");
                    sb.append("}");
                    sb.append("</style>");
                    sb.append("</head>");
                    sb.append("<body>");
                    sb.append(text);
                    sb.append("</body>");
                    sb.append("</html>");
                    text = sb.toString();
                }
            }
            final String panelText = text;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InfoPanelPlugin.this.panel.setText(panelText);
                    InfoPanelPlugin.this.panel.setCaretPosition(0);
                }
            });
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode clearinfotext(JaspiraEvent je) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!InfoPanelPlugin.this.panel.isFocusOwner()) {
                        InfoPanelPlugin.this.panel.setText(null);
                    }
                }
            });
            return EVENT_CONSUMED;
        }
    }
}

