/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.itembrowser;

import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.plugins.itembrowser.ItemBrowserPlugin;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.OpenEventInfo;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.action.JaspiraPopupMenu;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.RequestEvent;
import org.openbp.jaspira.event.VetoableEvent;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.JaspiraPageContainer;
import org.openbp.jaspira.plugin.ExternalEventModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSaveEvent;
import org.openbp.swing.components.JMsgBox;

public class ItemBrowserModule
extends ExternalEventModule {
    private final ItemBrowserPlugin itemBrowser;

    public ItemBrowserModule(Plugin itemBrowser) {
        super(itemBrowser);
        this.itemBrowser = (ItemBrowserPlugin)itemBrowser;
    }

    @Override
    public String getName() {
        return "plugin.itembrowser";
    }

    public JaspiraEventHandlerCode standard_file_new(JaspiraActionEvent jae) {
        InteractionEvent iae = new InteractionEvent((Plugin)this.itemBrowser, "menu", null);
        this.itemBrowser.addNewItemActions(iae);
        JaspiraPopupMenu menu = iae.createPopupMenu();
        if (menu == null) {
            return EVENT_IGNORED;
        }
        JaspiraPage page = this.itemBrowser.getPage();
        JaspiraPageContainer pagecontainer = (JaspiraPageContainer)page.getParentContainer();
        JaspiraToolbar toolbar = pagecontainer.getToolbar();
        int height = toolbar.getHeight();
        menu.show(toolbar, 0, height);
        return EVENT_CONSUMED;
    }

    public JaspiraEventHandlerCode togglefunctionalgroup(JaspiraActionEvent jae) {
        this.itemBrowser.itemTree.setShowGroups(!this.itemBrowser.itemTree.isShowGroups());
        this.itemBrowser.rebuildTree();
        return EVENT_CONSUMED;
    }

    public JaspiraEventHandlerCode remove(JaspiraActionEvent jae) {
        if (!this.itemBrowser.isPluginFocused()) {
            return EVENT_IGNORED;
        }
        Item item = this.itemBrowser.getSelectedItem();
        String msg = this.itemBrowser.getPluginResourceCollection().getRequiredString(item instanceof Model ? "msg.removemodel" : "msg.removeitem");
        int response = JMsgBox.showFormat(null, (String)msg, (Object)item.getQualifier(), (int)12);
        if (response == 4) {
            VetoableEvent ve = new VetoableEvent(this.itemBrowser, "standard.file.askdelete", item.getQualifier());
            this.itemBrowser.fireEvent(ve);
            if (!ve.isVetoed()) {
                this.itemBrowser.performAlternativeSelection();
                ModelConnector modelConnector = ModelConnector.getInstance();
                try {
                    if (item instanceof Model) {
                        modelConnector.removeModel((Model)item);
                    } else {
                        modelConnector.removeItem(item);
                    }
                }
                catch (ModelException ex) {
                    modelConnector.showExceptionDialog(ex, (ModelObject)item);
                }
            }
        }
        return EVENT_CONSUMED;
    }

    public JaspiraEventHandlerCode run(JaspiraActionEvent jae) {
        Item item = this.itemBrowser.getSelectedItem();
        if (item instanceof ProcessItem || item instanceof Model) {
            this.itemBrowser.fireEvent(new JaspiraEvent(this.itemBrowser, "debugger.client.run", item));
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode publish(JaspiraActionEvent jae) {
        Model model = this.itemBrowser.getSelectedModel(0);
        if (model == null) {
            return EVENT_IGNORED;
        }
        this.itemBrowser.fireEvent("plugin.publisher.publish", model);
        return EVENT_CONSUMED;
    }

    public JaspiraEventHandlerCode displayobject_changed_titlemode(JaspiraEvent event) {
        this.itemBrowser.itemTree.repaint();
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
        Object o = je.getObject();
        if (o instanceof Modeler) {
            ProcessItem currentProcess = ((Modeler)o).getProcess();
            this.itemBrowser.currentProcessQualifier = currentProcess.getQualifier();
            return EVENT_HANDLED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode modeler_view_closed(JaspiraEvent je) {
        Object o = je.getObject();
        if (o instanceof Modeler) {
            this.itemBrowser.currentProcessQualifier = null;
            return EVENT_HANDLED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode plugin_association_supports(RequestEvent event) {
        String mimeType = (String)event.getObject();
        if ("application/x-openbp-item".equals(mimeType)) {
            event.addResult(new OpenEventInfo("plugin.itembrowser.open", mimeType, this.itemBrowser.getTitle()));
            return EVENT_HANDLED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode open(OpenEvent openEvent) {
        Object object = openEvent.getObject();
        if (!(object instanceof Item) && !(object instanceof Item)) {
            return EVENT_IGNORED;
        }
        this.itemBrowser.setSelectedObject(object);
        this.itemBrowser.focusPlugin();
        return EVENT_CONSUMED;
    }

    public JaspiraEventHandlerCode plugin_propertybrowser_executesave(PropertyBrowserSaveEvent oee) {
        if (!(oee.original instanceof Item)) {
            return EVENT_IGNORED;
        }
        Item originalItem = (Item)oee.original;
        Item modifiedItem = (Item)oee.getObject();
        AskEvent ae = new AskEvent(this.itemBrowser, "global.edit.geteditedinstance", originalItem);
        this.itemBrowser.fireEvent(ae);
        Item editedItem = (Item)ae.getAnswer();
        if (editedItem != null) {
            return EVENT_IGNORED;
        }
        oee.saved = this.updateItem(originalItem, modifiedItem);
        return EVENT_CONSUMED;
    }

    private boolean updateItem(Item originalItem, Item modifiedItem) {
        ModelConnector modelConnector = ModelConnector.getInstance();
        try {
            if (originalItem instanceof Model) {
                modelConnector.updateModel((Model)modifiedItem);
            } else {
                String newName = modifiedItem.getName();
                ModelQualifier destinationQualifier = new ModelQualifier(originalItem.getQualifier());
                destinationQualifier.setItem(newName);
                modelConnector.moveItem(modifiedItem, destinationQualifier);
                modelConnector.updateItem(modifiedItem);
            }
        }
        catch (ModelException e) {
            modelConnector.showExceptionDialog(e, (ModelObject)originalItem);
            return false;
        }
        return true;
    }
}

