/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.toolbox;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.openbp.cockpit.plugins.toolbox.StandardToolBoxPlugin;
import org.openbp.cockpit.plugins.toolbox.ToolBoxPlugin;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.icon.MultiImageIcon;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraPopupMenu;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.gui.interaction.BreakoutBoxEntry;
import org.openbp.jaspira.gui.interaction.DragInitiator;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.jaspira.gui.interaction.Importer;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class ToolBoxItem
extends JPanel
implements DragOrigin,
BreakoutBoxEntry {
    private Transferable transferable;
    private String title;
    private Icon icon;
    private String iconModelKey;
    private Importer importer;
    private Rectangle rect;
    private ToolBoxPlugin toolbox;
    private static final Dimension FIXEDSIZE = new Dimension(40, 40);
    private static Color transred = new Color(0.0f, 0.0f, 1.0f, 0.2f);

    public ToolBoxItem(String title, String iconModelKey, String description, Transferable transferable) {
        this(title, ItemIconMgr.getInstance().getIcon(null, iconModelKey, 0), description, transferable);
        this.iconModelKey = iconModelKey;
    }

    public ToolBoxItem(String title, Icon icon, String description, Transferable transferable) {
        this.title = title;
        this.icon = icon;
        this.transferable = transferable;
        this.setLayout(new BorderLayout());
        this.setBorder((Border)SimpleBorder.getStandardBorder());
        this.setMinimumSize(FIXEDSIZE);
        this.setMaximumSize(FIXEDSIZE);
        this.setPreferredSize(FIXEDSIZE);
        DragInitiator.makeDraggable(this, this);
        this.addMouseListener(new TBMouseListener());
        this.initComponent();
        StringBuffer output = new StringBuffer("<html>");
        if (title != null) {
            output.append("<b>");
            output.append(title);
            output.append("</b>");
        }
        if (description != null) {
            if (title != null) {
                output.append("<br><hr>");
            }
            StringTokenizer tok = new StringTokenizer(description, "\n");
            while (tok.hasMoreTokens()) {
                output.append(tok.nextToken());
                if (!tok.hasMoreElements()) continue;
                output.append("<br>");
            }
        }
        output.append("</html>");
        this.setToolTipText(output.toString());
    }

    @Override
    public String toString() {
        return super.toString() + " (title = " + this.title + ")";
    }

    public void initComponent() {
        this.removeAll();
        if (this.icon instanceof MultiIcon) {
            ((MultiIcon)this.icon).setIconSize(24);
        }
        this.add(new JLabel(this.icon));
        JLabel label = new JLabel(this.title, 0);
        Font font = label.getFont();
        font = font.deriveFont(9.0f);
        label.setFont(font);
        this.add((Component)label, "South");
    }

    public void updateModelIcon(String skinName) {
        if (this.iconModelKey != null) {
            this.icon = ItemIconMgr.getInstance().getIcon(skinName, this.iconModelKey, 0);
            this.initComponent();
        }
    }

    @Override
    public Transferable getTransferable() {
        return this.transferable;
    }

    public ToolBoxPlugin getToolbox() {
        return this.toolbox;
    }

    public void setToolbox(ToolBoxPlugin toolbox) {
        this.toolbox = toolbox;
    }

    public String getIconModelKey() {
        return this.iconModelKey;
    }

    public void setIconModelKey(String iconModelKey) {
        this.iconModelKey = iconModelKey;
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public void dropAccepted(Transferable t) {
    }

    @Override
    public void dropCanceled(Transferable t) {
    }

    @Override
    public void dropPerformed(Transferable t) {
    }

    @Override
    public Transferable getTranferableAt(Point p) {
        return this.getTransferable();
    }

    @Override
    public MultiIcon getDragImage() {
        return this.getIcon();
    }

    @Override
    public void draw(Graphics g) {
        g.setColor(transred);
        g.fillOval(this.rect.x - 5, this.rect.y - 5, this.rect.width + 10, this.rect.height + 10);
        Icon icon = this.getIcon().getIcon(24);
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        icon.paintIcon(null, g, this.rect.x + (this.rect.width - iconWidth) / 2, this.rect.y + (this.rect.height - iconHeight) / 2);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public MultiIcon getIcon() {
        if (this.icon instanceof MultiIcon) {
            return (MultiIcon)this.icon;
        }
        if (this.icon instanceof ImageIcon) {
            return new MultiImageIcon((ImageIcon)this.icon);
        }
        return null;
    }

    @Override
    public Importer getImporter() {
        return this.importer;
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean importData(Point dropPoint) {
        if (this.importer != null) {
            return this.importer.importData(this.getTransferable(), dropPoint);
        }
        return false;
    }

    @Override
    public boolean reactsOn(int x, int y) {
        return this.rect.contains(x, y);
    }

    @Override
    public void setLocationOnGlassPanel(Rectangle r) {
        this.rect = r;
    }

    @Override
    public Rectangle getLocationOnGlassPanel() {
        return this.rect;
    }

    public class TBMouseListener
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && !(ToolBoxItem.this.toolbox instanceof StandardToolBoxPlugin)) {
                InteractionEvent iae = new InteractionEvent((Plugin)ToolBoxItem.this.toolbox, "popup", ToolBoxItem.this.transferable);
                ToolBoxItem.this.toolbox.fireEvent(iae);
                JaspiraPopupMenu menu = iae.createPopupMenu();
                if (ToolBoxItem.this.toolbox.acceptDrop()) {
                    if (menu == null) {
                        menu = new JaspiraPopupMenu(ToolBoxItem.this.title);
                    } else {
                        menu.addSeparator();
                    }
                    menu.add(new JaspiraAction(ToolBoxItem.this.toolbox, "toolbox.remove"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ToolBoxItem.this.toolbox.removeToolBoxItem(ToolBoxItem.this);
                            ToolBoxItem.this.toolbox.refreshContent();
                        }
                    });
                }
                menu.show(ToolBoxItem.this, e.getPoint().x, e.getPoint().y);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JaspiraEventMgr.fireGlobalEvent("plugin.association.open", ToolBoxItem.this.transferable);
            }
        }
    }
}

