/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.variables;

import java.util.ArrayList;
import java.util.Iterator;
import org.openbp.cockpit.plugins.variables.VariablesContainer;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.guiclient.objectvalidators.DisplayObjectValidator;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;

public class VariablesContainerValidator
extends DisplayObjectValidator {
    @Override
    public boolean validateObject(Object editedObject, PropertyBrowser pb) {
        if (!(editedObject instanceof VariablesContainer)) {
            return true;
        }
        VariablesContainer container = (VariablesContainer)((Object)editedObject);
        Iterator it = container.getProcessVariables();
        while (it.hasNext()) {
            ProcessVariable param = (ProcessVariable)it.next();
            param.maintainReferences(40);
        }
        this.checkNameUniqueness(container);
        if (!this.displayMsgContainer()) {
            return false;
        }
        return super.validateObject(editedObject, pb);
    }

    protected void checkNameUniqueness(VariablesContainer container) {
        ArrayList<String> invalidNames = new ArrayList<String>();
        Iterator it = container.getProcessVariables();
        while (it.hasNext()) {
            ProcessVariable param = (ProcessVariable)it.next();
            String name = param.getName();
            if (name == null || invalidNames.contains(name) || this.countNamedParams(container, name) <= 1) continue;
            invalidNames.add(name);
            param.getModelMgr().getMsgContainer().addMsg((Object)param, "An element with this name already exists.");
        }
    }

    private int countNamedParams(VariablesContainer container, String name) {
        int count = 0;
        Iterator it = container.getProcessVariables();
        while (it.hasNext()) {
            ProcessVariable param = (ProcessVariable)it.next();
            if (!name.equals(param.getName())) continue;
            ++count;
        }
        return count;
    }
}

