/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.template.standard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openbp.cockpit.template.standard.CodeGeneratorException;
import org.openbp.cockpit.template.standard.JavaSrcTemplate;
import org.openbp.common.generic.PrintNameProvider;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.string.StringUtil;
import org.openbp.common.template.writer.JavaTemplateWriter;
import org.openbp.common.template.writer.Placeholder;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelLocationUtil;
import org.openbp.core.model.item.process.ActivityNode;
import org.openbp.core.model.item.process.ControlLink;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.DecisionNode;
import org.openbp.core.model.item.process.FinalNode;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.Param;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.core.model.item.process.SubprocessNode;
import org.openbp.core.model.item.process.VisualNode;
import org.openbp.core.model.item.process.WebServiceNode;
import org.openbp.core.model.item.type.DataTypeItem;

public class ProcessSrcJavaTemplate
extends JavaSrcTemplate {
    protected ProcessItem process;
    protected JavaTemplateWriter w;
    protected InitialNode currentInitialNode;
    protected Map executionPathNodes = new HashMap();
    protected Map allNodes = new HashMap();

    public void generate(Object[] templateArgs) throws Exception {
        this.process = (ProcessItem)this.getProperty("item");
        String className = this.determineClassName();
        String dirName = ModelLocationUtil.expandModelLocation((Model)this.process.getModel(), (String)"src");
        if (dirName == null) {
            throw new RuntimeException("Empty 'src' directory specified in tagged values of model, unable to generate code.");
        }
        this.w = new JavaTemplateWriter(dirName, className);
        this.printFile();
        this.w.close();
        this.addResultFileInfo(this.w.getFileName(), "text/x-java");
    }

    protected String determineClassName() {
        return this.process.getName();
    }

    protected void printFile() throws Exception {
        this.printFileHeader(this.w);
        String comment = this.createComment((DisplayObject)this.process);
        this.w.printComment(comment, 2);
        this.printClassCode();
    }

    protected void printClassCode() throws Exception {
        this.w.println((Object)("public class " + this.w.getClassName() + ""));
        this.w.addIndent(1);
        this.w.println((Object)"// {{*Custom extends*");
        this.w.println((Object)"// }}*Custom extends*");
        this.w.println((Object)"// {{*Custom interfaces*");
        this.w.println((Object)"// }}*Custom interfaces*");
        this.w.addIndent(-1);
        this.w.println((Object)"{");
        this.printProcessVariables();
        this.w.println((Object)"// {{*Custom members*");
        this.w.println((Object)"// }}*Custom members*");
        this.w.println();
        this.w.println((Object)"/**");
        this.w.println((Object)"* Default constructor.");
        this.w.println((Object)"*/");
        this.w.println((Object)("public " + this.w.getClassName() + " ()"));
        this.w.println((Object)"{");
        this.w.println((Object)"// {{*Custom default constructor code*");
        this.w.println((Object)"// }}*Custom default constructor code*");
        this.w.println((Object)"}");
        this.w.println();
        this.w.println((Object)"// {{*Custom constructor*");
        this.w.println((Object)"// }}*Custom constructor*");
        this.w.println();
        this.printMethods();
        this.w.println((Object)"// {{*Custom methods*");
        this.w.println((Object)"// }}*Custom methods*");
        this.w.println((Object)"}");
    }

    protected void printProcessVariables() throws Exception {
        Iterator it = this.process.getProcessVariables();
        while (it.hasNext()) {
            ProcessVariable param = (ProcessVariable)it.next();
            this.printGlobal(param);
        }
    }

    protected void printGlobal(ProcessVariable param) throws Exception {
        String comment = this.createComment((DisplayObject)param);
        this.w.printComment(comment, 1);
        DataTypeItem dataType = param.getDataType();
        String type = this.determineJavaType(this.w, dataType);
        String modifier = "private";
        switch (param.getScope()) {
            case 1: {
                modifier = "protected";
                break;
            }
            case 2: {
                modifier = "public";
            }
        }
        this.w.println((Object)(modifier + " " + type + " " + this.makeVariableName((DescriptionObject)param) + ";"));
        this.w.println();
    }

    protected void addDataLinkVariable(DataLink link) {
        DataTypeItem targetType;
        String name = this.makeVariableName((DescriptionObject)link);
        DataTypeItem sourceType = link.getSourceParam().getDataType();
        DataTypeItem dataType = sourceType.isBaseTypeOf(targetType = link.getTargetParam().getDataType()) ? targetType : sourceType;
        String stmt = this.constructDataLinkVariableDeclaration(name, dataType);
        Placeholder placeholder = this.w.getPlaceholder(this.currentInitialNode.getName() + "Locals");
        if (!placeholder.contains(name)) {
            placeholder.add(name, stmt);
        }
    }

    protected String constructDataLinkVariableDeclaration(String name, DataTypeItem dataType) {
        String type = this.determineJavaType(this.w, dataType);
        return type + " " + name + ";";
    }

    protected void printMethods() throws Exception {
        Iterator itNodes = this.process.getNodes();
        while (itNodes.hasNext()) {
            Node node = (Node)itNodes.next();
            if (!(node instanceof InitialNode)) continue;
            this.printMethod((InitialNode)node);
        }
    }

    protected void printMethod(InitialNode initialNode) throws Exception {
        this.currentInitialNode = initialNode;
        FinalNode finalNode = initialNode.getWSCorrespondingFinalNode();
        String comment = this.createComment((DisplayObject)initialNode);
        this.w.printComment(comment, 2);
        this.printMethodHeader(initialNode, finalNode);
        try {
            this.printMethodBody(initialNode, finalNode);
        }
        catch (CodeGeneratorException e) {
            // empty catch block
        }
        this.printMethodFooter(initialNode, finalNode);
        this.w.println();
    }

    protected void printMethodHeader(InitialNode initialNode, FinalNode finalNode) throws Exception {
        DataTypeItem dataType;
        NodeParam param;
        Iterator it;
        boolean firstParam;
        String modifier = "public";
        switch (initialNode.getEntryScope()) {
            case 1: {
                break;
            }
            case 2: {
                modifier = "protected";
                break;
            }
            case 3: {
                modifier = "private";
            }
        }
        String returnType = "void";
        if (finalNode != null) {
            firstParam = true;
            it = finalNode.getSocket().getParams();
            while (it.hasNext()) {
                if (!firstParam) {
                    this.errMsg("Warning: Final node '" + finalNode.getQualifier() + "' contains more than one return parameter.");
                    break;
                }
                param = (NodeParam)it.next();
                dataType = param.getDataType();
                returnType = this.determineJavaType(this.w, dataType);
                firstParam = false;
            }
        }
        this.w.print((Object)(modifier + " " + returnType + " " + this.makeVariableName((DescriptionObject)initialNode) + "("));
        firstParam = true;
        it = initialNode.getSocket().getParams();
        while (it.hasNext()) {
            param = (NodeParam)it.next();
            dataType = param.getDataType();
            String type = this.determineJavaType(this.w, dataType);
            if (firstParam) {
                firstParam = false;
            } else {
                this.w.print((Object)", ");
            }
            this.w.print((Object)(type + " " + this.makeVariableName((DescriptionObject)param)));
        }
        this.w.println((Object)")");
        this.w.println((Object)"{");
    }

    protected void printMethodBody(InitialNode initialNode, FinalNode finalNode) throws Exception {
        this.executionPathNodes.clear();
        String placeholderName = initialNode.getName() + "Locals";
        this.w.definePlaceholder(placeholderName, 1);
        this.w.println((Object)("@[" + placeholderName + "]@"));
        this.w.println();
        this.printExecution(initialNode.getSocket(), null);
    }

    protected void printMethodFooter(InitialNode initialNode, FinalNode finalNode) throws Exception {
        this.w.println((Object)"}");
    }

    protected void printExecution(NodeSocket startSocket, Node stopNode) throws Exception {
        Node node;
        boolean start = true;
        NodeSocket socket = startSocket;
        while (socket != null && (node = socket.getNode()) != stopNode) {
            if (!start) {
                this.w.println();
            }
            start = false;
            NodeSocket entrySocket = null;
            NodeSocket exitSocket = null;
            if (socket.isEntrySocket()) {
                entrySocket = socket;
                exitSocket = node.getDefaultExitSocket();
            } else {
                exitSocket = socket;
            }
            String comment = node.getDisplayText();
            if (comment != null) {
                this.w.printComment(comment, 0);
            }
            if (node instanceof DecisionNode) {
                DecisionNode decisionNode = (DecisionNode)node;
                NodeSocket yesSocket = this.getNamedSocket(node, "Yes");
                yesSocket = ((ControlLink)yesSocket.getControlLinks().next()).getTargetSocket();
                NodeSocket noSocket = this.getNamedSocket(node, "No");
                noSocket = ((ControlLink)noSocket.getControlLinks().next()).getTargetSocket();
                Node joinNode = this.skipDecisionNodeBranches(decisionNode);
                this.printDecisionNodeCondition(decisionNode, entrySocket);
                this.printDecisionNodeThen(decisionNode, yesSocket, joinNode);
                this.printDecisionNodeElse(decisionNode, noSocket, joinNode);
                if (joinNode == null) break;
                socket = joinNode.getDefaultEntrySocket();
                continue;
            }
            if (node instanceof VisualNode) {
                this.errMsg("Error: Visual node '" + node.getQualifier() + "' cannot be mapped to a code-based representation.");
                throw new CodeGeneratorException();
            }
            if (node instanceof WebServiceNode) {
                this.errMsg("Error: Web service node '" + node.getQualifier() + "' cannot be mapped to a code-based representation.");
                throw new CodeGeneratorException();
            }
            if (!(node instanceof SubprocessNode)) {
                if (node instanceof ActivityNode) {
                    this.printActivityNode((ActivityNode)node, entrySocket, exitSocket);
                } else if (node instanceof InitialNode) {
                    this.printInitialNode((InitialNode)node, exitSocket);
                } else {
                    if (node instanceof FinalNode) {
                        this.printFinalNode((FinalNode)node, entrySocket);
                        break;
                    }
                    this.errMsg("Error: Unkown node '" + node.getQualifier() + "' cannot be mapped to a code-based representation.");
                    throw new CodeGeneratorException();
                }
            }
            if (exitSocket == null || !exitSocket.hasControlLinks()) {
                this.errMsg("Error: Node '" + node.getQualifier() + "' has no default exit socket or no control links attached to the socket.");
                throw new CodeGeneratorException();
            }
            ControlLink cl = (ControlLink)exitSocket.getControlLinks().next();
            socket = cl.getTargetSocket();
        }
    }

    protected void printInitialNode(InitialNode node, NodeSocket exitSocket) throws Exception {
        Iterator itParam = exitSocket.getParams();
        while (itParam.hasNext()) {
            NodeParam param = (NodeParam)itParam.next();
            Iterator itLink = param.getDataLinks();
            while (itLink.hasNext()) {
                String targetName;
                DataLink link = (DataLink)itLink.next();
                String sourceName = this.makeVariableName((DescriptionObject)param);
                Param targetParam = link.getTargetParam();
                if (targetParam instanceof ProcessVariable) {
                    targetName = this.makeVariableName((DescriptionObject)targetParam);
                } else {
                    this.addDataLinkVariable(link);
                    targetName = this.makeVariableName((DescriptionObject)link);
                }
                this.printAsssignment(targetName, sourceName);
            }
        }
    }

    protected void printFinalNode(FinalNode node, NodeSocket entrySocket) throws Exception {
        boolean first = true;
        Iterator itParam = entrySocket.getParams();
        while (itParam.hasNext()) {
            NodeParam param = (NodeParam)itParam.next();
            String expr = this.obtainExpression(param.getExpression(), "Java", (PrintNameProvider)param);
            if (expr == null) {
                expr = param.getName();
            }
            if (!first) {
                this.errMsg("Warning: Final node '" + entrySocket.getNode().getQualifier() + "' may not have more than one return parameter.");
                break;
            }
            first = false;
            String stmt = "return " + expr + ";";
            stmt = this.expandParametrizedExpression(stmt, entrySocket);
            this.w.println((Object)stmt);
        }
    }

    protected void printAsssignment(String targetName, String sourceName) throws Exception {
        this.w.println((Object)(targetName + " = " + sourceName + ";"));
    }

    protected void printActivityNode(ActivityNode node, NodeSocket entrySocket, NodeSocket exitSocket) throws Exception {
        String script = this.obtainExpression(node.getActivityHandlerDefinition().getScript(), "Java", (PrintNameProvider)node);
        if (script != null) {
            script = this.expandParametrizedExpression(script, entrySocket, exitSocket);
            this.w.println((Object)(script + ";"));
        } else {
            this.errMsg("Error: No script associated with activity node '" + node.getQualifier() + "'.");
        }
    }

    protected void printDecisionNodeCondition(DecisionNode node, NodeSocket entrySocket) throws Exception {
        String expression = this.obtainExpression(node.getExpression(), "Java", (PrintNameProvider)node);
        if (expression == null) {
            this.errMsg("Error: No Java expression defined for decision node '" + node.getQualifier() + "'.");
            throw new CodeGeneratorException();
        }
        expression = this.expandParametrizedExpression(expression, entrySocket, null);
        this.w.println((Object)("if (" + expression + ")"));
    }

    protected void printDecisionNodeThen(DecisionNode node, NodeSocket yesSocket, Node joinNode) throws Exception {
        this.w.println((Object)"{");
        this.printExecution(yesSocket, joinNode);
        this.w.println((Object)"}");
    }

    protected void printDecisionNodeElse(DecisionNode node, NodeSocket noSocket, Node joinNode) throws Exception {
        if (noSocket.getNode() != joinNode) {
            this.w.println((Object)"else");
            this.w.println((Object)"{");
            this.printExecution(noSocket, joinNode);
            this.w.println((Object)"}");
        }
    }

    protected Node skipDecisionNodeBranches(DecisionNode decisionNode) throws CodeGeneratorException {
        NodeSocket yesSocket = this.getNamedSocket((Node)decisionNode, "Yes");
        yesSocket = ((ControlLink)yesSocket.getControlLinks().next()).getTargetSocket();
        NodeSocket noSocket = this.getNamedSocket((Node)decisionNode, "No");
        noSocket = ((ControlLink)noSocket.getControlLinks().next()).getTargetSocket();
        return this.findJoiningNode(decisionNode, yesSocket, noSocket);
    }

    protected Node findJoiningNode(DecisionNode decisionNode, NodeSocket yesSocket, NodeSocket noSocket) throws CodeGeneratorException {
        NodeSocket socket = yesSocket;
        while (socket != null) {
            Node node = socket.getNode();
            if (this.containsPathNode(node, noSocket)) {
                return node;
            }
            if (node instanceof DecisionNode) {
                Node joinNode = this.skipDecisionNodeBranches((DecisionNode)node);
                if (joinNode == null) {
                    return null;
                }
                socket = joinNode.getDefaultEntrySocket();
                continue;
            }
            if (node instanceof FinalNode) {
                return null;
            }
            socket = node.getDefaultExitSocket();
            if (socket == null || !socket.hasControlLinks()) {
                this.errMsg("Error: Node '" + node.getQualifier() + "' has no default exit socket or no control links attached to the socket.");
                throw new CodeGeneratorException();
            }
            ControlLink cl = (ControlLink)socket.getControlLinks().next();
            socket = cl.getTargetSocket();
        }
        return null;
    }

    protected boolean containsPathNode(Node nodeToSearch, NodeSocket socket) throws CodeGeneratorException {
        while (socket != null) {
            Node node = socket.getNode();
            if (node == nodeToSearch) {
                return true;
            }
            if (node instanceof DecisionNode) {
                Node joinNode = this.skipDecisionNodeBranches((DecisionNode)node);
                if (joinNode == null) break;
                socket = joinNode.getDefaultEntrySocket();
                continue;
            }
            if (node instanceof FinalNode) break;
            socket = node.getDefaultExitSocket();
            if (socket == null || !socket.hasControlLinks()) {
                this.errMsg("Error: Node '" + node.getQualifier() + "' has no default exit socket or no control links attached to the socket.");
                throw new CodeGeneratorException();
            }
            ControlLink cl = (ControlLink)socket.getControlLinks().next();
            socket = cl.getTargetSocket();
        }
        return false;
    }

    protected String expandParametrizedExpression(String expression, NodeSocket entrySocket, NodeSocket exitSocket) throws CodeGeneratorException {
        expression = this.expandParametrizedExpression(expression, entrySocket);
        expression = this.expandParametrizedExpression(expression, exitSocket);
        return expression;
    }

    protected String expandParametrizedExpression(String expression, NodeSocket socket) throws CodeGeneratorException {
        if (socket != null) {
            Iterator it = socket.getParams();
            while (it.hasNext()) {
                NodeParam param = (NodeParam)it.next();
                String name = param.getName();
                if (expression.indexOf(name) < 0) continue;
                String value = this.getParamValue(socket, name);
                expression = StringUtil.substitute((String)expression, (String)name, (String)value);
            }
        }
        return expression;
    }

    protected String getParamValue(NodeSocket socket, String paramName) throws CodeGeneratorException {
        Param sourceParam;
        NodeParam param = socket.getParamByName(paramName);
        if (param == null) {
            this.errMsg("Error: Parameter '" + paramName + "' does not exist in socket '" + socket.getQualifier() + "'.");
            throw new CodeGeneratorException();
        }
        Iterator it = param.getDataLinks();
        if (!it.hasNext()) {
            if (param.getExpression() != null) {
                return param.getExpression();
            }
            this.errMsg("Error: Parameter '" + param.getQualifier() + "' not connected to a data link and not associated with an expression.");
            throw new CodeGeneratorException();
        }
        DataLink link = (DataLink)it.next();
        if (it.hasNext()) {
            this.errMsg("Warning: Only a single data link allowed to parameter '" + param.getQualifier() + "'.");
        }
        if ((sourceParam = link.getSourceParam()) instanceof ProcessVariable) {
            return this.makeVariableName((DescriptionObject)sourceParam);
        }
        this.addDataLinkVariable(link);
        return this.makeVariableName((DescriptionObject)link);
    }

    protected NodeSocket getNamedSocket(Node node, String name) throws CodeGeneratorException {
        Iterator itSockets = node.getSockets();
        while (itSockets.hasNext()) {
            NodeSocket socket = (NodeSocket)itSockets.next();
            if (!socket.getName().equals(name)) continue;
            if (!socket.hasControlLinks()) {
                this.errMsg("Error: Socket '" + name + "' of node '" + node.getQualifier() + "' not connected.");
                throw new CodeGeneratorException();
            }
            return socket;
        }
        this.errMsg("Error: Socket '" + name + "' of node '" + node.getQualifier() + "' not present.");
        throw new CodeGeneratorException();
    }

    protected String obtainExpression(String expression, String desiredLanguage, PrintNameProvider owner) throws CodeGeneratorException {
        if (expression == null || !expression.startsWith("$$")) {
            return expression;
        }
        while (expression != null && expression.startsWith("$$")) {
            String value;
            int endIndex = expression.indexOf("$$", 2);
            if (endIndex < 0) {
                this.errMsg("$$ separator missing in expression or script of element '" + owner.getPrintName() + "'.");
                throw new CodeGeneratorException();
            }
            String language = expression.substring(2, endIndex);
            language = language.trim();
            int endIndex2 = expression.indexOf("$$", endIndex + 2);
            if (endIndex2 < 0) {
                value = expression.substring(endIndex + 2);
                expression = null;
            } else {
                value = expression.substring(endIndex + 2, endIndex2);
                expression = expression.substring(endIndex2);
            }
            value = value.trim();
            if (!language.equals(desiredLanguage)) continue;
            return value;
        }
        this.errMsg("Language '" + desiredLanguage + "' not found in expression or script of element '" + owner.getPrintName() + "'.");
        throw new CodeGeneratorException();
    }

    protected String makeVariableName(DescriptionObject o) {
        return StringUtil.decapitalize((String)o.getName());
    }
}

