/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model;

import java.io.Serializable;
import org.openbp.common.util.observer.ObserverEvent;
import org.openbp.core.model.ModelQualifier;

public class ModelConnectorEvent
implements ObserverEvent,
Serializable {
    public static final String MODELS_LOADED = "ModelLoaded";
    public static final String MODEL_BATCH = "ModelBatch";
    public static final String MODEL_ADDED = "ModelAdded";
    public static final String MODEL_UPDATED = "ModelUpdated";
    public static final String MODEL_REMOVED = "ModelRemoved";
    public static final String MODEL_RENAMED = "ModelRenamed";
    public static final String ITEM_BATCH = "ItemBatch";
    public static final String ITEM_ADDED = "ItemAdded";
    public static final String ITEM_UPDATED = "ItemUpdated";
    public static final String ITEM_REMOVED = "ItemRemoved";
    public static final String ITEM_RENAMED = "ItemRenamed";
    public static final String[] SUPPORTED_EVENT_TYPES = new String[]{"ModelLoaded", "ModelBatch", "ModelAdded", "ModelUpdated", "ModelRemoved", "ModelRenamed", "ItemBatch", "ItemAdded", "ItemUpdated", "ItemRemoved", "ItemRenamed"};
    protected String eventType;
    private ModelQualifier qualifier;
    private ModelQualifier previousQualifier;

    public static final String[] getSupportedEventTypes() {
        return SUPPORTED_EVENT_TYPES;
    }

    public ModelConnectorEvent() {
    }

    public ModelConnectorEvent(String eventType) {
        this.eventType = eventType;
    }

    public ModelConnectorEvent(String eventType, ModelQualifier qualifier) {
        this.eventType = eventType;
        this.qualifier = qualifier;
    }

    public ModelConnectorEvent(String eventType, ModelQualifier qualifier, ModelQualifier previousQualifier) {
        this.eventType = eventType;
        this.qualifier = qualifier;
        this.previousQualifier = previousQualifier;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ModelConnector: Event = " + this.eventType + "\r\n");
        sb.append("\tQualifier = " + this.qualifier);
        if (this.previousQualifier != null) {
            sb.append("\tPrevious model qualifier = " + this.previousQualifier);
        }
        return sb.toString();
    }

    public String getEventType() {
        return this.eventType;
    }

    public boolean shallSkipSubsequentObservers() {
        return false;
    }

    public ModelQualifier getQualifier() {
        return this.qualifier;
    }

    public ModelQualifier getPreviousQualifier() {
        return this.previousQualifier;
    }
}

