/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item;

import java.util.ArrayList;
import java.util.Iterator;
import org.openbp.common.CollectionUtil;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptorMgr;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.ItemTypeDescriptor;

public class ItemUtil {
    private ItemUtil() {
    }

    public static void ensureUniqueItemName(Item item, Model model) {
        String name = item.getName();
        String itemType = item.getItemType();
        Iterator modelItemIterator = model.getItems(itemType);
        ArrayList allItems = new ArrayList();
        CollectionUtil.addAll(allItems, (Iterator)modelItemIterator);
        String newName = NamedObjectCollectionUtil.createUniqueId(allItems, (String)name);
        item.setName(newName);
        if (!newName.equals(name)) {
            String appendix = newName.substring(name.length());
            String displayName = item.getDisplayName();
            if (displayName == null) {
                displayName = name;
            }
            displayName = displayName + " (" + appendix + ")";
            item.setDisplayName(displayName);
        }
    }

    public static ObjectDescriptor obtainObjectDescriptor(ItemTypeDescriptor itd) {
        if (itd != null) {
            try {
                return ObjectDescriptorMgr.getInstance().getDescriptor(itd.getItemInterface(), 0);
            }
            catch (XMLDriverException xMLDriverException) {
                // empty catch block
            }
        }
        return null;
    }
}

