/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemfinder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.activity.ActivityParam;
import org.openbp.core.model.item.activity.ActivitySocket;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.SingleSocketNode;
import org.openbp.core.model.item.type.ComplexTypeItem;
import org.openbp.core.model.item.type.DataMember;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.model.item.itemfinder.FinderImpl;

public class DataTypeFinder
extends FinderImpl {
    @Override
    public List findModelObjectInModel(ModelObject mo, Model model) {
        DataTypeItem item = (DataTypeItem)mo;
        ArrayList foundModelObjects = new ArrayList();
        Iterator processes = model.getItems("Process");
        while (processes.hasNext()) {
            ProcessItem process = (ProcessItem)processes.next();
            Iterator nodes = process.getNodes();
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                List modelObjects = this.findInNode(node, item);
                if (modelObjects.size() == 0) continue;
                foundModelObjects.addAll(modelObjects);
            }
        }
        Iterator activityItems = model.getItems("Activity");
        while (activityItems.hasNext()) {
            ActivityItem activity = (ActivityItem)activityItems.next();
            Iterator sockets = activity.getSockets();
            while (sockets.hasNext()) {
                ActivitySocket activitySocket = (ActivitySocket)sockets.next();
                foundModelObjects.addAll(this.findInActivitySocket(activitySocket, item));
            }
        }
        Iterator dataTypes = model.getItems("Type");
        while (dataTypes.hasNext()) {
            DataTypeItem dt = (DataTypeItem)dataTypes.next();
            if (!(dt instanceof ComplexTypeItem)) continue;
            foundModelObjects.addAll(this.findInComplexDataType((ComplexTypeItem)dt, item));
        }
        return foundModelObjects;
    }

    private List findInComplexDataType(ComplexTypeItem complex, DataTypeItem item) {
        ArrayList modelObjects = new ArrayList();
        if (complex == item) {
            return modelObjects;
        }
        DataTypeItem dti = complex.getBaseType();
        this.addIfMatch((ModelObject)complex, (ModelObject)dti, (ModelObject)item, modelObjects);
        Iterator member = complex.getAllMembers();
        while (member.hasNext()) {
            DataMember dm = (DataMember)member.next();
            DataTypeItem memberItem = dm.getDataType();
            this.addIfMatch((ModelObject)dm, (ModelObject)memberItem, (ModelObject)item, modelObjects);
        }
        return modelObjects;
    }

    private List findInNode(Node node, DataTypeItem item) {
        List socketList = new ArrayList<NodeSocket>();
        if (node instanceof MultiSocketNode) {
            socketList = ((MultiSocketNode)node).getSocketList();
        } else {
            socketList.add(((SingleSocketNode)node).getSocket());
        }
        ArrayList modelObjects = new ArrayList();
        for (int i = 0; i < socketList.size(); ++i) {
            NodeSocket socket = (NodeSocket)socketList.get(i);
            modelObjects.addAll(this.findInNodeSocket(socket, item));
        }
        return modelObjects;
    }

    private List findInNodeSocket(NodeSocket socket, DataTypeItem item) {
        ArrayList foundObject = new ArrayList();
        Iterator parameter = socket.getParams();
        while (parameter.hasNext()) {
            NodeParam param = (NodeParam)parameter.next();
            DataTypeItem dataType = param.getDataType();
            this.addIfMatch((ModelObject)param, (ModelObject)dataType, (ModelObject)item, foundObject);
        }
        return foundObject;
    }

    private List findInActivitySocket(ActivitySocket socket, DataTypeItem item) {
        ArrayList foundObject = new ArrayList();
        Iterator parameter = socket.getParams();
        while (parameter.hasNext()) {
            ActivityParam param = (ActivityParam)parameter.next();
            DataTypeItem dataType = param.getDataType();
            this.addIfMatch((ModelObject)param, (ModelObject)dataType, (ModelObject)item, foundObject);
        }
        return foundObject;
    }
}

