/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemfinder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.process.FinalNode;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.SubprocessNode;
import org.openbp.guiclient.model.item.itemfinder.Finder;

public class ProcessEntryFinder
implements Finder {
    @Override
    public List findModelObjectInModel(ModelObject mo, Model model) {
        ArrayList foundReferences = new ArrayList();
        InitialNode entry = (InitialNode)mo;
        ProcessItem process = entry.getProcess();
        Iterator modelProcess = model.getItems("Process");
        while (modelProcess.hasNext()) {
            ProcessItem pi = (ProcessItem)modelProcess.next();
            foundReferences.addAll(this.findInProcess(process, entry, pi));
        }
        return foundReferences;
    }

    private List findInProcess(ProcessItem searchFor, InitialNode entry, ProcessItem scaned) {
        ArrayList<Object> foundReferences = new ArrayList<Object>();
        Iterator nodeList = scaned.getNodes();
        while (nodeList.hasNext()) {
            Node node = (Node)nodeList.next();
            if (node instanceof SubprocessNode) {
                SubprocessNode subprocessNode = (SubprocessNode)node;
                ProcessItem subprocess = subprocessNode.getSubprocess();
                if (subprocess == null || !subprocess.getQualifier().matches((Object)searchFor.getQualifier(), 31)) continue;
                NodeSocket socket = subprocessNode.getSocketByName(entry.getName());
                if (socket != null) {
                    foundReferences.add(socket);
                }
            }
            if (!scaned.getQualifier().matches((Object)searchFor.getQualifier(), 31)) continue;
            if (node instanceof FinalNode) {
                if (!entry.getName().equals(((FinalNode)node).getJumpTarget())) continue;
                foundReferences.add(node);
                continue;
            }
            if (!(node instanceof MultiSocketNode)) continue;
            MultiSocketNode socketNode = (MultiSocketNode)node;
            Iterator exitSockets = socketNode.getSockets(false);
            while (exitSockets.hasNext()) {
                NodeSocket exit = (NodeSocket)exitSockets.next();
                if (exit.hasControlLinks() || !exit.getName().equals(entry.getName())) continue;
                foundReferences.add(exit);
            }
        }
        return foundReferences;
    }
}

