/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemtree;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;
import javax.swing.JScrollPane;
import org.openbp.core.model.ModelObject;
import org.openbp.guiclient.model.item.itemtree.ItemTree;
import org.openbp.guiclient.model.item.itemtree.ItemTreeEvent;
import org.openbp.guiclient.model.item.itemtree.ItemTreeListener;
import org.openbp.guiclient.model.item.itemtree.ItemTreeState;
import org.openbp.swing.components.JStandardDialog;

public class ItemSelectionDialog
extends JStandardDialog
implements ItemTreeListener {
    private static final Dimension SIZE = new Dimension(300, 600);
    protected ItemTree tree;

    public ItemSelectionDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.setSize(SIZE);
        this.createTree();
        this.tree.addItemTreeListener(this);
        this.getMainPane().add(new JScrollPane(this.tree));
        this.getOkBtn().setEnabled(false);
    }

    public void rebuildTree() {
        this.tree.rebuildTree();
    }

    public ItemTreeState saveState() {
        return this.tree.saveState();
    }

    public void restoreState(ItemTreeState state) {
        this.tree.restoreState(state);
    }

    public void expand(int level) {
        this.tree.expand(level);
    }

    protected void createTree() {
        this.tree = new ItemTree();
    }

    @Override
    public void handleItemTreeEvent(ItemTreeEvent e) {
        List selection;
        if (e.eventType == 1) {
            selection = this.getSelectedObjects();
            this.getOkBtn().setEnabled(selection != null);
        }
        if (e.eventType == 2 && (selection = this.getSelectedObjects()) != null) {
            this.dispose();
        }
    }

    public List getSelectedObjects() {
        if (this.isCancelled()) {
            return null;
        }
        return this.tree.getSelectedObjects();
    }

    public void setSelectedObjects(List objects) {
        this.tree.setSelectedObjects(objects);
    }

    public void setRootObject(ModelObject rootObject) {
        this.tree.setRootObject(rootObject);
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
    }

    public void setSupportedItemTypes(String[] supportedItemTypes) {
        this.tree.setSupportedItemTypes(supportedItemTypes);
    }

    public void setSelectableItemTypes(String[] selectableItemTypes) {
        this.tree.setSelectableItemTypes(selectableItemTypes);
    }

    public void setSupportedObjectClasses(Class[] supportedObjectClasses) {
        this.tree.setSupportedObjectClasses(supportedObjectClasses);
    }

    public void setSelectableObjectClasses(Class[] selectableObjectClasses) {
        this.tree.setSelectableObjectClasses(selectableObjectClasses);
    }

    public void setShowGroups(boolean showGroups) {
        this.tree.setShowGroups(showGroups);
    }

    public void setSelectionMode(int selectionMode) {
        this.tree.setSelectionMode(selectionMode);
    }

    public ItemTree getTree() {
        return this.tree;
    }
}

