/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemtree;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.common.CollectionUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.string.TextUtil;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.ItemComparator;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.model.item.itemfilter.ItemFilter;
import org.openbp.guiclient.model.item.itemfilter.ItemFilterListener;
import org.openbp.guiclient.model.item.itemfilter.ItemFilterMgr;
import org.openbp.guiclient.model.item.itemfilter.ItemTypeFilter;
import org.openbp.guiclient.model.item.itemtree.ItemTreeEvent;
import org.openbp.guiclient.model.item.itemtree.ItemTreeListener;
import org.openbp.guiclient.model.item.itemtree.ItemTreeState;
import org.openbp.guiclient.util.DisplayObjectComparator;
import org.openbp.guiclient.util.DisplayObjectTreeNode;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.gui.StdIcons;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.tree.TreeExpander;

public class ItemTree
extends JTree
implements ItemFilterListener {
    public static final int SELECTION_NONE = 0;
    public static final int SELECTION_SINGLE = 1;
    public static final int SELECTION_MULTI = 4;
    private ModelObject rootObject;
    private ItemFilterMgr filterMgr;
    private ItemTypeFilter itemTypeFilter;
    private String[] supportedItemTypes;
    private String[] selectableItemTypes;
    private Class[] supportedObjectClasses;
    private Class[] selectableObjectClasses;
    private boolean showGroups = true;
    private int selectionMode;
    private TreeExpander treeExpander;
    protected EventListenerList listenerList;
    private ItemComparator itemComparator = new ItemComparator();

    public ItemTree() {
        this.treeExpander = new TreeExpander((JTree)this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setRootVisible(true);
        this.setToggleClickCount(2);
        this.setSelectionMode(0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 10) {
                    ItemTreeNode treeNode = (ItemTreeNode)((Object)ItemTree.this.getLastSelectedPathComponent());
                    if (treeNode instanceof ModelNode || treeNode instanceof GroupNode) {
                        Object[] nodes = ((DefaultTreeModel)ItemTree.this.getModel()).getPathToRoot((TreeNode)((Object)treeNode));
                        TreePath path = new TreePath(nodes);
                        if (ItemTree.this.isExpanded(path)) {
                            ItemTree.this.collapsePath(path);
                        } else {
                            ItemTree.this.expandPath(path);
                        }
                        return;
                    }
                    ItemTreeEvent event = new ItemTreeEvent(ItemTree.this, 2);
                    event.treeNode = (ItemTreeNode)((Object)ItemTree.this.getLastSelectedPathComponent());
                    event.keyEvent = e;
                    ItemTree.this.fireItemTreeEvent(event);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getButton() == 3) {
                    TreePath path2 = ItemTree.this.getPathForLocation(e.getX(), e.getY());
                    ItemTreeEvent event = new ItemTreeEvent(ItemTree.this, 3);
                    if (path2 != null) {
                        ItemTree.this.addSelectionPath(path2);
                        event.treeNode = (ItemTreeNode)((Object)path2.getLastPathComponent());
                    } else {
                        ItemTree.this.clearSelection();
                    }
                    event.mouseEvent = e;
                    ItemTree.this.fireItemTreeEvent(event);
                } else if (e.getClickCount() >= 2 && (path = ItemTree.this.getSelectionPath()) != null) {
                    ItemTreeEvent event = new ItemTreeEvent(ItemTree.this, 2);
                    event.treeNode = (ItemTreeNode)((Object)path.getLastPathComponent());
                    event.mouseEvent = e;
                    ItemTree.this.fireItemTreeEvent(event);
                }
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ItemTreeEvent event = new ItemTreeEvent(ItemTree.this, 1);
                event.treeNode = (ItemTreeNode)((Object)ItemTree.this.getLastSelectedPathComponent());
                ItemTree.this.fireItemTreeEvent(event);
            }
        });
        this.setCellRenderer(new ItemTreeCellRenderer());
    }

    public void rebuildTree() {
        ItemTreeState state = this.saveState();
        ModelObjectNode rootNode = null;
        rootNode = this.rootObject != null ? (this.rootObject instanceof Model ? new ModelNode((Model)this.rootObject, null) : (this.rootObject instanceof Item ? new ItemNode((Item)this.rootObject, null) : new ModelObjectNode(this.rootObject, null))) : new ModelNode();
        ((ItemTreeNode)rootNode).addChildObjects();
        rootNode.removeEmptyChildren();
        ((DefaultTreeModel)this.getModel()).setRoot((TreeNode)((Object)rootNode));
        this.restoreState(state);
    }

    public ItemTreeState saveState() {
        ItemTreeState state = new ItemTreeState();
        ArrayList<ModelQualifier> expandedQualifiers = null;
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Object o;
            TreePath path = this.getPathForRow(iRow);
            if (!this.isExpanded(path) || !((o = path.getLastPathComponent()) instanceof ItemTreeNode)) continue;
            ItemTreeNode node = (ItemTreeNode)((Object)o);
            if (expandedQualifiers == null) {
                expandedQualifiers = new ArrayList<ModelQualifier>();
            }
            expandedQualifiers.add(node.getQualifier());
        }
        state.setExpandedQualifiers(expandedQualifiers);
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            ArrayList<ModelQualifier> selectedQualifiers = new ArrayList<ModelQualifier>();
            for (int i = 0; i < paths.length; ++i) {
                Object o = paths[i].getLastPathComponent();
                if (!(o instanceof ItemTreeNode)) continue;
                ItemTreeNode node = (ItemTreeNode)((Object)o);
                selectedQualifiers.add(node.getQualifier());
            }
            state.setSelectedQualifiers(selectedQualifiers);
        }
        return state;
    }

    public void restoreState(ItemTreeState state) {
        List expandedQualifiers = state.getExpandedQualifiers();
        if (expandedQualifiers != null) {
            int n = expandedQualifiers.size();
            for (int i = 0; i < n; ++i) {
                ModelQualifier qualifier = (ModelQualifier)expandedQualifiers.get(i);
                ItemTreeNode node = this.findNodeByQualifier(qualifier);
                if (node == null) continue;
                Object[] nodes = ((DefaultTreeModel)this.getModel()).getPathToRoot((TreeNode)((Object)node));
                TreePath path = new TreePath(nodes);
                this.expandPath(path);
            }
        }
        this.clearSelection();
        List selectedQualifiers = state.getSelectedQualifiers();
        if (selectedQualifiers != null) {
            int n = selectedQualifiers.size();
            for (int i = 0; i < n; ++i) {
                ModelQualifier qualifier = (ModelQualifier)selectedQualifiers.get(i);
                ItemTreeNode node = this.findNodeByQualifier(qualifier);
                if (node == null) continue;
                Object[] nodes = ((DefaultTreeModel)this.getModel()).getPathToRoot((TreeNode)((Object)node));
                TreePath path = new TreePath(nodes);
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    this.expandPath(parentPath);
                }
                this.addSelectionPath(path);
                if (i != 0) continue;
                this.scrollPathToVisible(path);
            }
        }
    }

    public void expand(int level) {
        this.treeExpander.simpleExpand(level);
    }

    public TreeExpander getTreeExpander() {
        return this.treeExpander;
    }

    public Model determineSelectedModel() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        for (int i = 0; i < paths.length; ++i) {
            ItemTreeNode node = (ItemTreeNode)((Object)paths[i].getLastPathComponent());
            if (node instanceof ModelObjectNode) {
                ModelObject object = ((ModelObjectNode)node).getModelObject();
                return object.getOwningModel();
            }
            if (!(node instanceof GroupNode)) continue;
            return ((ModelNode)((Object)node.getParent())).getModel();
        }
        return null;
    }

    public List getSelectedObjects() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<ModelObject> list = null;
        for (int i = 0; i < paths.length; ++i) {
            ModelObject object;
            ItemTreeNode node = (ItemTreeNode)((Object)paths[i].getLastPathComponent());
            if (!(node instanceof ModelObjectNode) || !this.isSelectable(object = ((ModelObjectNode)node).getModelObject())) continue;
            if (list == null) {
                list = new ArrayList<ModelObject>();
            }
            list.add(object);
        }
        return list;
    }

    public void setSelectedObjects(List objects) {
        this.clearSelection();
        if (objects != null) {
            int n = objects.size();
            for (int i = 0; i < n; ++i) {
                Object o = objects.get(i);
                ItemTreeNode node = this.findNodeByObject(o);
                if (node == null) continue;
                Object[] nodes = ((DefaultTreeModel)this.getModel()).getPathToRoot((TreeNode)((Object)node));
                TreePath path = new TreePath(nodes);
                this.addSelectionPath(path);
            }
        }
    }

    public void performAlternativeSelection() {
        TreePath newPath = this.determineAlternativeSelection();
        if (newPath != null) {
            this.clearSelection();
            this.addSelectionPath(newPath);
        }
    }

    public TreePath determineAlternativeSelection() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        TreeNode node = (TreeNode)paths[0].getLastPathComponent();
        TreeNode parentNode = node.getParent();
        if (parentNode == null) {
            return null;
        }
        TreeNode ret = parentNode;
        int nChilds = parentNode.getChildCount();
        for (int i = 0; i < nChilds; ++i) {
            TreeNode childNode = parentNode.getChildAt(i);
            if (!childNode.equals(node)) continue;
            if (i + 1 < nChilds) {
                ret = parentNode.getChildAt(i + 1);
                break;
            }
            if (i == 0) break;
            ret = parentNode.getChildAt(i - 1);
            break;
        }
        return new TreePath(((DefaultTreeModel)this.getModel()).getPathToRoot(ret));
    }

    public ItemTreeNode findNodeByObject(Object object) {
        return this.findNodeByObject(object, (ItemTreeNode)((Object)((DefaultTreeModel)this.getModel()).getRoot()));
    }

    public ItemTreeNode findNodeByObject(Object object, ItemTreeNode node) {
        ModelObject o;
        if (node instanceof ModelObjectNode && (o = ((ModelObjectNode)node).getModelObject()) == object) {
            return node;
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            ItemTreeNode child = (ItemTreeNode)((Object)node.getChildAt(i));
            ItemTreeNode ret = this.findNodeByObject(object, child);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public ItemTreeNode findNodeByQualifier(ModelQualifier qualifier) {
        return this.findNodeByQualifier(qualifier, (ItemTreeNode)((Object)((DefaultTreeModel)this.getModel()).getRoot()));
    }

    public ItemTreeNode findNodeByQualifier(ModelQualifier qualifier, ItemTreeNode node) {
        ModelQualifier j = node.getQualifier();
        if (j.equals((Object)qualifier)) {
            return node;
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            ItemTreeNode child = (ItemTreeNode)((Object)node.getChildAt(i));
            ItemTreeNode ret = this.findNodeByQualifier(qualifier, child);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public TreePath findPathByObject(Object o) {
        ItemTreeNode node = this.findNodeByObject(o);
        if (node != null) {
            Object[] nodes = ((DefaultTreeModel)this.getModel()).getPathToRoot((TreeNode)((Object)node));
            TreePath path = new TreePath(nodes);
            return path;
        }
        return null;
    }

    public ModelObject getRootObject() {
        return this.rootObject;
    }

    public void setRootObject(ModelObject rootObject) {
        this.rootObject = rootObject;
    }

    public String[] getSupportedItemTypes() {
        return this.supportedItemTypes;
    }

    public void setSupportedItemTypes(String[] supportedItemTypes) {
        this.supportedItemTypes = supportedItemTypes;
    }

    public String[] getSelectableItemTypes() {
        return this.selectableItemTypes;
    }

    public void setSelectableItemTypes(String[] selectableItemTypes) {
        this.selectableItemTypes = selectableItemTypes;
    }

    public Class[] getSupportedObjectClasses() {
        return this.supportedObjectClasses;
    }

    public void setSupportedObjectClasses(Class[] supportedObjectClasses) {
        this.supportedObjectClasses = supportedObjectClasses;
    }

    public Class[] getSelectableObjectClasses() {
        return this.selectableObjectClasses;
    }

    public void setSelectableObjectClasses(Class[] selectableObjectClasses) {
        this.selectableObjectClasses = selectableObjectClasses;
    }

    public ItemFilterMgr getFilterMgr() {
        return this.filterMgr;
    }

    public void setFilterMgr(ItemFilterMgr filterMgr) {
        this.filterMgr = filterMgr;
    }

    public ItemTypeFilter getItemTypeFilter() {
        return this.itemTypeFilter;
    }

    public void setItemTypeFilter(ItemTypeFilter itemTypeFilter) {
        this.itemTypeFilter = itemTypeFilter;
    }

    public boolean isShowGroups() {
        return this.showGroups;
    }

    public void setShowGroups(boolean showGroups) {
        this.showGroups = showGroups;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        int x = selectionMode;
        if (x == 0) {
            x = 1;
        }
        this.getSelectionModel().setSelectionMode(x);
    }

    public void addItemTreeListener(ItemTreeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        } else if (SwingUtil.containsListener((EventListenerList)this.listenerList, ItemTreeListener.class, (EventListener)listener)) {
            return;
        }
        this.listenerList.add(ItemTreeListener.class, listener);
    }

    public void removeItemTreeListener(ItemTreeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ItemTreeListener.class, listener);
        }
    }

    public void fireItemTreeEvent(ItemTreeEvent e) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ItemTreeListener.class) continue;
                ((ItemTreeListener)listeners[i + 1]).handleItemTreeEvent(e);
                if (e.cancel) break;
            }
        }
    }

    protected boolean isSupported(ModelObject o) {
        return this.checkObject(o, this.supportedItemTypes, this.supportedObjectClasses, 4);
    }

    protected boolean isSelectable(ModelObject o) {
        return this.checkObject(o, this.selectableItemTypes, this.selectableObjectClasses, 5);
    }

    private boolean checkObject(ModelObject o, String[] itemList, Class[] classList, int eventType) {
        boolean ret = false;
        if (o instanceof Item) {
            if (itemList != null) {
                String itemType = ((Item)o).getItemType();
                for (int i = 0; i < itemList.length; ++i) {
                    if (!itemType.equals(itemList[i])) continue;
                    ret = true;
                    break;
                }
            }
        } else if (classList != null) {
            Class<?> cls = o.getClass();
            for (int i = 0; i < classList.length; ++i) {
                if (!classList[i].isAssignableFrom(cls)) continue;
                ret = true;
                break;
            }
        }
        if (ret) {
            ItemTreeEvent event = new ItemTreeEvent(this, eventType);
            event.object = o;
            this.fireItemTreeEvent(event);
            if (event.cancel) {
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public void applyFilter(ItemFilterMgr mgr, ItemFilter filter) {
        this.rebuildTree();
    }

    public class GroupNode
    extends ItemTreeNode {
        public GroupNode(String group, ItemTreeNode parent) {
            super((DisplayObject)new DisplayObjectImpl(group), parent);
        }

        public boolean isLeaf() {
            return false;
        }

        @Override
        public Icon getIcon(boolean isExpanded) {
            return isExpanded ? StdIcons.openFolderIcon : StdIcons.closedFolderIcon;
        }

        @Override
        public ModelQualifier getQualifier() {
            ModelQualifier j = ((ModelNode)((Object)this.getParent())).getQualifier();
            j.setObjectPath(this.object.getName());
            return j;
        }
    }

    public class ItemNode
    extends ModelObjectNode {
        public ItemNode(Item item, ItemTreeNode parent) {
            super((ModelObject)item, parent);
        }

        public Item getItem() {
            return (Item)this.object;
        }

        public boolean isLeaf() {
            return ItemTree.this.supportedObjectClasses == null;
        }
    }

    public class ModelNode
    extends ModelObjectNode {
        public ModelNode() {
        }

        public ModelNode(Model model, ItemTreeNode parent) {
            super((ModelObject)model, parent);
        }

        @Override
        protected void addChildObjects() {
            Model model = this.getModel();
            if (model == null) {
                this.addModels();
            } else {
                this.addItems();
            }
        }

        public Model getModel() {
            return (Model)this.object;
        }

        public boolean isLeaf() {
            if (ItemTree.this.supportedObjectClasses == null && ItemTree.this.supportedItemTypes != null && ItemTree.this.supportedItemTypes.length == 1 && ItemTree.this.supportedItemTypes[0].equals("Model")) {
                return super.isLeaf();
            }
            return false;
        }

        private void addModels() {
            List models = ModelConnector.getInstance().getModels();
            if (models != null) {
                Collections.sort(models, DisplayObjectComparator.getInstance());
                int n = models.size();
                for (int i = 0; i < n; ++i) {
                    Model subModel = (Model)models.get(i);
                    ModelNode modelNode = new ModelNode(subModel, (ItemTreeNode)this);
                    this.addChild(modelNode);
                    modelNode.addChildObjects();
                }
            }
        }

        private void addItems() {
            ArrayList<Item> ungroupedItems = null;
            HashMap<String, ArrayList<Item>> groupTable = null;
            String[] types = ItemTree.this.getSupportedItemTypes();
            if (types == null) {
                types = ModelConnector.getInstance().getItemTypes(3);
                ItemTree.this.setSupportedItemTypes(types);
            }
            ItemTree.this.itemComparator.setItemTypes(types);
            for (int iTypes = 0; iTypes < types.length; ++iTypes) {
                Item item;
                String itemType = types[iTypes];
                if (ItemTree.this.itemTypeFilter != null && ItemTree.this.itemTypeFilter.isActive() && !ItemTree.this.itemTypeFilter.containsItemType(itemType)) continue;
                Iterator itItems = this.getModel().getItems(itemType);
                while (itItems.hasNext()) {
                    item = (Item)itItems.next();
                    if (ItemTree.this.filterMgr != null && !ItemTree.this.filterMgr.acceptsItem(item)) continue;
                    if (ungroupedItems == null) {
                        ungroupedItems = new ArrayList<Item>();
                    }
                    ungroupedItems.add(item);
                }
                if (ungroupedItems == null || !ItemTree.this.showGroups) continue;
                Iterator it = ungroupedItems.iterator();
                while (it.hasNext()) {
                    ArrayList<Item> items;
                    item = (Item)it.next();
                    String group = item.getFunctionalGroup();
                    if (group == null) continue;
                    it.remove();
                    if (groupTable == null) {
                        groupTable = new HashMap<String, ArrayList<Item>>();
                    }
                    if ((items = (ArrayList<Item>)groupTable.get(group)) == null) {
                        items = new ArrayList<Item>();
                        groupTable.put(group, items);
                    }
                    items.add(item);
                }
            }
            if (ungroupedItems != null && ungroupedItems.size() > 0) {
                Collections.sort(ungroupedItems, ItemTree.this.itemComparator);
                int nItems = ungroupedItems.size();
                for (int iItems = 0; iItems < nItems; ++iItems) {
                    Item item = (Item)ungroupedItems.get(iItems);
                    ItemNode itemNode = new ItemNode(item, (ItemTreeNode)this);
                    this.addChild(itemNode);
                    itemNode.addChildObjects();
                }
            }
            if (groupTable != null) {
                ArrayList groups = CollectionUtil.iteratorToArrayList(groupTable.keySet().iterator());
                Collections.sort(groups);
                int nGroups = groups.size();
                for (int iGroups = 0; iGroups < nGroups; ++iGroups) {
                    String group = (String)groups.get(iGroups);
                    List items = (List)groupTable.get(group);
                    GroupNode groupNode = new GroupNode(group, (ItemTreeNode)this);
                    this.addChild(groupNode);
                    Collections.sort(items, ItemTree.this.itemComparator);
                    int nItems = items.size();
                    for (int iItems = 0; iItems < nItems; ++iItems) {
                        Item item = (Item)items.get(iItems);
                        ItemNode itemNode = new ItemNode(item, (ItemTreeNode)groupNode);
                        groupNode.addChild(itemNode);
                        itemNode.addChildObjects();
                    }
                }
            }
        }
    }

    public class ModelObjectNode
    extends ItemTreeNode {
        public ModelObjectNode() {
        }

        public ModelObjectNode(ModelObject object, ItemTreeNode parent) {
            super((DisplayObject)object, parent);
        }

        public ModelObject getModelObject() {
            return (ModelObject)this.object;
        }

        @Override
        public Icon getIcon(boolean isExpanded) {
            String iconName;
            if (this.getModelObject() != null && (iconName = this.getModelObject().getModelObjectSymbolName()) != null) {
                return ItemIconMgr.getInstance().getIcon(iconName, 16);
            }
            return null;
        }

        @Override
        public String[] getInfoText() {
            if (this.getModelObject() != null) {
                return this.getModelObject().getInfoText();
            }
            return null;
        }

        @Override
        public ModelQualifier getQualifier() {
            if (this.getModelObject() != null) {
                return this.getModelObject().getQualifier();
            }
            return new ModelQualifier();
        }

        @Override
        protected void addChildObjects() {
            List children;
            if (ItemTree.this.supportedObjectClasses == null) {
                return;
            }
            if (this.getModelObject() != null && (children = this.getModelObject().getChildren()) != null) {
                Collections.sort(children, DisplayObjectComparator.getInstance());
                int n = children.size();
                for (int i = 0; i < n; ++i) {
                    ModelObject child = (ModelObject)children.get(i);
                    if (!ItemTree.this.isSupported(child)) continue;
                    ModelObjectNode objectNode = new ModelObjectNode(child, (ItemTreeNode)this);
                    this.addChild(objectNode);
                    objectNode.addChildObjects();
                }
            }
        }
    }

    public abstract class ItemTreeNode
    extends DisplayObjectTreeNode {
        public ItemTreeNode() {
        }

        public ItemTreeNode(DisplayObject obj, ItemTreeNode parent) {
            super(obj, (TreeNode)((Object)parent));
        }

        public abstract Icon getIcon(boolean var1);

        public String[] getInfoText() {
            return null;
        }

        public abstract ModelQualifier getQualifier();

        public boolean matchesQualifier(ModelQualifier other) {
            return this.getQualifier().matches((Object)other);
        }

        protected void addChildObjects() {
        }

        protected void removeEmptyChildren() {
            List childs = this.getChildList();
            if (childs != null) {
                for (int i = 0; i < childs.size(); ++i) {
                    ItemTreeNode child = (ItemTreeNode)((Object)childs.get(i));
                    if (!(child instanceof ModelObjectNode)) continue;
                    ((ModelObjectNode)child).removeEmptyChildren();
                    if (child instanceof ModelNode || child.getChildCount() != 0 || child.isLeaf()) continue;
                    this.removeChild(child);
                    --i;
                }
            }
        }
    }

    private class ItemTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ItemTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel && value instanceof ItemTreeNode) {
                ItemTreeNode node = (ItemTreeNode)((Object)value);
                Icon icon = node.getIcon(expanded);
                icon = (Icon)DecorationMgr.decorate(node.getObject(), "icon", icon);
                String[] infoText = node.getInfoText();
                JLabel label = (JLabel)c;
                label.setIcon(icon);
                if (infoText != null) {
                    label.setToolTipText(TextUtil.convertToHTML((String[])infoText, (boolean)true, (int)1, (int)50));
                }
            }
            return c;
        }
    }
}

