/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.plugins.server;

import org.openbp.common.ExceptionUtil;
import org.openbp.core.OpenBPException;
import org.openbp.core.model.modelmgr.ModelNotificationService;
import org.openbp.core.remote.ClientSession;
import org.openbp.guiclient.remote.ServerConnection;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.swing.components.JMsgBox;

public class ServerConnectionPlugin
extends AbstractPlugin {
    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.standard";
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.serverconnection";
        }

        public JaspiraEventHandlerCode reload(JaspiraActionEvent jae) {
            ServerConnection serverConnection = ServerConnection.getInstance();
            if (!serverConnection.isConnected()) {
                try {
                    serverConnection.connect(true);
                    JaspiraEventMgr.fireGlobalEvent("plugin.serverconnection.reconnect");
                    String message = ServerConnectionPlugin.this.getPluginResourceCollection().getRequiredString("reconnect.okmessage");
                    JMsgBox.show(null, (String)message, (int)65536);
                }
                catch (OpenBPException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    String message = ServerConnectionPlugin.this.getPluginResourceCollection().getRequiredString("reconnect.failedmessage");
                    String exceptionMessage = ExceptionUtil.getNestedMessage((Throwable)e);
                    JMsgBox.showFormat(null, (String)message, (Object)exceptionMessage, (int)262144);
                }
            } else {
                try {
                    ClientSession session = ServerConnection.getInstance().getSession();
                    ModelNotificationService mns = (ModelNotificationService)serverConnection.lookupService(ModelNotificationService.class);
                    mns.requestModelReset(session);
                    String message = ServerConnectionPlugin.this.getPluginResourceCollection().getRequiredString("okmessage");
                    JMsgBox.show(null, (String)message, (int)65536);
                }
                catch (OpenBPException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    String message = ServerConnectionPlugin.this.getPluginResourceCollection().getRequiredString("failedmessage");
                    JMsgBox.show(null, (String)message, (int)262144);
                }
            }
            return EVENT_CONSUMED;
        }
    }
}

