/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openbp.common.CollectionUtil;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.core.CoreConstants;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.type.ComplexTypeItem;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.itemtree.ItemSelectionDialog;
import org.openbp.guiclient.model.item.itemtree.ItemTreeState;
import org.openbp.guiclient.propertyeditors.ComponentSelectionEditorCustomizer;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.propertybrowser.editor.EditorParameterParser;
import org.openbp.jaspira.propertybrowser.editor.standard.StringEditor;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class ComponentSelectionEditor
extends StringEditor {
    private String itemType;
    private List supportedItemTypeList;
    private List selectableItemTypeList;
    private List supportedObjectClassList;
    private List selectableObjectClassList;
    protected String title;
    protected String customizerClassName;
    protected ComponentSelectionEditorCustomizer customizer;
    private boolean openSystemModel;
    protected Map properties;

    @Override
    public void createComponent() {
        super.createComponent();
        if (!this.readonly) {
            int h;
            BasicArrowButton btn = new BasicArrowButton(5);
            btn.setBorder((Border)new SimpleBorder(0, 2, 0, 2));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComponentSelectionEditor.this.showBrowser();
                }
            });
            btn.setEnabled(true);
            btn.setFocusable(false);
            btn.setRequestFocusEnabled(false);
            Dimension size = new Dimension(((JComponent)btn).getMinimumSize());
            size.height = h = this.textField.getHeight();
            btn.setMinimumSize(size);
            btn.setMaximumSize(size);
            btn.setPreferredSize(size);
            this.component = new EditorPanel(this.textField, btn);
            this.parseParams();
        }
    }

    @Override
    public void highlight(boolean on) {
        boolean show;
        boolean bl = show = on && this.textField.hasFocus();
        if (show) {
            this.textField.setSelectionStart(0);
            int length = this.textField.getText().length();
            this.textField.setSelectionEnd(length);
        } else {
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(0);
        }
        this.textField.getCaret().setVisible(show);
        this.textField.getCaret().setSelectionVisible(show);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentSelectionEditor.this.textField.repaint();
            }
        });
    }

    protected void parseParams() {
        EditorParameterParser parser = new EditorParameterParser(this);
        this.itemType = parser.getString("type");
        Iterator itNames = parser.get("propertyname");
        if (itNames.hasNext()) {
            this.properties = new HashMap();
            Iterator itValues = parser.get("propertyvalue");
            while (itNames.hasNext()) {
                String name = (String)itNames.next();
                Object value = itValues.next();
                this.properties.put(name, value);
            }
        }
        this.supportedItemTypeList = this.parseList(parser, "supporteditemtype", false);
        this.selectableItemTypeList = this.parseList(parser, "selectableitemtype", false);
        this.supportedObjectClassList = this.parseList(parser, "supportedobjectclass", true);
        this.selectableObjectClassList = this.parseList(parser, "selectableobjectclass", true);
        this.title = parser.getString("title");
        if (this.title == null) {
            this.title = "Component Selection";
        }
        String s = parser.getString("opensystemmodel");
        this.openSystemModel = "true".equals(s);
        this.customizerClassName = parser.getString("customizer");
    }

    private List parseList(EditorParameterParser parser, String key, boolean classNames) {
        ArrayList<String> list = null;
        Iterator it = parser.get(key);
        while (it.hasNext()) {
            String s = (String)it.next();
            if (list == null) {
                list = new ArrayList<String>();
            }
            if (classNames) {
                try {
                    Class<?> cls = Class.forName(s);
                    list.add((String)((Object)cls));
                }
                catch (ClassNotFoundException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                }
                continue;
            }
            list.add(s);
        }
        return list;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 10: 
            case 32: 
            case 40: {
                if (!e.isControlDown() && !e.isAltDown() && !e.isAltGraphDown()) break;
                this.showBrowser();
                e.consume();
                return;
            }
        }
        super.keyPressed(e);
    }

    public void showBrowser() {
        Object o = this.getObject();
        final Model model = o instanceof ModelObject ? ((ModelObject)o).getOwningModel() : null;
        final ItemSelectionDialog dlg = new ItemSelectionDialog(ApplicationUtil.getActiveWindow(), true);
        dlg.setTitle(this.title);
        dlg.setSelectionMode(1);
        dlg.setShowGroups(false);
        String[] supportedItemTypes = null;
        String[] selectableItemTypes = null;
        Class[] supportedObjectClasses = null;
        Class[] selectableObjectClasses = null;
        if (this.itemType != null) {
            if (this.supportedItemTypeList == null) {
                this.supportedItemTypeList = new ArrayList();
                this.supportedItemTypeList.add("Model");
                if (!this.itemType.equals("Model")) {
                    this.supportedItemTypeList.add(this.itemType);
                }
            }
            if (this.selectableItemTypeList == null) {
                this.selectableItemTypeList = new ArrayList();
                this.selectableItemTypeList.add(this.itemType);
            }
        }
        if (this.supportedItemTypeList != null) {
            supportedItemTypes = CollectionUtil.toStringArray((Collection)this.supportedItemTypeList);
        }
        if (this.selectableItemTypeList != null) {
            selectableItemTypes = CollectionUtil.toStringArray((Collection)this.selectableItemTypeList);
        }
        if (this.supportedObjectClassList != null) {
            supportedObjectClasses = (Class[])CollectionUtil.toArray((Collection)this.supportedObjectClassList, Class.class);
        }
        if (this.selectableObjectClassList != null) {
            selectableObjectClasses = (Class[])CollectionUtil.toArray((Collection)this.selectableObjectClassList, Class.class);
        }
        dlg.setSupportedItemTypes(supportedItemTypes);
        dlg.setSelectableItemTypes(selectableItemTypes);
        dlg.setSupportedObjectClasses(supportedObjectClasses);
        dlg.setSelectableObjectClasses(selectableObjectClasses);
        String objectRef = (String)this.value;
        ModelObject object = null;
        if (objectRef != null && this.itemType != null) {
            try {
                if (model != null) {
                    object = model.resolveObjectRef(objectRef, this.itemType);
                } else {
                    ModelQualifier qualifier = new ModelQualifier(objectRef);
                    qualifier.setItemType(this.itemType);
                    object = ModelConnector.getInstance().getItemByQualifier(qualifier, false);
                }
            }
            catch (ModelException e) {
                // empty catch block
            }
        }
        ItemTreeState state = new ItemTreeState();
        Model currentModel = null;
        if (object != null) {
            currentModel = object.getOwningModel();
        } else {
            if (model != null) {
                currentModel = model;
            }
            if (this.openSystemModel) {
                currentModel = ModelConnector.getInstance().getModelByQualifier(CoreConstants.SYSTEM_MODEL_QUALIFIER);
            }
        }
        if (currentModel != null) {
            state.addExpandedQualifier(currentModel.getQualifier());
        }
        if (object != null) {
            state.addSelectedQualifier(object.getQualifier());
        } else if (objectRef != null) {
            state.addSelectedQualifier(new ModelQualifier(objectRef));
        } else if (currentModel != null) {
            state.addSelectedQualifier(currentModel.getQualifier());
        }
        if (this.customizer == null && this.customizerClassName != null) {
            try {
                this.customizer = (ComponentSelectionEditorCustomizer)ReflectUtil.instantiate((String)this.customizerClassName, ComponentSelectionEditorCustomizer.class, (String)"component selection editor customizer class");
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
        if (this.customizer != null && !this.customizer.initializeDialog(this, dlg)) {
            return;
        }
        dlg.rebuildTree();
        dlg.expand(1);
        dlg.restoreState(state);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                List selection = dlg.getSelectedObjects();
                if (selection != null) {
                    ModelObject selectedObject = (ModelObject)selection.get(0);
                    if (ComponentSelectionEditor.this.customizer != null && !ComponentSelectionEditor.this.customizer.dialogClosed(ComponentSelectionEditor.this, dlg, selectedObject)) {
                        return;
                    }
                    String objectRef = null;
                    if (model != null && !(selectedObject instanceof ComplexTypeItem)) {
                        objectRef = model.determineObjectRef(selectedObject);
                    }
                    if (objectRef == null) {
                        objectRef = selectedObject.getQualifier().toString();
                    }
                    ComponentSelectionEditor.this.textField.setText(objectRef);
                    ComponentSelectionEditor.this.textField.requestFocus();
                    ComponentSelectionEditor.this.propertyChanged();
                } else if (ComponentSelectionEditor.this.customizer != null) {
                    ComponentSelectionEditor.this.customizer.dialogClosed(ComponentSelectionEditor.this, dlg, null);
                }
            }
        });
        if (this.customizer != null && !this.customizer.dialogInitialized(this, dlg)) {
            return;
        }
        dlg.setVisible(true);
    }

    private static class EditorPanel
    extends JPanel {
        JTextField textField;

        public EditorPanel(JTextField textField, JButton btn) {
            super(new BorderLayout());
            this.setFocusable(false);
            this.textField = textField;
            textField.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 2), textField.getBorder()));
            this.add((Component)textField, "Center");
            this.add((Component)btn, "East");
        }

        @Override
        public void requestFocus() {
            this.textField.requestFocus();
        }
    }
}

