/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.propertyeditors;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.property.PropertyAccessUtil;
import org.openbp.common.property.PropertyException;
import org.openbp.core.model.ModelObject;
import org.openbp.guiclient.model.item.itemtree.DataMemberSelectionDlg;
import org.openbp.guiclient.propertyeditors.ComponentSelectionEditor;
import org.openbp.guiclient.propertyeditors.ComponentSelectionEditorCustomizer;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.propertybrowser.editor.EditorParameterParser;

public class DataMemberPathSelectionEditor
extends ComponentSelectionEditor {
    private String rootObjectPropertyPath;

    @Override
    protected void parseParams() {
        EditorParameterParser parser = new EditorParameterParser(this);
        Iterator itNames = parser.get("propertyname");
        if (itNames.hasNext()) {
            this.properties = new HashMap();
            Iterator itValues = parser.get("propertyvalue");
            while (itNames.hasNext()) {
                String name = (String)itNames.next();
                Object value = itValues.next();
                this.properties.put(name, value);
            }
        }
        this.rootObjectPropertyPath = parser.getString("rootobjectpropertypath");
        this.title = parser.getString("title");
        if (this.title == null) {
            this.title = "Data Member Path Selection";
        }
        this.customizerClassName = parser.getString("customizer");
    }

    @Override
    public void showBrowser() {
        final DataMemberSelectionDlg dlg = new DataMemberSelectionDlg(ApplicationUtil.getActiveWindow(), true);
        dlg.setTitle(this.title);
        if (this.rootObjectPropertyPath != null) {
            Object o = this.getObject();
            try {
                ModelObject rootObject = (ModelObject)PropertyAccessUtil.getProperty((Object)o, (String)this.rootObjectPropertyPath);
                dlg.setRootObject(rootObject);
            }
            catch (PropertyException e) {
                LogUtil.error(this.getClass(), (String)"Error accessing property $0 in object of type $1", (Object)this.rootObjectPropertyPath, (Object)o.getClass().getName(), (Object)((Object)e));
            }
            catch (ClassCastException e) {
                LogUtil.error(this.getClass(), (String)"Value of property $0 in object of type $1 is not a ModelObject", (Object)this.rootObjectPropertyPath, (Object)o.getClass().getName(), (Object)e);
            }
        }
        dlg.rebuildTree();
        dlg.expand(1);
        String memberPath = (String)this.value;
        dlg.setSelectedMemberPath(memberPath);
        if (this.customizer == null && this.customizerClassName != null) {
            try {
                this.customizer = (ComponentSelectionEditorCustomizer)ReflectUtil.instantiate((String)this.customizerClassName, ComponentSelectionEditorCustomizer.class, (String)"component selection editor customizer class");
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
        if (this.customizer != null && !this.customizer.initializeDialog(this, dlg)) {
            return;
        }
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                String memberPath = dlg.getSelectedMemberPath();
                if (DataMemberPathSelectionEditor.this.customizer != null && !DataMemberPathSelectionEditor.this.customizer.dialogClosed(DataMemberPathSelectionEditor.this, dlg, memberPath)) {
                    return;
                }
                if (memberPath != null) {
                    DataMemberPathSelectionEditor.this.textField.setText(memberPath);
                    DataMemberPathSelectionEditor.this.textField.requestFocus();
                    DataMemberPathSelectionEditor.this.propertyChanged();
                }
            }
        });
        if (this.customizer != null && !this.customizer.dialogInitialized(this, dlg)) {
            return;
        }
        dlg.setVisible(true);
    }
}

